/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The override parameters for a single folder that is being imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobFolderOverrideParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobFolderOverrideParameters.Builder, AssetBundleImportJobFolderOverrideParameters> {
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(AssetBundleImportJobFolderOverrideParameters::folderId))
            .setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssetBundleImportJobFolderOverrideParameters::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderArn").getter(getter(AssetBundleImportJobFolderOverrideParameters::parentFolderArn))
            .setter(setter(Builder::parentFolderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDER_ID_FIELD, NAME_FIELD,
            PARENT_FOLDER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String folderId;

    private final String name;

    private final String parentFolderArn;

    private AssetBundleImportJobFolderOverrideParameters(BuilderImpl builder) {
        this.folderId = builder.folderId;
        this.name = builder.name;
        this.parentFolderArn = builder.parentFolderArn;
    }

    /**
     * <p>
     * The ID of the folder that you want to apply overrides to.
     * </p>
     * 
     * @return The ID of the folder that you want to apply overrides to.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * A new name for the folder.
     * </p>
     * 
     * @return A new name for the folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new parent folder arn. This change can only be applied if the import creates a brand new folder. Existing
     * folders cannot be moved.
     * </p>
     * 
     * @return A new parent folder arn. This change can only be applied if the import creates a brand new folder.
     *         Existing folders cannot be moved.
     */
    public final String parentFolderArn() {
        return parentFolderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobFolderOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobFolderOverrideParameters other = (AssetBundleImportJobFolderOverrideParameters) obj;
        return Objects.equals(folderId(), other.folderId()) && Objects.equals(name(), other.name())
                && Objects.equals(parentFolderArn(), other.parentFolderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobFolderOverrideParameters").add("FolderId", folderId()).add("Name", name())
                .add("ParentFolderArn", parentFolderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParentFolderArn":
            return Optional.ofNullable(clazz.cast(parentFolderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobFolderOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobFolderOverrideParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobFolderOverrideParameters> {
        /**
         * <p>
         * The ID of the folder that you want to apply overrides to.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * A new name for the folder.
         * </p>
         * 
         * @param name
         *        A new name for the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new parent folder arn. This change can only be applied if the import creates a brand new folder. Existing
         * folders cannot be moved.
         * </p>
         * 
         * @param parentFolderArn
         *        A new parent folder arn. This change can only be applied if the import creates a brand new folder.
         *        Existing folders cannot be moved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderArn(String parentFolderArn);
    }

    static final class BuilderImpl implements Builder {
        private String folderId;

        private String name;

        private String parentFolderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobFolderOverrideParameters model) {
            folderId(model.folderId);
            name(model.name);
            parentFolderArn(model.parentFolderArn);
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getParentFolderArn() {
            return parentFolderArn;
        }

        public final void setParentFolderArn(String parentFolderArn) {
            this.parentFolderArn = parentFolderArn;
        }

        @Override
        public final Builder parentFolderArn(String parentFolderArn) {
            this.parentFolderArn = parentFolderArn;
            return this;
        }

        @Override
        public AssetBundleImportJobFolderOverrideParameters build() {
            return new AssetBundleImportJobFolderOverrideParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
