/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a dropdown list with buttons that are used to select a single value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDropDownControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDropDownControl.Builder, ParameterDropDownControl> {
    private static final SdkField<String> PARAMETER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterControlId").getter(getter(ParameterDropDownControl::parameterControlId))
            .setter(setter(Builder::parameterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControlId").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ParameterDropDownControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(ParameterDropDownControl::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<DropDownControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<DropDownControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(ParameterDropDownControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(DropDownControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ParameterDropDownControl::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ParameterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField
            .<ParameterSelectableValues> builder(MarshallingType.SDK_POJO).memberName("SelectableValues")
            .getter(getter(ParameterDropDownControl::selectableValues)).setter(setter(Builder::selectableValues))
            .constructor(ParameterSelectableValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()).build();

    private static final SdkField<CascadingControlConfiguration> CASCADING_CONTROL_CONFIGURATION_FIELD = SdkField
            .<CascadingControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CascadingControlConfiguration")
            .getter(getter(ParameterDropDownControl::cascadingControlConfiguration))
            .setter(setter(Builder::cascadingControlConfiguration))
            .constructor(CascadingControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CascadingControlConfiguration")
                    .build()).build();

    private static final SdkField<String> COMMIT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMode").getter(getter(ParameterDropDownControl::commitModeAsString))
            .setter(setter(Builder::commitMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_PARAMETER_NAME_FIELD, DISPLAY_OPTIONS_FIELD, TYPE_FIELD, SELECTABLE_VALUES_FIELD,
            CASCADING_CONTROL_CONFIGURATION_FIELD, COMMIT_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterControlId;

    private final String title;

    private final String sourceParameterName;

    private final DropDownControlDisplayOptions displayOptions;

    private final String type;

    private final ParameterSelectableValues selectableValues;

    private final CascadingControlConfiguration cascadingControlConfiguration;

    private final String commitMode;

    private ParameterDropDownControl(BuilderImpl builder) {
        this.parameterControlId = builder.parameterControlId;
        this.title = builder.title;
        this.sourceParameterName = builder.sourceParameterName;
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
        this.cascadingControlConfiguration = builder.cascadingControlConfiguration;
        this.commitMode = builder.commitMode;
    }

    /**
     * <p>
     * The ID of the <code>ParameterDropDownControl</code>.
     * </p>
     * 
     * @return The ID of the <code>ParameterDropDownControl</code>.
     */
    public final String parameterControlId() {
        return parameterControlId;
    }

    /**
     * <p>
     * The title of the <code>ParameterDropDownControl</code>.
     * </p>
     * 
     * @return The title of the <code>ParameterDropDownControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source parameter name of the <code>ParameterDropDownControl</code>.
     * </p>
     * 
     * @return The source parameter name of the <code>ParameterDropDownControl</code>.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final DropDownControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type parameter name of the <code>ParameterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type parameter name of the <code>ParameterDropDownControl</code>.
     * @see SheetControlListType
     */
    public final SheetControlListType type() {
        return SheetControlListType.fromValue(type);
    }

    /**
     * <p>
     * The type parameter name of the <code>ParameterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type parameter name of the <code>ParameterDropDownControl</code>.
     * @see SheetControlListType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of selectable values that are used in a control.
     * </p>
     * 
     * @return A list of selectable values that are used in a control.
     */
    public final ParameterSelectableValues selectableValues() {
        return selectableValues;
    }

    /**
     * <p>
     * The values that are displayed in a control can be configured to only show values that are valid based on what's
     * selected in other controls.
     * </p>
     * 
     * @return The values that are displayed in a control can be configured to only show values that are valid based on
     *         what's selected in other controls.
     */
    public final CascadingControlConfiguration cascadingControlConfiguration() {
        return cascadingControlConfiguration;
    }

    /**
     * <p>
     * The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
     * @see CommitMode
     */
    public final CommitMode commitMode() {
        return CommitMode.fromValue(commitMode);
    }

    /**
     * <p>
     * The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitMode} will
     * return {@link CommitMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commitModeAsString}.
     * </p>
     * 
     * @return The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
     * @see CommitMode
     */
    public final String commitModeAsString() {
        return commitMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectableValues());
        hashCode = 31 * hashCode + Objects.hashCode(cascadingControlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(commitModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDropDownControl)) {
            return false;
        }
        ParameterDropDownControl other = (ParameterDropDownControl) obj;
        return Objects.equals(parameterControlId(), other.parameterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(displayOptions(), other.displayOptions())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(selectableValues(), other.selectableValues())
                && Objects.equals(cascadingControlConfiguration(), other.cascadingControlConfiguration())
                && Objects.equals(commitModeAsString(), other.commitModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterDropDownControl").add("ParameterControlId", parameterControlId()).add("Title", title())
                .add("SourceParameterName", sourceParameterName()).add("DisplayOptions", displayOptions())
                .add("Type", typeAsString()).add("SelectableValues", selectableValues())
                .add("CascadingControlConfiguration", cascadingControlConfiguration()).add("CommitMode", commitModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterControlId":
            return Optional.ofNullable(clazz.cast(parameterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SelectableValues":
            return Optional.ofNullable(clazz.cast(selectableValues()));
        case "CascadingControlConfiguration":
            return Optional.ofNullable(clazz.cast(cascadingControlConfiguration()));
        case "CommitMode":
            return Optional.ofNullable(clazz.cast(commitModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterDropDownControl, T> g) {
        return obj -> g.apply((ParameterDropDownControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDropDownControl> {
        /**
         * <p>
         * The ID of the <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param parameterControlId
         *        The ID of the <code>ParameterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControlId(String parameterControlId);

        /**
         * <p>
         * The title of the <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>ParameterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source parameter name of the <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the <code>ParameterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(DropDownControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropDownControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link DropDownControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropDownControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(DropDownControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link DropDownControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(DropDownControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<DropDownControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(DropDownControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type parameter name of the <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param type
         *        The type parameter name of the <code>ParameterDropDownControl</code>.
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(String type);

        /**
         * <p>
         * The type parameter name of the <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param type
         *        The type parameter name of the <code>ParameterDropDownControl</code>.
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(SheetControlListType type);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * 
         * @param selectableValues
         *        A list of selectable values that are used in a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectableValues(ParameterSelectableValues selectableValues);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSelectableValues.Builder}
         * avoiding the need to create one manually via {@link ParameterSelectableValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSelectableValues.Builder#build()} is called immediately
         * and its result is passed to {@link #selectableValues(ParameterSelectableValues)}.
         * 
         * @param selectableValues
         *        a consumer that will call methods on {@link ParameterSelectableValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectableValues(ParameterSelectableValues)
         */
        default Builder selectableValues(Consumer<ParameterSelectableValues.Builder> selectableValues) {
            return selectableValues(ParameterSelectableValues.builder().applyMutation(selectableValues).build());
        }

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * 
         * @param cascadingControlConfiguration
         *        The values that are displayed in a control can be configured to only show values that are valid based
         *        on what's selected in other controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration);

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link CascadingControlConfiguration.Builder}
         * avoiding the need to create one manually via {@link CascadingControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CascadingControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cascadingControlConfiguration(CascadingControlConfiguration)}.
         * 
         * @param cascadingControlConfiguration
         *        a consumer that will call methods on {@link CascadingControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cascadingControlConfiguration(CascadingControlConfiguration)
         */
        default Builder cascadingControlConfiguration(
                Consumer<CascadingControlConfiguration.Builder> cascadingControlConfiguration) {
            return cascadingControlConfiguration(CascadingControlConfiguration.builder()
                    .applyMutation(cascadingControlConfiguration).build());
        }

        /**
         * <p>
         * The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(String commitMode);

        /**
         * <p>
         * The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
         * </p>
         * 
         * @param commitMode
         *        The visibility configuration of the Apply button on a <code>ParameterDropDownControl</code>.
         * @see CommitMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitMode
         */
        Builder commitMode(CommitMode commitMode);
    }

    static final class BuilderImpl implements Builder {
        private String parameterControlId;

        private String title;

        private String sourceParameterName;

        private DropDownControlDisplayOptions displayOptions;

        private String type;

        private ParameterSelectableValues selectableValues;

        private CascadingControlConfiguration cascadingControlConfiguration;

        private String commitMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDropDownControl model) {
            parameterControlId(model.parameterControlId);
            title(model.title);
            sourceParameterName(model.sourceParameterName);
            displayOptions(model.displayOptions);
            type(model.type);
            selectableValues(model.selectableValues);
            cascadingControlConfiguration(model.cascadingControlConfiguration);
            commitMode(model.commitMode);
        }

        public final String getParameterControlId() {
            return parameterControlId;
        }

        public final void setParameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
        }

        @Override
        public final Builder parameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final DropDownControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DropDownControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DropDownControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ParameterSelectableValues.Builder getSelectableValues() {
            return selectableValues != null ? selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(ParameterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(ParameterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public final CascadingControlConfiguration.Builder getCascadingControlConfiguration() {
            return cascadingControlConfiguration != null ? cascadingControlConfiguration.toBuilder() : null;
        }

        public final void setCascadingControlConfiguration(CascadingControlConfiguration.BuilderImpl cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration != null ? cascadingControlConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration;
            return this;
        }

        public final String getCommitMode() {
            return commitMode;
        }

        public final void setCommitMode(String commitMode) {
            this.commitMode = commitMode;
        }

        @Override
        public final Builder commitMode(String commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        @Override
        public final Builder commitMode(CommitMode commitMode) {
            this.commitMode(commitMode == null ? null : commitMode.toString());
            return this;
        }

        @Override
        public ParameterDropDownControl build() {
            return new ParameterDropDownControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
