/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicVisual implements SdkPojo, Serializable, ToCopyableBuilder<TopicVisual.Builder, TopicVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(TopicVisual::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(TopicVisual::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<TopicIR> IR_FIELD = SdkField.<TopicIR> builder(MarshallingType.SDK_POJO).memberName("Ir")
            .getter(getter(TopicVisual::ir)).setter(setter(Builder::ir)).constructor(TopicIR::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ir").build()).build();

    private static final SdkField<List<TopicVisual>> SUPPORTING_VISUALS_FIELD = SdkField
            .<List<TopicVisual>> builder(MarshallingType.LIST)
            .memberName("SupportingVisuals")
            .getter(getter(TopicVisual::supportingVisuals))
            .setter(setter(Builder::supportingVisuals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportingVisuals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicVisual> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicVisual::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, ROLE_FIELD,
            IR_FIELD, SUPPORTING_VISUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visualId;

    private final String role;

    private final TopicIR ir;

    private final List<TopicVisual> supportingVisuals;

    private TopicVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.role = builder.role;
        this.ir = builder.ir;
        this.supportingVisuals = builder.supportingVisuals;
    }

    /**
     * <p>
     * The visual ID for the <code>TopicVisual</code>.
     * </p>
     * 
     * @return The visual ID for the <code>TopicVisual</code>.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * <p>
     * The role for the <code>TopicVisual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link VisualRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role for the <code>TopicVisual</code>.
     * @see VisualRole
     */
    public final VisualRole role() {
        return VisualRole.fromValue(role);
    }

    /**
     * <p>
     * The role for the <code>TopicVisual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link VisualRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role for the <code>TopicVisual</code>.
     * @see VisualRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The ir for the <code>TopicVisual</code>.
     * </p>
     * 
     * @return The ir for the <code>TopicVisual</code>.
     */
    public final TopicIR ir() {
        return ir;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportingVisuals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportingVisuals() {
        return supportingVisuals != null && !(supportingVisuals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supporting visuals for the <code>TopicVisual</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportingVisuals} method.
     * </p>
     * 
     * @return The supporting visuals for the <code>TopicVisual</code>.
     */
    public final List<TopicVisual> supportingVisuals() {
        return supportingVisuals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ir());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportingVisuals() ? supportingVisuals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicVisual)) {
            return false;
        }
        TopicVisual other = (TopicVisual) obj;
        return Objects.equals(visualId(), other.visualId()) && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(ir(), other.ir()) && hasSupportingVisuals() == other.hasSupportingVisuals()
                && Objects.equals(supportingVisuals(), other.supportingVisuals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicVisual").add("VisualId", visualId()).add("Role", roleAsString()).add("Ir", ir())
                .add("SupportingVisuals", hasSupportingVisuals() ? supportingVisuals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "Ir":
            return Optional.ofNullable(clazz.cast(ir()));
        case "SupportingVisuals":
            return Optional.ofNullable(clazz.cast(supportingVisuals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicVisual, T> g) {
        return obj -> g.apply((TopicVisual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicVisual> {
        /**
         * <p>
         * The visual ID for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param visualId
         *        The visual ID for the <code>TopicVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * <p>
         * The role for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param role
         *        The role for the <code>TopicVisual</code>.
         * @see VisualRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualRole
         */
        Builder role(String role);

        /**
         * <p>
         * The role for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param role
         *        The role for the <code>TopicVisual</code>.
         * @see VisualRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualRole
         */
        Builder role(VisualRole role);

        /**
         * <p>
         * The ir for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param ir
         *        The ir for the <code>TopicVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ir(TopicIR ir);

        /**
         * <p>
         * The ir for the <code>TopicVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIR.Builder} avoiding the need to
         * create one manually via {@link TopicIR#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIR.Builder#build()} is called immediately and its result is
         * passed to {@link #ir(TopicIR)}.
         * 
         * @param ir
         *        a consumer that will call methods on {@link TopicIR.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ir(TopicIR)
         */
        default Builder ir(Consumer<TopicIR.Builder> ir) {
            return ir(TopicIR.builder().applyMutation(ir).build());
        }

        /**
         * <p>
         * The supporting visuals for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param supportingVisuals
         *        The supporting visuals for the <code>TopicVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingVisuals(Collection<TopicVisual> supportingVisuals);

        /**
         * <p>
         * The supporting visuals for the <code>TopicVisual</code>.
         * </p>
         * 
         * @param supportingVisuals
         *        The supporting visuals for the <code>TopicVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingVisuals(TopicVisual... supportingVisuals);

        /**
         * <p>
         * The supporting visuals for the <code>TopicVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicVisual.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.TopicVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicVisual.Builder#build()} is called immediately
         * and its result is passed to {@link #supportingVisuals(List<TopicVisual>)}.
         * 
         * @param supportingVisuals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportingVisuals(java.util.Collection<TopicVisual>)
         */
        Builder supportingVisuals(Consumer<Builder>... supportingVisuals);
    }

    static final class BuilderImpl implements Builder {
        private String visualId;

        private String role;

        private TopicIR ir;

        private List<TopicVisual> supportingVisuals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicVisual model) {
            visualId(model.visualId);
            role(model.role);
            ir(model.ir);
            supportingVisuals(model.supportingVisuals);
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(VisualRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final TopicIR.Builder getIr() {
            return ir != null ? ir.toBuilder() : null;
        }

        public final void setIr(TopicIR.BuilderImpl ir) {
            this.ir = ir != null ? ir.build() : null;
        }

        @Override
        public final Builder ir(TopicIR ir) {
            this.ir = ir;
            return this;
        }

        public final List<Builder> getSupportingVisuals() {
            List<Builder> result = TopicVisualsCopier.copyToBuilder(this.supportingVisuals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingVisuals(Collection<BuilderImpl> supportingVisuals) {
            this.supportingVisuals = TopicVisualsCopier.copyFromBuilder(supportingVisuals);
        }

        @Override
        public final Builder supportingVisuals(Collection<TopicVisual> supportingVisuals) {
            this.supportingVisuals = TopicVisualsCopier.copy(supportingVisuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingVisuals(TopicVisual... supportingVisuals) {
            supportingVisuals(Arrays.asList(supportingVisuals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingVisuals(Consumer<Builder>... supportingVisuals) {
            supportingVisuals(Stream.of(supportingVisuals).map(c -> TopicVisual.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TopicVisual build() {
            return new TopicVisual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
