/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AllSheetsFilterScopeConfiguration;
import software.amazon.awssdk.services.quicksight.model.SelectedSheetsFilterScopeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterScopeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterScopeConfiguration> {
    private static final SdkField<SelectedSheetsFilterScopeConfiguration> SELECTED_SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectedSheets").getter(FilterScopeConfiguration.getter(FilterScopeConfiguration::selectedSheets)).setter(FilterScopeConfiguration.setter(Builder::selectedSheets)).constructor(SelectedSheetsFilterScopeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSheets").build()}).build();
    private static final SdkField<AllSheetsFilterScopeConfiguration> ALL_SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllSheets").getter(FilterScopeConfiguration.getter(FilterScopeConfiguration::allSheets)).setter(FilterScopeConfiguration.setter(Builder::allSheets)).constructor(AllSheetsFilterScopeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllSheets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_SHEETS_FIELD, ALL_SHEETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SelectedSheets", SELECTED_SHEETS_FIELD);
            this.put("AllSheets", ALL_SHEETS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SelectedSheetsFilterScopeConfiguration selectedSheets;
    private final AllSheetsFilterScopeConfiguration allSheets;

    private FilterScopeConfiguration(BuilderImpl builder) {
        this.selectedSheets = builder.selectedSheets;
        this.allSheets = builder.allSheets;
    }

    public final SelectedSheetsFilterScopeConfiguration selectedSheets() {
        return this.selectedSheets;
    }

    public final AllSheetsFilterScopeConfiguration allSheets() {
        return this.allSheets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedSheets());
        hashCode = 31 * hashCode + Objects.hashCode(this.allSheets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterScopeConfiguration)) {
            return false;
        }
        FilterScopeConfiguration other = (FilterScopeConfiguration)obj;
        return Objects.equals(this.selectedSheets(), other.selectedSheets()) && Objects.equals(this.allSheets(), other.allSheets());
    }

    public final String toString() {
        return ToString.builder((String)"FilterScopeConfiguration").add("SelectedSheets", (Object)this.selectedSheets()).add("AllSheets", (Object)this.allSheets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedSheets": {
                return Optional.ofNullable(clazz.cast(this.selectedSheets()));
            }
            case "AllSheets": {
                return Optional.ofNullable(clazz.cast(this.allSheets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilterScopeConfiguration, T> g) {
        return obj -> g.apply((FilterScopeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SelectedSheetsFilterScopeConfiguration selectedSheets;
        private AllSheetsFilterScopeConfiguration allSheets;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterScopeConfiguration model) {
            this.selectedSheets(model.selectedSheets);
            this.allSheets(model.allSheets);
        }

        public final SelectedSheetsFilterScopeConfiguration.Builder getSelectedSheets() {
            return this.selectedSheets != null ? this.selectedSheets.toBuilder() : null;
        }

        public final void setSelectedSheets(SelectedSheetsFilterScopeConfiguration.BuilderImpl selectedSheets) {
            this.selectedSheets = selectedSheets != null ? selectedSheets.build() : null;
        }

        @Override
        public final Builder selectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets) {
            this.selectedSheets = selectedSheets;
            return this;
        }

        public final AllSheetsFilterScopeConfiguration.Builder getAllSheets() {
            return this.allSheets != null ? this.allSheets.toBuilder() : null;
        }

        public final void setAllSheets(AllSheetsFilterScopeConfiguration.BuilderImpl allSheets) {
            this.allSheets = allSheets != null ? allSheets.build() : null;
        }

        @Override
        public final Builder allSheets(AllSheetsFilterScopeConfiguration allSheets) {
            this.allSheets = allSheets;
            return this;
        }

        public FilterScopeConfiguration build() {
            return new FilterScopeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterScopeConfiguration> {
        public Builder selectedSheets(SelectedSheetsFilterScopeConfiguration var1);

        default public Builder selectedSheets(Consumer<SelectedSheetsFilterScopeConfiguration.Builder> selectedSheets) {
            return this.selectedSheets((SelectedSheetsFilterScopeConfiguration)((SelectedSheetsFilterScopeConfiguration.Builder)SelectedSheetsFilterScopeConfiguration.builder().applyMutation(selectedSheets)).build());
        }

        public Builder allSheets(AllSheetsFilterScopeConfiguration var1);

        default public Builder allSheets(Consumer<AllSheetsFilterScopeConfiguration.Builder> allSheets) {
            return this.allSheets((AllSheetsFilterScopeConfiguration)((AllSheetsFilterScopeConfiguration.Builder)AllSheetsFilterScopeConfiguration.builder().applyMutation(allSheets)).build());
        }
    }
}

