/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetRefreshProperties;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataSetRefreshPropertiesRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, PutDataSetRefreshPropertiesRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(PutDataSetRefreshPropertiesRequest.getter(PutDataSetRefreshPropertiesRequest::awsAccountId)).setter(PutDataSetRefreshPropertiesRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(PutDataSetRefreshPropertiesRequest.getter(PutDataSetRefreshPropertiesRequest::dataSetId)).setter(PutDataSetRefreshPropertiesRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<DataSetRefreshProperties> DATA_SET_REFRESH_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSetRefreshProperties").getter(PutDataSetRefreshPropertiesRequest.getter(PutDataSetRefreshPropertiesRequest::dataSetRefreshProperties)).setter(PutDataSetRefreshPropertiesRequest.setter(Builder::dataSetRefreshProperties)).constructor(DataSetRefreshProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetRefreshProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DATA_SET_ID_FIELD, DATA_SET_REFRESH_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("DataSetId", DATA_SET_ID_FIELD);
            this.put("DataSetRefreshProperties", DATA_SET_REFRESH_PROPERTIES_FIELD);
        }
    });
    private final String awsAccountId;
    private final String dataSetId;
    private final DataSetRefreshProperties dataSetRefreshProperties;

    private PutDataSetRefreshPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.dataSetRefreshProperties = builder.dataSetRefreshProperties;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final DataSetRefreshProperties dataSetRefreshProperties() {
        return this.dataSetRefreshProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetRefreshProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataSetRefreshPropertiesRequest)) {
            return false;
        }
        PutDataSetRefreshPropertiesRequest other = (PutDataSetRefreshPropertiesRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.dataSetRefreshProperties(), other.dataSetRefreshProperties());
    }

    public final String toString() {
        return ToString.builder((String)"PutDataSetRefreshPropertiesRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DataSetId", (Object)this.dataSetId()).add("DataSetRefreshProperties", (Object)this.dataSetRefreshProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "DataSetRefreshProperties": {
                return Optional.ofNullable(clazz.cast(this.dataSetRefreshProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutDataSetRefreshPropertiesRequest, T> g) {
        return obj -> g.apply((PutDataSetRefreshPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dataSetId;
        private DataSetRefreshProperties dataSetRefreshProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataSetRefreshPropertiesRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dataSetId(model.dataSetId);
            this.dataSetRefreshProperties(model.dataSetRefreshProperties);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final DataSetRefreshProperties.Builder getDataSetRefreshProperties() {
            return this.dataSetRefreshProperties != null ? this.dataSetRefreshProperties.toBuilder() : null;
        }

        public final void setDataSetRefreshProperties(DataSetRefreshProperties.BuilderImpl dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties != null ? dataSetRefreshProperties.build() : null;
        }

        @Override
        public final Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataSetRefreshPropertiesRequest build() {
            return new PutDataSetRefreshPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDataSetRefreshPropertiesRequest> {
        public Builder awsAccountId(String var1);

        public Builder dataSetId(String var1);

        public Builder dataSetRefreshProperties(DataSetRefreshProperties var1);

        default public Builder dataSetRefreshProperties(Consumer<DataSetRefreshProperties.Builder> dataSetRefreshProperties) {
            return this.dataSetRefreshProperties((DataSetRefreshProperties)((DataSetRefreshProperties.Builder)DataSetRefreshProperties.builder().applyMutation(dataSetRefreshProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

