/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionTagRule;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionTagRuleConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionTagRuleListCopier;
import software.amazon.awssdk.services.quicksight.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowLevelPermissionTagConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowLevelPermissionTagConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RowLevelPermissionTagConfiguration.getter(RowLevelPermissionTagConfiguration::statusAsString)).setter(RowLevelPermissionTagConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<RowLevelPermissionTagRule>> TAG_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagRules").getter(RowLevelPermissionTagConfiguration.getter(RowLevelPermissionTagConfiguration::tagRules)).setter(RowLevelPermissionTagConfiguration.setter(Builder::tagRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RowLevelPermissionTagRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> TAG_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagRuleConfigurations").getter(RowLevelPermissionTagConfiguration.getter(RowLevelPermissionTagConfiguration::tagRuleConfigurations)).setter(RowLevelPermissionTagConfiguration.setter(Builder::tagRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TAG_RULES_FIELD, TAG_RULE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("TagRules", TAG_RULES_FIELD);
            this.put("TagRuleConfigurations", TAG_RULE_CONFIGURATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<RowLevelPermissionTagRule> tagRules;
    private final List<List<String>> tagRuleConfigurations;

    private RowLevelPermissionTagConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.tagRules = builder.tagRules;
        this.tagRuleConfigurations = builder.tagRuleConfigurations;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTagRules() {
        return this.tagRules != null && !(this.tagRules instanceof SdkAutoConstructList);
    }

    public final List<RowLevelPermissionTagRule> tagRules() {
        return this.tagRules;
    }

    public final boolean hasTagRuleConfigurations() {
        return this.tagRuleConfigurations != null && !(this.tagRuleConfigurations instanceof SdkAutoConstructList);
    }

    public final List<List<String>> tagRuleConfigurations() {
        return this.tagRuleConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagRules() ? this.tagRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagRuleConfigurations() ? this.tagRuleConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionTagConfiguration)) {
            return false;
        }
        RowLevelPermissionTagConfiguration other = (RowLevelPermissionTagConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTagRules() == other.hasTagRules() && Objects.equals(this.tagRules(), other.tagRules()) && this.hasTagRuleConfigurations() == other.hasTagRuleConfigurations() && Objects.equals(this.tagRuleConfigurations(), other.tagRuleConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"RowLevelPermissionTagConfiguration").add("Status", (Object)this.statusAsString()).add("TagRules", this.hasTagRules() ? this.tagRules() : null).add("TagRuleConfigurations", this.hasTagRuleConfigurations() ? this.tagRuleConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TagRules": {
                return Optional.ofNullable(clazz.cast(this.tagRules()));
            }
            case "TagRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.tagRuleConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionTagConfiguration, T> g) {
        return obj -> g.apply((RowLevelPermissionTagConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<RowLevelPermissionTagRule> tagRules = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> tagRuleConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionTagConfiguration model) {
            this.status(model.status);
            this.tagRules(model.tagRules);
            this.tagRuleConfigurations(model.tagRuleConfigurations);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<RowLevelPermissionTagRule.Builder> getTagRules() {
            List<RowLevelPermissionTagRule.Builder> result = RowLevelPermissionTagRuleListCopier.copyToBuilder(this.tagRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagRules(Collection<RowLevelPermissionTagRule.BuilderImpl> tagRules) {
            this.tagRules = RowLevelPermissionTagRuleListCopier.copyFromBuilder(tagRules);
        }

        @Override
        public final Builder tagRules(Collection<RowLevelPermissionTagRule> tagRules) {
            this.tagRules = RowLevelPermissionTagRuleListCopier.copy(tagRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRules(RowLevelPermissionTagRule ... tagRules) {
            this.tagRules(Arrays.asList(tagRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRules(Consumer<RowLevelPermissionTagRule.Builder> ... tagRules) {
            this.tagRules(Stream.of(tagRules).map(c -> (RowLevelPermissionTagRule)((RowLevelPermissionTagRule.Builder)RowLevelPermissionTagRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Collection<String>> getTagRuleConfigurations() {
            if (this.tagRuleConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagRuleConfigurations;
        }

        public final void setTagRuleConfigurations(Collection<? extends Collection<String>> tagRuleConfigurations) {
            this.tagRuleConfigurations = RowLevelPermissionTagRuleConfigurationListCopier.copy(tagRuleConfigurations);
        }

        @Override
        public final Builder tagRuleConfigurations(Collection<? extends Collection<String>> tagRuleConfigurations) {
            this.tagRuleConfigurations = RowLevelPermissionTagRuleConfigurationListCopier.copy(tagRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRuleConfigurations(Collection<String> ... tagRuleConfigurations) {
            this.tagRuleConfigurations((Collection<? extends Collection<String>>)Arrays.asList(tagRuleConfigurations));
            return this;
        }

        public RowLevelPermissionTagConfiguration build() {
            return new RowLevelPermissionTagConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowLevelPermissionTagConfiguration> {
        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder tagRules(Collection<RowLevelPermissionTagRule> var1);

        public Builder tagRules(RowLevelPermissionTagRule ... var1);

        public Builder tagRules(Consumer<RowLevelPermissionTagRule.Builder> ... var1);

        public Builder tagRuleConfigurations(Collection<? extends Collection<String>> var1);

        public Builder tagRuleConfigurations(Collection<String> ... var1);
    }
}

