/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ComparisonMethodType;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicIRComparisonMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicIRComparisonMethod> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TopicIRComparisonMethod.getter(TopicIRComparisonMethod::typeAsString)).setter(TopicIRComparisonMethod.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(TopicIRComparisonMethod.getter(TopicIRComparisonMethod::periodAsString)).setter(TopicIRComparisonMethod.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WindowSize").getter(TopicIRComparisonMethod.getter(TopicIRComparisonMethod::windowSize)).setter(TopicIRComparisonMethod.setter(Builder::windowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PERIOD_FIELD, WINDOW_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Period", PERIOD_FIELD);
            this.put("WindowSize", WINDOW_SIZE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String period;
    private final Integer windowSize;

    private TopicIRComparisonMethod(BuilderImpl builder) {
        this.type = builder.type;
        this.period = builder.period;
        this.windowSize = builder.windowSize;
    }

    public final ComparisonMethodType type() {
        return ComparisonMethodType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TopicTimeGranularity period() {
        return TopicTimeGranularity.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final Integer windowSize() {
        return this.windowSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRComparisonMethod)) {
            return false;
        }
        TopicIRComparisonMethod other = (TopicIRComparisonMethod)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.windowSize(), other.windowSize());
    }

    public final String toString() {
        return ToString.builder((String)"TopicIRComparisonMethod").add("Type", (Object)this.typeAsString()).add("Period", (Object)this.periodAsString()).add("WindowSize", (Object)this.windowSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "WindowSize": {
                return Optional.ofNullable(clazz.cast(this.windowSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicIRComparisonMethod, T> g) {
        return obj -> g.apply((TopicIRComparisonMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String period;
        private Integer windowSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRComparisonMethod model) {
            this.type(model.type);
            this.period(model.period);
            this.windowSize(model.windowSize);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComparisonMethodType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(TopicTimeGranularity period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final Integer getWindowSize() {
            return this.windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public TopicIRComparisonMethod build() {
            return new TopicIRComparisonMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicIRComparisonMethod> {
        public Builder type(String var1);

        public Builder type(ComparisonMethodType var1);

        public Builder period(String var1);

        public Builder period(TopicTimeGranularity var1);

        public Builder windowSize(Integer var1);
    }
}

