/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ArcAxisDisplayRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArcAxisConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArcAxisConfiguration> {
    private static final SdkField<ArcAxisDisplayRange> RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Range").getter(ArcAxisConfiguration.getter(ArcAxisConfiguration::range)).setter(ArcAxisConfiguration.setter(Builder::range)).constructor(ArcAxisDisplayRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build();
    private static final SdkField<Integer> RESERVE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReserveRange").getter(ArcAxisConfiguration.getter(ArcAxisConfiguration::reserveRange)).setter(ArcAxisConfiguration.setter(Builder::reserveRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReserveRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_FIELD, RESERVE_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Range", RANGE_FIELD);
            this.put("ReserveRange", RESERVE_RANGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ArcAxisDisplayRange range;
    private final Integer reserveRange;

    private ArcAxisConfiguration(BuilderImpl builder) {
        this.range = builder.range;
        this.reserveRange = builder.reserveRange;
    }

    public final ArcAxisDisplayRange range() {
        return this.range;
    }

    public final Integer reserveRange() {
        return this.reserveRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        hashCode = 31 * hashCode + Objects.hashCode(this.reserveRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcAxisConfiguration)) {
            return false;
        }
        ArcAxisConfiguration other = (ArcAxisConfiguration)obj;
        return Objects.equals(this.range(), other.range()) && Objects.equals(this.reserveRange(), other.reserveRange());
    }

    public final String toString() {
        return ToString.builder((String)"ArcAxisConfiguration").add("Range", (Object)this.range()).add("ReserveRange", (Object)this.reserveRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Range": {
                return Optional.ofNullable(clazz.cast(this.range()));
            }
            case "ReserveRange": {
                return Optional.ofNullable(clazz.cast(this.reserveRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArcAxisConfiguration, T> g) {
        return obj -> g.apply((ArcAxisConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArcAxisDisplayRange range;
        private Integer reserveRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcAxisConfiguration model) {
            this.range(model.range);
            this.reserveRange(model.reserveRange);
        }

        public final ArcAxisDisplayRange.Builder getRange() {
            return this.range != null ? this.range.toBuilder() : null;
        }

        public final void setRange(ArcAxisDisplayRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(ArcAxisDisplayRange range) {
            this.range = range;
            return this;
        }

        public final Integer getReserveRange() {
            return this.reserveRange;
        }

        public final void setReserveRange(Integer reserveRange) {
            this.reserveRange = reserveRange;
        }

        @Override
        public final Builder reserveRange(Integer reserveRange) {
            this.reserveRange = reserveRange;
            return this;
        }

        public ArcAxisConfiguration build() {
            return new ArcAxisConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArcAxisConfiguration> {
        public Builder range(ArcAxisDisplayRange var1);

        default public Builder range(Consumer<ArcAxisDisplayRange.Builder> range) {
            return this.range((ArcAxisDisplayRange)((ArcAxisDisplayRange.Builder)ArcAxisDisplayRange.builder().applyMutation(range)).build());
        }

        public Builder reserveRange(Integer var1);
    }
}

