/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnIdentifier> {
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetIdentifier").getter(ColumnIdentifier.getter(ColumnIdentifier::dataSetIdentifier)).setter(ColumnIdentifier.setter(Builder::dataSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()}).build();
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(ColumnIdentifier.getter(ColumnIdentifier::columnName)).setter(ColumnIdentifier.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_FIELD, COLUMN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSetIdentifier", DATA_SET_IDENTIFIER_FIELD);
            this.put("ColumnName", COLUMN_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataSetIdentifier;
    private final String columnName;

    private ColumnIdentifier(BuilderImpl builder) {
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.columnName = builder.columnName;
    }

    public final String dataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public final String columnName() {
        return this.columnName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier other = (ColumnIdentifier)obj;
        return Objects.equals(this.dataSetIdentifier(), other.dataSetIdentifier()) && Objects.equals(this.columnName(), other.columnName());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnIdentifier").add("DataSetIdentifier", (Object)this.dataSetIdentifier()).add("ColumnName", (Object)this.columnName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataSetIdentifier()));
            }
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ColumnIdentifier, T> g) {
        return obj -> g.apply((ColumnIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetIdentifier;
        private String columnName;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnIdentifier model) {
            this.dataSetIdentifier(model.dataSetIdentifier);
            this.columnName(model.columnName);
        }

        public final String getDataSetIdentifier() {
            return this.dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public ColumnIdentifier build() {
            return new ColumnIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnIdentifier> {
        public Builder dataSetIdentifier(String var1);

        public Builder columnName(String var1);
    }
}

