/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FilterControl;
import software.amazon.awssdk.services.quicksight.model.FilterControlListCopier;
import software.amazon.awssdk.services.quicksight.model.Layout;
import software.amazon.awssdk.services.quicksight.model.LayoutListCopier;
import software.amazon.awssdk.services.quicksight.model.ParameterControl;
import software.amazon.awssdk.services.quicksight.model.ParameterControlListCopier;
import software.amazon.awssdk.services.quicksight.model.SheetContentType;
import software.amazon.awssdk.services.quicksight.model.SheetControlLayout;
import software.amazon.awssdk.services.quicksight.model.SheetControlLayoutListCopier;
import software.amazon.awssdk.services.quicksight.model.SheetImage;
import software.amazon.awssdk.services.quicksight.model.SheetImageListCopier;
import software.amazon.awssdk.services.quicksight.model.SheetTextBox;
import software.amazon.awssdk.services.quicksight.model.SheetTextBoxListCopier;
import software.amazon.awssdk.services.quicksight.model.Visual;
import software.amazon.awssdk.services.quicksight.model.VisualListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetDefinition> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SheetId").getter(SheetDefinition.getter(SheetDefinition::sheetId)).setter(SheetDefinition.setter(Builder::sheetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(SheetDefinition.getter(SheetDefinition::title)).setter(SheetDefinition.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SheetDefinition.getter(SheetDefinition::description)).setter(SheetDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SheetDefinition.getter(SheetDefinition::name)).setter(SheetDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ParameterControl>> PARAMETER_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterControls").getter(SheetDefinition.getter(SheetDefinition::parameterControls)).setter(SheetDefinition.setter(Builder::parameterControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterControl>> FILTER_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterControls").getter(SheetDefinition.getter(SheetDefinition::filterControls)).setter(SheetDefinition.setter(Builder::filterControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Visual>> VISUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Visuals").getter(SheetDefinition.getter(SheetDefinition::visuals)).setter(SheetDefinition.setter(Builder::visuals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visuals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Visual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SheetTextBox>> TEXT_BOXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextBoxes").getter(SheetDefinition.getter(SheetDefinition::textBoxes)).setter(SheetDefinition.setter(Builder::textBoxes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBoxes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetTextBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SheetImage>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Images").getter(SheetDefinition.getter(SheetDefinition::images)).setter(SheetDefinition.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Layout>> LAYOUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layouts").getter(SheetDefinition.getter(SheetDefinition::layouts)).setter(SheetDefinition.setter(Builder::layouts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layouts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SheetControlLayout>> SHEET_CONTROL_LAYOUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SheetControlLayouts").getter(SheetDefinition.getter(SheetDefinition::sheetControlLayouts)).setter(SheetDefinition.setter(Builder::sheetControlLayouts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlLayouts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetControlLayout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(SheetDefinition.getter(SheetDefinition::contentTypeAsString)).setter(SheetDefinition.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, PARAMETER_CONTROLS_FIELD, FILTER_CONTROLS_FIELD, VISUALS_FIELD, TEXT_BOXES_FIELD, IMAGES_FIELD, LAYOUTS_FIELD, SHEET_CONTROL_LAYOUTS_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SheetId", SHEET_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ParameterControls", PARAMETER_CONTROLS_FIELD);
            this.put("FilterControls", FILTER_CONTROLS_FIELD);
            this.put("Visuals", VISUALS_FIELD);
            this.put("TextBoxes", TEXT_BOXES_FIELD);
            this.put("Images", IMAGES_FIELD);
            this.put("Layouts", LAYOUTS_FIELD);
            this.put("SheetControlLayouts", SHEET_CONTROL_LAYOUTS_FIELD);
            this.put("ContentType", CONTENT_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sheetId;
    private final String title;
    private final String description;
    private final String name;
    private final List<ParameterControl> parameterControls;
    private final List<FilterControl> filterControls;
    private final List<Visual> visuals;
    private final List<SheetTextBox> textBoxes;
    private final List<SheetImage> images;
    private final List<Layout> layouts;
    private final List<SheetControlLayout> sheetControlLayouts;
    private final String contentType;

    private SheetDefinition(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.title = builder.title;
        this.description = builder.description;
        this.name = builder.name;
        this.parameterControls = builder.parameterControls;
        this.filterControls = builder.filterControls;
        this.visuals = builder.visuals;
        this.textBoxes = builder.textBoxes;
        this.images = builder.images;
        this.layouts = builder.layouts;
        this.sheetControlLayouts = builder.sheetControlLayouts;
        this.contentType = builder.contentType;
    }

    public final String sheetId() {
        return this.sheetId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasParameterControls() {
        return this.parameterControls != null && !(this.parameterControls instanceof SdkAutoConstructList);
    }

    public final List<ParameterControl> parameterControls() {
        return this.parameterControls;
    }

    public final boolean hasFilterControls() {
        return this.filterControls != null && !(this.filterControls instanceof SdkAutoConstructList);
    }

    public final List<FilterControl> filterControls() {
        return this.filterControls;
    }

    public final boolean hasVisuals() {
        return this.visuals != null && !(this.visuals instanceof SdkAutoConstructList);
    }

    public final List<Visual> visuals() {
        return this.visuals;
    }

    public final boolean hasTextBoxes() {
        return this.textBoxes != null && !(this.textBoxes instanceof SdkAutoConstructList);
    }

    public final List<SheetTextBox> textBoxes() {
        return this.textBoxes;
    }

    public final boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public final List<SheetImage> images() {
        return this.images;
    }

    public final boolean hasLayouts() {
        return this.layouts != null && !(this.layouts instanceof SdkAutoConstructList);
    }

    public final List<Layout> layouts() {
        return this.layouts;
    }

    public final boolean hasSheetControlLayouts() {
        return this.sheetControlLayouts != null && !(this.sheetControlLayouts instanceof SdkAutoConstructList);
    }

    public final List<SheetControlLayout> sheetControlLayouts() {
        return this.sheetControlLayouts;
    }

    public final SheetContentType contentType() {
        return SheetContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterControls() ? this.parameterControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterControls() ? this.filterControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVisuals() ? this.visuals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextBoxes() ? this.textBoxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayouts() ? this.layouts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheetControlLayouts() ? this.sheetControlLayouts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetDefinition)) {
            return false;
        }
        SheetDefinition other = (SheetDefinition)obj;
        return Objects.equals(this.sheetId(), other.sheetId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasParameterControls() == other.hasParameterControls() && Objects.equals(this.parameterControls(), other.parameterControls()) && this.hasFilterControls() == other.hasFilterControls() && Objects.equals(this.filterControls(), other.filterControls()) && this.hasVisuals() == other.hasVisuals() && Objects.equals(this.visuals(), other.visuals()) && this.hasTextBoxes() == other.hasTextBoxes() && Objects.equals(this.textBoxes(), other.textBoxes()) && this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images()) && this.hasLayouts() == other.hasLayouts() && Objects.equals(this.layouts(), other.layouts()) && this.hasSheetControlLayouts() == other.hasSheetControlLayouts() && Objects.equals(this.sheetControlLayouts(), other.sheetControlLayouts()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SheetDefinition").add("SheetId", (Object)this.sheetId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ParameterControls", this.hasParameterControls() ? this.parameterControls() : null).add("FilterControls", this.hasFilterControls() ? this.filterControls() : null).add("Visuals", this.hasVisuals() ? this.visuals() : null).add("TextBoxes", this.hasTextBoxes() ? this.textBoxes() : null).add("Images", this.hasImages() ? this.images() : null).add("Layouts", this.hasLayouts() ? this.layouts() : null).add("SheetControlLayouts", this.hasSheetControlLayouts() ? this.sheetControlLayouts() : null).add("ContentType", (Object)this.contentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetId": {
                return Optional.ofNullable(clazz.cast(this.sheetId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ParameterControls": {
                return Optional.ofNullable(clazz.cast(this.parameterControls()));
            }
            case "FilterControls": {
                return Optional.ofNullable(clazz.cast(this.filterControls()));
            }
            case "Visuals": {
                return Optional.ofNullable(clazz.cast(this.visuals()));
            }
            case "TextBoxes": {
                return Optional.ofNullable(clazz.cast(this.textBoxes()));
            }
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "Layouts": {
                return Optional.ofNullable(clazz.cast(this.layouts()));
            }
            case "SheetControlLayouts": {
                return Optional.ofNullable(clazz.cast(this.sheetControlLayouts()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SheetDefinition, T> g) {
        return obj -> g.apply((SheetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sheetId;
        private String title;
        private String description;
        private String name;
        private List<ParameterControl> parameterControls = DefaultSdkAutoConstructList.getInstance();
        private List<FilterControl> filterControls = DefaultSdkAutoConstructList.getInstance();
        private List<Visual> visuals = DefaultSdkAutoConstructList.getInstance();
        private List<SheetTextBox> textBoxes = DefaultSdkAutoConstructList.getInstance();
        private List<SheetImage> images = DefaultSdkAutoConstructList.getInstance();
        private List<Layout> layouts = DefaultSdkAutoConstructList.getInstance();
        private List<SheetControlLayout> sheetControlLayouts = DefaultSdkAutoConstructList.getInstance();
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetDefinition model) {
            this.sheetId(model.sheetId);
            this.title(model.title);
            this.description(model.description);
            this.name(model.name);
            this.parameterControls(model.parameterControls);
            this.filterControls(model.filterControls);
            this.visuals(model.visuals);
            this.textBoxes(model.textBoxes);
            this.images(model.images);
            this.layouts(model.layouts);
            this.sheetControlLayouts(model.sheetControlLayouts);
            this.contentType(model.contentType);
        }

        public final String getSheetId() {
            return this.sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ParameterControl.Builder> getParameterControls() {
            List<ParameterControl.Builder> result = ParameterControlListCopier.copyToBuilder(this.parameterControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterControls(Collection<ParameterControl.BuilderImpl> parameterControls) {
            this.parameterControls = ParameterControlListCopier.copyFromBuilder(parameterControls);
        }

        @Override
        public final Builder parameterControls(Collection<ParameterControl> parameterControls) {
            this.parameterControls = ParameterControlListCopier.copy(parameterControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterControls(ParameterControl ... parameterControls) {
            this.parameterControls(Arrays.asList(parameterControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterControls(Consumer<ParameterControl.Builder> ... parameterControls) {
            this.parameterControls(Stream.of(parameterControls).map(c -> (ParameterControl)((ParameterControl.Builder)ParameterControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterControl.Builder> getFilterControls() {
            List<FilterControl.Builder> result = FilterControlListCopier.copyToBuilder(this.filterControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterControls(Collection<FilterControl.BuilderImpl> filterControls) {
            this.filterControls = FilterControlListCopier.copyFromBuilder(filterControls);
        }

        @Override
        public final Builder filterControls(Collection<FilterControl> filterControls) {
            this.filterControls = FilterControlListCopier.copy(filterControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterControls(FilterControl ... filterControls) {
            this.filterControls(Arrays.asList(filterControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterControls(Consumer<FilterControl.Builder> ... filterControls) {
            this.filterControls(Stream.of(filterControls).map(c -> (FilterControl)((FilterControl.Builder)FilterControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Visual.Builder> getVisuals() {
            List<Visual.Builder> result = VisualListCopier.copyToBuilder(this.visuals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVisuals(Collection<Visual.BuilderImpl> visuals) {
            this.visuals = VisualListCopier.copyFromBuilder(visuals);
        }

        @Override
        public final Builder visuals(Collection<Visual> visuals) {
            this.visuals = VisualListCopier.copy(visuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visuals(Visual ... visuals) {
            this.visuals(Arrays.asList(visuals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visuals(Consumer<Visual.Builder> ... visuals) {
            this.visuals(Stream.of(visuals).map(c -> (Visual)((Visual.Builder)Visual.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetTextBox.Builder> getTextBoxes() {
            List<SheetTextBox.Builder> result = SheetTextBoxListCopier.copyToBuilder(this.textBoxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextBoxes(Collection<SheetTextBox.BuilderImpl> textBoxes) {
            this.textBoxes = SheetTextBoxListCopier.copyFromBuilder(textBoxes);
        }

        @Override
        public final Builder textBoxes(Collection<SheetTextBox> textBoxes) {
            this.textBoxes = SheetTextBoxListCopier.copy(textBoxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textBoxes(SheetTextBox ... textBoxes) {
            this.textBoxes(Arrays.asList(textBoxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textBoxes(Consumer<SheetTextBox.Builder> ... textBoxes) {
            this.textBoxes(Stream.of(textBoxes).map(c -> (SheetTextBox)((SheetTextBox.Builder)SheetTextBox.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetImage.Builder> getImages() {
            List<SheetImage.Builder> result = SheetImageListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<SheetImage.BuilderImpl> images) {
            this.images = SheetImageListCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<SheetImage> images) {
            this.images = SheetImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(SheetImage ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<SheetImage.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (SheetImage)((SheetImage.Builder)SheetImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Layout.Builder> getLayouts() {
            List<Layout.Builder> result = LayoutListCopier.copyToBuilder(this.layouts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayouts(Collection<Layout.BuilderImpl> layouts) {
            this.layouts = LayoutListCopier.copyFromBuilder(layouts);
        }

        @Override
        public final Builder layouts(Collection<Layout> layouts) {
            this.layouts = LayoutListCopier.copy(layouts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(Layout ... layouts) {
            this.layouts(Arrays.asList(layouts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(Consumer<Layout.Builder> ... layouts) {
            this.layouts(Stream.of(layouts).map(c -> (Layout)((Layout.Builder)Layout.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetControlLayout.Builder> getSheetControlLayouts() {
            List<SheetControlLayout.Builder> result = SheetControlLayoutListCopier.copyToBuilder(this.sheetControlLayouts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheetControlLayouts(Collection<SheetControlLayout.BuilderImpl> sheetControlLayouts) {
            this.sheetControlLayouts = SheetControlLayoutListCopier.copyFromBuilder(sheetControlLayouts);
        }

        @Override
        public final Builder sheetControlLayouts(Collection<SheetControlLayout> sheetControlLayouts) {
            this.sheetControlLayouts = SheetControlLayoutListCopier.copy(sheetControlLayouts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetControlLayouts(SheetControlLayout ... sheetControlLayouts) {
            this.sheetControlLayouts(Arrays.asList(sheetControlLayouts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetControlLayouts(Consumer<SheetControlLayout.Builder> ... sheetControlLayouts) {
            this.sheetControlLayouts(Stream.of(sheetControlLayouts).map(c -> (SheetControlLayout)((SheetControlLayout.Builder)SheetControlLayout.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(SheetContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public SheetDefinition build() {
            return new SheetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetDefinition> {
        public Builder sheetId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder parameterControls(Collection<ParameterControl> var1);

        public Builder parameterControls(ParameterControl ... var1);

        public Builder parameterControls(Consumer<ParameterControl.Builder> ... var1);

        public Builder filterControls(Collection<FilterControl> var1);

        public Builder filterControls(FilterControl ... var1);

        public Builder filterControls(Consumer<FilterControl.Builder> ... var1);

        public Builder visuals(Collection<Visual> var1);

        public Builder visuals(Visual ... var1);

        public Builder visuals(Consumer<Visual.Builder> ... var1);

        public Builder textBoxes(Collection<SheetTextBox> var1);

        public Builder textBoxes(SheetTextBox ... var1);

        public Builder textBoxes(Consumer<SheetTextBox.Builder> ... var1);

        public Builder images(Collection<SheetImage> var1);

        public Builder images(SheetImage ... var1);

        public Builder images(Consumer<SheetImage.Builder> ... var1);

        public Builder layouts(Collection<Layout> var1);

        public Builder layouts(Layout ... var1);

        public Builder layouts(Consumer<Layout.Builder> ... var1);

        public Builder sheetControlLayouts(Collection<SheetControlLayout> var1);

        public Builder sheetControlLayouts(SheetControlLayout ... var1);

        public Builder sheetControlLayouts(Consumer<SheetControlLayout.Builder> ... var1);

        public Builder contentType(String var1);

        public Builder contentType(SheetContentType var1);
    }
}

