/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SmallMultiplesAxisPlacement;
import software.amazon.awssdk.services.quicksight.model.SmallMultiplesAxisScale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SmallMultiplesAxisProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SmallMultiplesAxisProperties> {
    private static final SdkField<String> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scale").getter(SmallMultiplesAxisProperties.getter(SmallMultiplesAxisProperties::scaleAsString)).setter(SmallMultiplesAxisProperties.setter(Builder::scale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()}).build();
    private static final SdkField<String> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Placement").getter(SmallMultiplesAxisProperties.getter(SmallMultiplesAxisProperties::placementAsString)).setter(SmallMultiplesAxisProperties.setter(Builder::placement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_FIELD, PLACEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Scale", SCALE_FIELD);
            this.put("Placement", PLACEMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scale;
    private final String placement;

    private SmallMultiplesAxisProperties(BuilderImpl builder) {
        this.scale = builder.scale;
        this.placement = builder.placement;
    }

    public final SmallMultiplesAxisScale scale() {
        return SmallMultiplesAxisScale.fromValue(this.scale);
    }

    public final String scaleAsString() {
        return this.scale;
    }

    public final SmallMultiplesAxisPlacement placement() {
        return SmallMultiplesAxisPlacement.fromValue(this.placement);
    }

    public final String placementAsString() {
        return this.placement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmallMultiplesAxisProperties)) {
            return false;
        }
        SmallMultiplesAxisProperties other = (SmallMultiplesAxisProperties)obj;
        return Objects.equals(this.scaleAsString(), other.scaleAsString()) && Objects.equals(this.placementAsString(), other.placementAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SmallMultiplesAxisProperties").add("Scale", (Object)this.scaleAsString()).add("Placement", (Object)this.placementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scale": {
                return Optional.ofNullable(clazz.cast(this.scaleAsString()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placementAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SmallMultiplesAxisProperties, T> g) {
        return obj -> g.apply((SmallMultiplesAxisProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scale;
        private String placement;

        private BuilderImpl() {
        }

        private BuilderImpl(SmallMultiplesAxisProperties model) {
            this.scale(model.scale);
            this.placement(model.placement);
        }

        public final String getScale() {
            return this.scale;
        }

        public final void setScale(String scale) {
            this.scale = scale;
        }

        @Override
        public final Builder scale(String scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public final Builder scale(SmallMultiplesAxisScale scale) {
            this.scale(scale == null ? null : scale.toString());
            return this;
        }

        public final String getPlacement() {
            return this.placement;
        }

        public final void setPlacement(String placement) {
            this.placement = placement;
        }

        @Override
        public final Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public final Builder placement(SmallMultiplesAxisPlacement placement) {
            this.placement(placement == null ? null : placement.toString());
            return this;
        }

        public SmallMultiplesAxisProperties build() {
            return new SmallMultiplesAxisProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SmallMultiplesAxisProperties> {
        public Builder scale(String var1);

        public Builder scale(SmallMultiplesAxisScale var1);

        public Builder placement(String var1);

        public Builder placement(SmallMultiplesAxisPlacement var1);
    }
}

