/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeBasedForecastProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeBasedForecastProperties> {
    private static final SdkField<Integer> PERIODS_FORWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodsForward").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::periodsForward)).setter(TimeBasedForecastProperties.setter(Builder::periodsForward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsForward").build()}).build();
    private static final SdkField<Integer> PERIODS_BACKWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodsBackward").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::periodsBackward)).setter(TimeBasedForecastProperties.setter(Builder::periodsBackward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsBackward").build()}).build();
    private static final SdkField<Double> UPPER_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UpperBoundary").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::upperBoundary)).setter(TimeBasedForecastProperties.setter(Builder::upperBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBoundary").build()}).build();
    private static final SdkField<Double> LOWER_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LowerBoundary").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::lowerBoundary)).setter(TimeBasedForecastProperties.setter(Builder::lowerBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBoundary").build()}).build();
    private static final SdkField<Integer> PREDICTION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PredictionInterval").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::predictionInterval)).setter(TimeBasedForecastProperties.setter(Builder::predictionInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionInterval").build()}).build();
    private static final SdkField<Integer> SEASONALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Seasonality").getter(TimeBasedForecastProperties.getter(TimeBasedForecastProperties::seasonality)).setter(TimeBasedForecastProperties.setter(Builder::seasonality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seasonality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIODS_FORWARD_FIELD, PERIODS_BACKWARD_FIELD, UPPER_BOUNDARY_FIELD, LOWER_BOUNDARY_FIELD, PREDICTION_INTERVAL_FIELD, SEASONALITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PeriodsForward", PERIODS_FORWARD_FIELD);
            this.put("PeriodsBackward", PERIODS_BACKWARD_FIELD);
            this.put("UpperBoundary", UPPER_BOUNDARY_FIELD);
            this.put("LowerBoundary", LOWER_BOUNDARY_FIELD);
            this.put("PredictionInterval", PREDICTION_INTERVAL_FIELD);
            this.put("Seasonality", SEASONALITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer periodsForward;
    private final Integer periodsBackward;
    private final Double upperBoundary;
    private final Double lowerBoundary;
    private final Integer predictionInterval;
    private final Integer seasonality;

    private TimeBasedForecastProperties(BuilderImpl builder) {
        this.periodsForward = builder.periodsForward;
        this.periodsBackward = builder.periodsBackward;
        this.upperBoundary = builder.upperBoundary;
        this.lowerBoundary = builder.lowerBoundary;
        this.predictionInterval = builder.predictionInterval;
        this.seasonality = builder.seasonality;
    }

    public final Integer periodsForward() {
        return this.periodsForward;
    }

    public final Integer periodsBackward() {
        return this.periodsBackward;
    }

    public final Double upperBoundary() {
        return this.upperBoundary;
    }

    public final Double lowerBoundary() {
        return this.lowerBoundary;
    }

    public final Integer predictionInterval() {
        return this.predictionInterval;
    }

    public final Integer seasonality() {
        return this.seasonality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.periodsForward());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodsBackward());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.seasonality());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedForecastProperties)) {
            return false;
        }
        TimeBasedForecastProperties other = (TimeBasedForecastProperties)obj;
        return Objects.equals(this.periodsForward(), other.periodsForward()) && Objects.equals(this.periodsBackward(), other.periodsBackward()) && Objects.equals(this.upperBoundary(), other.upperBoundary()) && Objects.equals(this.lowerBoundary(), other.lowerBoundary()) && Objects.equals(this.predictionInterval(), other.predictionInterval()) && Objects.equals(this.seasonality(), other.seasonality());
    }

    public final String toString() {
        return ToString.builder((String)"TimeBasedForecastProperties").add("PeriodsForward", (Object)this.periodsForward()).add("PeriodsBackward", (Object)this.periodsBackward()).add("UpperBoundary", (Object)this.upperBoundary()).add("LowerBoundary", (Object)this.lowerBoundary()).add("PredictionInterval", (Object)this.predictionInterval()).add("Seasonality", (Object)this.seasonality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeriodsForward": {
                return Optional.ofNullable(clazz.cast(this.periodsForward()));
            }
            case "PeriodsBackward": {
                return Optional.ofNullable(clazz.cast(this.periodsBackward()));
            }
            case "UpperBoundary": {
                return Optional.ofNullable(clazz.cast(this.upperBoundary()));
            }
            case "LowerBoundary": {
                return Optional.ofNullable(clazz.cast(this.lowerBoundary()));
            }
            case "PredictionInterval": {
                return Optional.ofNullable(clazz.cast(this.predictionInterval()));
            }
            case "Seasonality": {
                return Optional.ofNullable(clazz.cast(this.seasonality()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedForecastProperties, T> g) {
        return obj -> g.apply((TimeBasedForecastProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer periodsForward;
        private Integer periodsBackward;
        private Double upperBoundary;
        private Double lowerBoundary;
        private Integer predictionInterval;
        private Integer seasonality;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedForecastProperties model) {
            this.periodsForward(model.periodsForward);
            this.periodsBackward(model.periodsBackward);
            this.upperBoundary(model.upperBoundary);
            this.lowerBoundary(model.lowerBoundary);
            this.predictionInterval(model.predictionInterval);
            this.seasonality(model.seasonality);
        }

        public final Integer getPeriodsForward() {
            return this.periodsForward;
        }

        public final void setPeriodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
        }

        @Override
        public final Builder periodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
            return this;
        }

        public final Integer getPeriodsBackward() {
            return this.periodsBackward;
        }

        public final void setPeriodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
        }

        @Override
        public final Builder periodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
            return this;
        }

        public final Double getUpperBoundary() {
            return this.upperBoundary;
        }

        public final void setUpperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        @Override
        public final Builder upperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
            return this;
        }

        public final Double getLowerBoundary() {
            return this.lowerBoundary;
        }

        public final void setLowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        @Override
        public final Builder lowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
            return this;
        }

        public final Integer getPredictionInterval() {
            return this.predictionInterval;
        }

        public final void setPredictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
        }

        @Override
        public final Builder predictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
            return this;
        }

        public final Integer getSeasonality() {
            return this.seasonality;
        }

        public final void setSeasonality(Integer seasonality) {
            this.seasonality = seasonality;
        }

        @Override
        public final Builder seasonality(Integer seasonality) {
            this.seasonality = seasonality;
            return this;
        }

        public TimeBasedForecastProperties build() {
            return new TimeBasedForecastProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeBasedForecastProperties> {
        public Builder periodsForward(Integer var1);

        public Builder periodsBackward(Integer var1);

        public Builder upperBoundary(Double var1);

        public Builder lowerBoundary(Double var1);

        public Builder predictionInterval(Integer var1);

        public Builder seasonality(Integer var1);
    }
}

