/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The feature configuration for an embedded dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserDashboardFeatureConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<AnonymousUserDashboardFeatureConfigurations.Builder, AnonymousUserDashboardFeatureConfigurations> {
    private static final SdkField<SharedViewConfigurations> SHARED_VIEW_FIELD = SdkField
            .<SharedViewConfigurations> builder(MarshallingType.SDK_POJO).memberName("SharedView")
            .getter(getter(AnonymousUserDashboardFeatureConfigurations::sharedView)).setter(setter(Builder::sharedView))
            .constructor(SharedViewConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedView").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_VIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SharedViewConfigurations sharedView;

    private AnonymousUserDashboardFeatureConfigurations(BuilderImpl builder) {
        this.sharedView = builder.sharedView;
    }

    /**
     * <p>
     * The shared view settings of an embedded dashboard.
     * </p>
     * 
     * @return The shared view settings of an embedded dashboard.
     */
    public final SharedViewConfigurations sharedView() {
        return sharedView;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedView());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserDashboardFeatureConfigurations)) {
            return false;
        }
        AnonymousUserDashboardFeatureConfigurations other = (AnonymousUserDashboardFeatureConfigurations) obj;
        return Objects.equals(sharedView(), other.sharedView());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserDashboardFeatureConfigurations").add("SharedView", sharedView()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedView":
            return Optional.ofNullable(clazz.cast(sharedView()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SharedView", SHARED_VIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserDashboardFeatureConfigurations, T> g) {
        return obj -> g.apply((AnonymousUserDashboardFeatureConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserDashboardFeatureConfigurations> {
        /**
         * <p>
         * The shared view settings of an embedded dashboard.
         * </p>
         * 
         * @param sharedView
         *        The shared view settings of an embedded dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedView(SharedViewConfigurations sharedView);

        /**
         * <p>
         * The shared view settings of an embedded dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharedViewConfigurations.Builder}
         * avoiding the need to create one manually via {@link SharedViewConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharedViewConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #sharedView(SharedViewConfigurations)}.
         * 
         * @param sharedView
         *        a consumer that will call methods on {@link SharedViewConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedView(SharedViewConfigurations)
         */
        default Builder sharedView(Consumer<SharedViewConfigurations.Builder> sharedView) {
            return sharedView(SharedViewConfigurations.builder().applyMutation(sharedView).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SharedViewConfigurations sharedView;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserDashboardFeatureConfigurations model) {
            sharedView(model.sharedView);
        }

        public final SharedViewConfigurations.Builder getSharedView() {
            return sharedView != null ? sharedView.toBuilder() : null;
        }

        public final void setSharedView(SharedViewConfigurations.BuilderImpl sharedView) {
            this.sharedView = sharedView != null ? sharedView.build() : null;
        }

        @Override
        public final Builder sharedView(SharedViewConfigurations sharedView) {
            this.sharedView = sharedView;
            return this;
        }

        @Override
        public AnonymousUserDashboardFeatureConfigurations build() {
            return new AnonymousUserDashboardFeatureConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
