/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorized targets that are associated with a service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizedTargetsByService implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizedTargetsByService.Builder, AuthorizedTargetsByService> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(AuthorizedTargetsByService::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedTargets")
            .getter(getter(AuthorizedTargetsByService::authorizedTargets))
            .setter(setter(Builder::authorizedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            AUTHORIZED_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String service;

    private final List<String> authorizedTargets;

    private AuthorizedTargetsByService(BuilderImpl builder) {
        this.service = builder.service;
        this.authorizedTargets = builder.authorizedTargets;
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service.
     * @see ServiceType
     */
    public final ServiceType service() {
        return ServiceType.fromValue(service);
    }

    /**
     * <p>
     * The name of the Amazon Web Services service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return The name of the Amazon Web Services service.
     * @see ServiceType
     */
    public final String serviceAsString() {
        return service;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedTargets() {
        return authorizedTargets != null && !(authorizedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aist of authorized targets that are represented by IAM Identity Center application ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedTargets} method.
     * </p>
     * 
     * @return Aist of authorized targets that are represented by IAM Identity Center application ARNs.
     */
    public final List<String> authorizedTargets() {
        return authorizedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedTargets() ? authorizedTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTargetsByService)) {
            return false;
        }
        AuthorizedTargetsByService other = (AuthorizedTargetsByService) obj;
        return Objects.equals(serviceAsString(), other.serviceAsString())
                && hasAuthorizedTargets() == other.hasAuthorizedTargets()
                && Objects.equals(authorizedTargets(), other.authorizedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizedTargetsByService").add("Service", serviceAsString())
                .add("AuthorizedTargets", hasAuthorizedTargets() ? authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        case "AuthorizedTargets":
            return Optional.ofNullable(clazz.cast(authorizedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Service", SERVICE_FIELD);
        map.put("AuthorizedTargets", AUTHORIZED_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTargetsByService, T> g) {
        return obj -> g.apply((AuthorizedTargetsByService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizedTargetsByService> {
        /**
         * <p>
         * The name of the Amazon Web Services service.
         * </p>
         * 
         * @param service
         *        The name of the Amazon Web Services service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder service(String service);

        /**
         * <p>
         * The name of the Amazon Web Services service.
         * </p>
         * 
         * @param service
         *        The name of the Amazon Web Services service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder service(ServiceType service);

        /**
         * <p>
         * Aist of authorized targets that are represented by IAM Identity Center application ARNs.
         * </p>
         * 
         * @param authorizedTargets
         *        Aist of authorized targets that are represented by IAM Identity Center application ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(Collection<String> authorizedTargets);

        /**
         * <p>
         * Aist of authorized targets that are represented by IAM Identity Center application ARNs.
         * </p>
         * 
         * @param authorizedTargets
         *        Aist of authorized targets that are represented by IAM Identity Center application ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(String... authorizedTargets);
    }

    static final class BuilderImpl implements Builder {
        private String service;

        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTargetsByService model) {
            service(model.service);
            authorizedTargets(model.authorizedTargets);
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(ServiceType service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = AuthorizedTargetsListCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = AuthorizedTargetsListCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String... authorizedTargets) {
            authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        @Override
        public AuthorizedTargetsByService build() {
            return new AuthorizedTargetsByService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
