/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data options for an axis.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisDataOptions implements SdkPojo, Serializable, ToCopyableBuilder<AxisDataOptions.Builder, AxisDataOptions> {
    private static final SdkField<NumericAxisOptions> NUMERIC_AXIS_OPTIONS_FIELD = SdkField
            .<NumericAxisOptions> builder(MarshallingType.SDK_POJO).memberName("NumericAxisOptions")
            .getter(getter(AxisDataOptions::numericAxisOptions)).setter(setter(Builder::numericAxisOptions))
            .constructor(NumericAxisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericAxisOptions").build())
            .build();

    private static final SdkField<DateAxisOptions> DATE_AXIS_OPTIONS_FIELD = SdkField
            .<DateAxisOptions> builder(MarshallingType.SDK_POJO).memberName("DateAxisOptions")
            .getter(getter(AxisDataOptions::dateAxisOptions)).setter(setter(Builder::dateAxisOptions))
            .constructor(DateAxisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateAxisOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_AXIS_OPTIONS_FIELD,
            DATE_AXIS_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NumericAxisOptions numericAxisOptions;

    private final DateAxisOptions dateAxisOptions;

    private AxisDataOptions(BuilderImpl builder) {
        this.numericAxisOptions = builder.numericAxisOptions;
        this.dateAxisOptions = builder.dateAxisOptions;
    }

    /**
     * <p>
     * The options for an axis with a numeric field.
     * </p>
     * 
     * @return The options for an axis with a numeric field.
     */
    public final NumericAxisOptions numericAxisOptions() {
        return numericAxisOptions;
    }

    /**
     * <p>
     * The options for an axis with a date field.
     * </p>
     * 
     * @return The options for an axis with a date field.
     */
    public final DateAxisOptions dateAxisOptions() {
        return dateAxisOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericAxisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dateAxisOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisDataOptions)) {
            return false;
        }
        AxisDataOptions other = (AxisDataOptions) obj;
        return Objects.equals(numericAxisOptions(), other.numericAxisOptions())
                && Objects.equals(dateAxisOptions(), other.dateAxisOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisDataOptions").add("NumericAxisOptions", numericAxisOptions())
                .add("DateAxisOptions", dateAxisOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericAxisOptions":
            return Optional.ofNullable(clazz.cast(numericAxisOptions()));
        case "DateAxisOptions":
            return Optional.ofNullable(clazz.cast(dateAxisOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumericAxisOptions", NUMERIC_AXIS_OPTIONS_FIELD);
        map.put("DateAxisOptions", DATE_AXIS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisDataOptions, T> g) {
        return obj -> g.apply((AxisDataOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisDataOptions> {
        /**
         * <p>
         * The options for an axis with a numeric field.
         * </p>
         * 
         * @param numericAxisOptions
         *        The options for an axis with a numeric field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericAxisOptions(NumericAxisOptions numericAxisOptions);

        /**
         * <p>
         * The options for an axis with a numeric field.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericAxisOptions.Builder} avoiding the
         * need to create one manually via {@link NumericAxisOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericAxisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #numericAxisOptions(NumericAxisOptions)}.
         * 
         * @param numericAxisOptions
         *        a consumer that will call methods on {@link NumericAxisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericAxisOptions(NumericAxisOptions)
         */
        default Builder numericAxisOptions(Consumer<NumericAxisOptions.Builder> numericAxisOptions) {
            return numericAxisOptions(NumericAxisOptions.builder().applyMutation(numericAxisOptions).build());
        }

        /**
         * <p>
         * The options for an axis with a date field.
         * </p>
         * 
         * @param dateAxisOptions
         *        The options for an axis with a date field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateAxisOptions(DateAxisOptions dateAxisOptions);

        /**
         * <p>
         * The options for an axis with a date field.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateAxisOptions.Builder} avoiding the
         * need to create one manually via {@link DateAxisOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateAxisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dateAxisOptions(DateAxisOptions)}.
         * 
         * @param dateAxisOptions
         *        a consumer that will call methods on {@link DateAxisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateAxisOptions(DateAxisOptions)
         */
        default Builder dateAxisOptions(Consumer<DateAxisOptions.Builder> dateAxisOptions) {
            return dateAxisOptions(DateAxisOptions.builder().applyMutation(dateAxisOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericAxisOptions numericAxisOptions;

        private DateAxisOptions dateAxisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisDataOptions model) {
            numericAxisOptions(model.numericAxisOptions);
            dateAxisOptions(model.dateAxisOptions);
        }

        public final NumericAxisOptions.Builder getNumericAxisOptions() {
            return numericAxisOptions != null ? numericAxisOptions.toBuilder() : null;
        }

        public final void setNumericAxisOptions(NumericAxisOptions.BuilderImpl numericAxisOptions) {
            this.numericAxisOptions = numericAxisOptions != null ? numericAxisOptions.build() : null;
        }

        @Override
        public final Builder numericAxisOptions(NumericAxisOptions numericAxisOptions) {
            this.numericAxisOptions = numericAxisOptions;
            return this;
        }

        public final DateAxisOptions.Builder getDateAxisOptions() {
            return dateAxisOptions != null ? dateAxisOptions.toBuilder() : null;
        }

        public final void setDateAxisOptions(DateAxisOptions.BuilderImpl dateAxisOptions) {
            this.dateAxisOptions = dateAxisOptions != null ? dateAxisOptions.build() : null;
        }

        @Override
        public final Builder dateAxisOptions(DateAxisOptions dateAxisOptions) {
            this.dateAxisOptions = dateAxisOptions;
            return this;
        }

        @Override
        public AxisDataOptions build() {
            return new AxisDataOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
