/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label options for a chart axis. You must specify the field that the label is targeted to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisLabelOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisLabelOptions.Builder, AxisLabelOptions> {
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("FontConfiguration")
            .getter(getter(AxisLabelOptions::fontConfiguration)).setter(setter(Builder::fontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(AxisLabelOptions::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<AxisLabelReferenceOptions> APPLY_TO_FIELD = SdkField
            .<AxisLabelReferenceOptions> builder(MarshallingType.SDK_POJO).memberName("ApplyTo")
            .getter(getter(AxisLabelOptions::applyTo)).setter(setter(Builder::applyTo))
            .constructor(AxisLabelReferenceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_CONFIGURATION_FIELD,
            CUSTOM_LABEL_FIELD, APPLY_TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FontConfiguration fontConfiguration;

    private final String customLabel;

    private final AxisLabelReferenceOptions applyTo;

    private AxisLabelOptions(BuilderImpl builder) {
        this.fontConfiguration = builder.fontConfiguration;
        this.customLabel = builder.customLabel;
        this.applyTo = builder.applyTo;
    }

    /**
     * <p>
     * The font configuration of the axis label.
     * </p>
     * 
     * @return The font configuration of the axis label.
     */
    public final FontConfiguration fontConfiguration() {
        return fontConfiguration;
    }

    /**
     * <p>
     * The text for the axis label.
     * </p>
     * 
     * @return The text for the axis label.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * The options that indicate which field the label belongs to.
     * </p>
     * 
     * @return The options that indicate which field the label belongs to.
     */
    public final AxisLabelReferenceOptions applyTo() {
        return applyTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(applyTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisLabelOptions)) {
            return false;
        }
        AxisLabelOptions other = (AxisLabelOptions) obj;
        return Objects.equals(fontConfiguration(), other.fontConfiguration())
                && Objects.equals(customLabel(), other.customLabel()) && Objects.equals(applyTo(), other.applyTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisLabelOptions").add("FontConfiguration", fontConfiguration())
                .add("CustomLabel", customLabel()).add("ApplyTo", applyTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontConfiguration":
            return Optional.ofNullable(clazz.cast(fontConfiguration()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "ApplyTo":
            return Optional.ofNullable(clazz.cast(applyTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("ApplyTo", APPLY_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisLabelOptions, T> g) {
        return obj -> g.apply((AxisLabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisLabelOptions> {
        /**
         * <p>
         * The font configuration of the axis label.
         * </p>
         * 
         * @param fontConfiguration
         *        The font configuration of the axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontConfiguration(FontConfiguration fontConfiguration);

        /**
         * <p>
         * The font configuration of the axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fontConfiguration(FontConfiguration)}.
         * 
         * @param fontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontConfiguration(FontConfiguration)
         */
        default Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return fontConfiguration(FontConfiguration.builder().applyMutation(fontConfiguration).build());
        }

        /**
         * <p>
         * The text for the axis label.
         * </p>
         * 
         * @param customLabel
         *        The text for the axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * The options that indicate which field the label belongs to.
         * </p>
         * 
         * @param applyTo
         *        The options that indicate which field the label belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyTo(AxisLabelReferenceOptions applyTo);

        /**
         * <p>
         * The options that indicate which field the label belongs to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisLabelReferenceOptions.Builder}
         * avoiding the need to create one manually via {@link AxisLabelReferenceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisLabelReferenceOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #applyTo(AxisLabelReferenceOptions)}.
         * 
         * @param applyTo
         *        a consumer that will call methods on {@link AxisLabelReferenceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applyTo(AxisLabelReferenceOptions)
         */
        default Builder applyTo(Consumer<AxisLabelReferenceOptions.Builder> applyTo) {
            return applyTo(AxisLabelReferenceOptions.builder().applyMutation(applyTo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FontConfiguration fontConfiguration;

        private String customLabel;

        private AxisLabelReferenceOptions applyTo;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisLabelOptions model) {
            fontConfiguration(model.fontConfiguration);
            customLabel(model.customLabel);
            applyTo(model.applyTo);
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return fontConfiguration != null ? fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final AxisLabelReferenceOptions.Builder getApplyTo() {
            return applyTo != null ? applyTo.toBuilder() : null;
        }

        public final void setApplyTo(AxisLabelReferenceOptions.BuilderImpl applyTo) {
            this.applyTo = applyTo != null ? applyTo.build() : null;
        }

        @Override
        public final Builder applyTo(AxisLabelReferenceOptions applyTo) {
            this.applyTo = applyTo;
            return this;
        }

        @Override
        public AxisLabelOptions build() {
            return new AxisLabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
