/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteTopicReviewedAnswerRequest extends QuickSightRequest implements
        ToCopyableBuilder<BatchDeleteTopicReviewedAnswerRequest.Builder, BatchDeleteTopicReviewedAnswerRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(BatchDeleteTopicReviewedAnswerRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(BatchDeleteTopicReviewedAnswerRequest::topicId))
            .setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()).build();

    private static final SdkField<List<String>> ANSWER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AnswerIds")
            .getter(getter(BatchDeleteTopicReviewedAnswerRequest::answerIds))
            .setter(setter(Builder::answerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TOPIC_ID_FIELD, ANSWER_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String topicId;

    private final List<String> answerIds;

    private BatchDeleteTopicReviewedAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.answerIds = builder.answerIds;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that you want to delete a reviewed answers in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that you want to delete a reviewed answers in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to delete. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic reviewed answer that you want to delete. This ID is unique per Amazon Web Services
     *         Region for each Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnswerIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnswerIds() {
        return answerIds != null && !(answerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Answer IDs of the Answers to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswerIds} method.
     * </p>
     * 
     * @return The Answer IDs of the Answers to be deleted.
     */
    public final List<String> answerIds() {
        return answerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswerIds() ? answerIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTopicReviewedAnswerRequest)) {
            return false;
        }
        BatchDeleteTopicReviewedAnswerRequest other = (BatchDeleteTopicReviewedAnswerRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(topicId(), other.topicId())
                && hasAnswerIds() == other.hasAnswerIds() && Objects.equals(answerIds(), other.answerIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteTopicReviewedAnswerRequest").add("AwsAccountId", awsAccountId())
                .add("TopicId", topicId()).add("AnswerIds", hasAnswerIds() ? answerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "AnswerIds":
            return Optional.ofNullable(clazz.cast(answerIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("AnswerIds", ANSWER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTopicReviewedAnswerRequest, T> g) {
        return obj -> g.apply((BatchDeleteTopicReviewedAnswerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteTopicReviewedAnswerRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that you want to delete a reviewed answers in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that you want to delete a reviewed answers in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the topic reviewed answer that you want to delete. This ID is unique per Amazon Web Services
         * Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID for the topic reviewed answer that you want to delete. This ID is unique per Amazon Web
         *        Services Region for each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The Answer IDs of the Answers to be deleted.
         * </p>
         * 
         * @param answerIds
         *        The Answer IDs of the Answers to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerIds(Collection<String> answerIds);

        /**
         * <p>
         * The Answer IDs of the Answers to be deleted.
         * </p>
         * 
         * @param answerIds
         *        The Answer IDs of the Answers to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerIds(String... answerIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String topicId;

        private List<String> answerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTopicReviewedAnswerRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            topicId(model.topicId);
            answerIds(model.answerIds);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final Collection<String> getAnswerIds() {
            if (answerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return answerIds;
        }

        public final void setAnswerIds(Collection<String> answerIds) {
            this.answerIds = AnswerIdsCopier.copy(answerIds);
        }

        @Override
        public final Builder answerIds(Collection<String> answerIds) {
            this.answerIds = AnswerIdsCopier.copy(answerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerIds(String... answerIds) {
            answerIds(Arrays.asList(answerIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteTopicReviewedAnswerRequest build() {
            return new BatchDeleteTopicReviewedAnswerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
