/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting configuration for icon set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalFormattingIconSet implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalFormattingIconSet.Builder, ConditionalFormattingIconSet> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(ConditionalFormattingIconSet::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> ICON_SET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IconSetType").getter(getter(ConditionalFormattingIconSet::iconSetTypeAsString))
            .setter(setter(Builder::iconSetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconSetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            ICON_SET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final String iconSetType;

    private ConditionalFormattingIconSet(BuilderImpl builder) {
        this.expression = builder.expression;
        this.iconSetType = builder.iconSetType;
    }

    /**
     * <p>
     * The expression that determines the formatting configuration for the icon set.
     * </p>
     * 
     * @return The expression that determines the formatting configuration for the icon set.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * Determines the icon set type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iconSetType} will
     * return {@link ConditionalFormattingIconSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #iconSetTypeAsString}.
     * </p>
     * 
     * @return Determines the icon set type.
     * @see ConditionalFormattingIconSetType
     */
    public final ConditionalFormattingIconSetType iconSetType() {
        return ConditionalFormattingIconSetType.fromValue(iconSetType);
    }

    /**
     * <p>
     * Determines the icon set type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iconSetType} will
     * return {@link ConditionalFormattingIconSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #iconSetTypeAsString}.
     * </p>
     * 
     * @return Determines the icon set type.
     * @see ConditionalFormattingIconSetType
     */
    public final String iconSetTypeAsString() {
        return iconSetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(iconSetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingIconSet)) {
            return false;
        }
        ConditionalFormattingIconSet other = (ConditionalFormattingIconSet) obj;
        return Objects.equals(expression(), other.expression())
                && Objects.equals(iconSetTypeAsString(), other.iconSetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalFormattingIconSet")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IconSetType", iconSetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "IconSetType":
            return Optional.ofNullable(clazz.cast(iconSetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("IconSetType", ICON_SET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingIconSet, T> g) {
        return obj -> g.apply((ConditionalFormattingIconSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalFormattingIconSet> {
        /**
         * <p>
         * The expression that determines the formatting configuration for the icon set.
         * </p>
         * 
         * @param expression
         *        The expression that determines the formatting configuration for the icon set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Determines the icon set type.
         * </p>
         * 
         * @param iconSetType
         *        Determines the icon set type.
         * @see ConditionalFormattingIconSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalFormattingIconSetType
         */
        Builder iconSetType(String iconSetType);

        /**
         * <p>
         * Determines the icon set type.
         * </p>
         * 
         * @param iconSetType
         *        Determines the icon set type.
         * @see ConditionalFormattingIconSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalFormattingIconSetType
         */
        Builder iconSetType(ConditionalFormattingIconSetType iconSetType);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private String iconSetType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingIconSet model) {
            expression(model.expression);
            iconSetType(model.iconSetType);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getIconSetType() {
            return iconSetType;
        }

        public final void setIconSetType(String iconSetType) {
            this.iconSetType = iconSetType;
        }

        @Override
        public final Builder iconSetType(String iconSetType) {
            this.iconSetType = iconSetType;
            return this;
        }

        @Override
        public final Builder iconSetType(ConditionalFormattingIconSetType iconSetType) {
            this.iconSetType(iconSetType == null ? null : iconSetType.toString());
            return this;
        }

        @Override
        public ConditionalFormattingIconSet build() {
            return new ConditionalFormattingIconSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
