/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The drill down filter for the column hierarchies.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DrillDownFilter implements SdkPojo, Serializable, ToCopyableBuilder<DrillDownFilter.Builder, DrillDownFilter> {
    private static final SdkField<NumericEqualityDrillDownFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField
            .<NumericEqualityDrillDownFilter> builder(MarshallingType.SDK_POJO).memberName("NumericEqualityFilter")
            .getter(getter(DrillDownFilter::numericEqualityFilter)).setter(setter(Builder::numericEqualityFilter))
            .constructor(NumericEqualityDrillDownFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build())
            .build();

    private static final SdkField<CategoryDrillDownFilter> CATEGORY_FILTER_FIELD = SdkField
            .<CategoryDrillDownFilter> builder(MarshallingType.SDK_POJO).memberName("CategoryFilter")
            .getter(getter(DrillDownFilter::categoryFilter)).setter(setter(Builder::categoryFilter))
            .constructor(CategoryDrillDownFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()).build();

    private static final SdkField<TimeRangeDrillDownFilter> TIME_RANGE_FILTER_FIELD = SdkField
            .<TimeRangeDrillDownFilter> builder(MarshallingType.SDK_POJO).memberName("TimeRangeFilter")
            .getter(getter(DrillDownFilter::timeRangeFilter)).setter(setter(Builder::timeRangeFilter))
            .constructor(TimeRangeDrillDownFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_EQUALITY_FILTER_FIELD,
            CATEGORY_FILTER_FIELD, TIME_RANGE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NumericEqualityDrillDownFilter numericEqualityFilter;

    private final CategoryDrillDownFilter categoryFilter;

    private final TimeRangeDrillDownFilter timeRangeFilter;

    private DrillDownFilter(BuilderImpl builder) {
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.categoryFilter = builder.categoryFilter;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    /**
     * <p>
     * The numeric equality type drill down filter. This filter is used for number type columns.
     * </p>
     * 
     * @return The numeric equality type drill down filter. This filter is used for number type columns.
     */
    public final NumericEqualityDrillDownFilter numericEqualityFilter() {
        return numericEqualityFilter;
    }

    /**
     * <p>
     * The category type drill down filter. This filter is used for string type columns.
     * </p>
     * 
     * @return The category type drill down filter. This filter is used for string type columns.
     */
    public final CategoryDrillDownFilter categoryFilter() {
        return categoryFilter;
    }

    /**
     * <p>
     * The time range drill down filter. This filter is used for date time columns.
     * </p>
     * 
     * @return The time range drill down filter. This filter is used for date time columns.
     */
    public final TimeRangeDrillDownFilter timeRangeFilter() {
        return timeRangeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DrillDownFilter)) {
            return false;
        }
        DrillDownFilter other = (DrillDownFilter) obj;
        return Objects.equals(numericEqualityFilter(), other.numericEqualityFilter())
                && Objects.equals(categoryFilter(), other.categoryFilter())
                && Objects.equals(timeRangeFilter(), other.timeRangeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DrillDownFilter").add("NumericEqualityFilter", numericEqualityFilter())
                .add("CategoryFilter", categoryFilter()).add("TimeRangeFilter", timeRangeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericEqualityFilter":
            return Optional.ofNullable(clazz.cast(numericEqualityFilter()));
        case "CategoryFilter":
            return Optional.ofNullable(clazz.cast(categoryFilter()));
        case "TimeRangeFilter":
            return Optional.ofNullable(clazz.cast(timeRangeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumericEqualityFilter", NUMERIC_EQUALITY_FILTER_FIELD);
        map.put("CategoryFilter", CATEGORY_FILTER_FIELD);
        map.put("TimeRangeFilter", TIME_RANGE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DrillDownFilter, T> g) {
        return obj -> g.apply((DrillDownFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DrillDownFilter> {
        /**
         * <p>
         * The numeric equality type drill down filter. This filter is used for number type columns.
         * </p>
         * 
         * @param numericEqualityFilter
         *        The numeric equality type drill down filter. This filter is used for number type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericEqualityFilter(NumericEqualityDrillDownFilter numericEqualityFilter);

        /**
         * <p>
         * The numeric equality type drill down filter. This filter is used for number type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericEqualityDrillDownFilter.Builder}
         * avoiding the need to create one manually via {@link NumericEqualityDrillDownFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericEqualityDrillDownFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #numericEqualityFilter(NumericEqualityDrillDownFilter)}.
         * 
         * @param numericEqualityFilter
         *        a consumer that will call methods on {@link NumericEqualityDrillDownFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericEqualityFilter(NumericEqualityDrillDownFilter)
         */
        default Builder numericEqualityFilter(Consumer<NumericEqualityDrillDownFilter.Builder> numericEqualityFilter) {
            return numericEqualityFilter(NumericEqualityDrillDownFilter.builder().applyMutation(numericEqualityFilter).build());
        }

        /**
         * <p>
         * The category type drill down filter. This filter is used for string type columns.
         * </p>
         * 
         * @param categoryFilter
         *        The category type drill down filter. This filter is used for string type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryFilter(CategoryDrillDownFilter categoryFilter);

        /**
         * <p>
         * The category type drill down filter. This filter is used for string type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoryDrillDownFilter.Builder} avoiding
         * the need to create one manually via {@link CategoryDrillDownFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoryDrillDownFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #categoryFilter(CategoryDrillDownFilter)}.
         * 
         * @param categoryFilter
         *        a consumer that will call methods on {@link CategoryDrillDownFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryFilter(CategoryDrillDownFilter)
         */
        default Builder categoryFilter(Consumer<CategoryDrillDownFilter.Builder> categoryFilter) {
            return categoryFilter(CategoryDrillDownFilter.builder().applyMutation(categoryFilter).build());
        }

        /**
         * <p>
         * The time range drill down filter. This filter is used for date time columns.
         * </p>
         * 
         * @param timeRangeFilter
         *        The time range drill down filter. This filter is used for date time columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeFilter(TimeRangeDrillDownFilter timeRangeFilter);

        /**
         * <p>
         * The time range drill down filter. This filter is used for date time columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeDrillDownFilter.Builder}
         * avoiding the need to create one manually via {@link TimeRangeDrillDownFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeDrillDownFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #timeRangeFilter(TimeRangeDrillDownFilter)}.
         * 
         * @param timeRangeFilter
         *        a consumer that will call methods on {@link TimeRangeDrillDownFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRangeFilter(TimeRangeDrillDownFilter)
         */
        default Builder timeRangeFilter(Consumer<TimeRangeDrillDownFilter.Builder> timeRangeFilter) {
            return timeRangeFilter(TimeRangeDrillDownFilter.builder().applyMutation(timeRangeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericEqualityDrillDownFilter numericEqualityFilter;

        private CategoryDrillDownFilter categoryFilter;

        private TimeRangeDrillDownFilter timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(DrillDownFilter model) {
            numericEqualityFilter(model.numericEqualityFilter);
            categoryFilter(model.categoryFilter);
            timeRangeFilter(model.timeRangeFilter);
        }

        public final NumericEqualityDrillDownFilter.Builder getNumericEqualityFilter() {
            return numericEqualityFilter != null ? numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(NumericEqualityDrillDownFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(NumericEqualityDrillDownFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final CategoryDrillDownFilter.Builder getCategoryFilter() {
            return categoryFilter != null ? categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(CategoryDrillDownFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(CategoryDrillDownFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final TimeRangeDrillDownFilter.Builder getTimeRangeFilter() {
            return timeRangeFilter != null ? timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeDrillDownFilter.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeDrillDownFilter timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        @Override
        public DrillDownFilter build() {
            return new DrillDownFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
