/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about an existing Amazon QuickSight folder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FolderSummary implements SdkPojo, Serializable, ToCopyableBuilder<FolderSummary.Builder, FolderSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FolderSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(FolderSummary::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FolderSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FOLDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderType").getter(getter(FolderSummary::folderTypeAsString)).setter(setter(Builder::folderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderType").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(FolderSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(FolderSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> SHARING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharingModel").getter(getter(FolderSummary::sharingModelAsString)).setter(setter(Builder::sharingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharingModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FOLDER_ID_FIELD,
            NAME_FIELD, FOLDER_TYPE_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, SHARING_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String folderId;

    private final String name;

    private final String folderType;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String sharingModel;

    private FolderSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.folderId = builder.folderId;
        this.name = builder.name;
        this.folderType = builder.folderType;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.sharingModel = builder.sharingModel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the folder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the folder.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The display name of the folder.
     * </p>
     * 
     * @return The display name of the folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder.
     * @see FolderType
     */
    public final FolderType folderType() {
        return FolderType.fromValue(folderType);
    }

    /**
     * <p>
     * The type of folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderType} will
     * return {@link FolderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #folderTypeAsString}.
     * </p>
     * 
     * @return The type of folder.
     * @see FolderType
     */
    public final String folderTypeAsString() {
        return folderType;
    }

    /**
     * <p>
     * The time that the folder was created.
     * </p>
     * 
     * @return The time that the folder was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the folder was last updated.
     * </p>
     * 
     * @return The time that the folder was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The sharing scope of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharingModel} will
     * return {@link SharingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sharingModelAsString}.
     * </p>
     * 
     * @return The sharing scope of the folder.
     * @see SharingModel
     */
    public final SharingModel sharingModel() {
        return SharingModel.fromValue(sharingModel);
    }

    /**
     * <p>
     * The sharing scope of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharingModel} will
     * return {@link SharingModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sharingModelAsString}.
     * </p>
     * 
     * @return The sharing scope of the folder.
     * @see SharingModel
     */
    public final String sharingModelAsString() {
        return sharingModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(folderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(sharingModelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderSummary)) {
            return false;
        }
        FolderSummary other = (FolderSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(folderId(), other.folderId())
                && Objects.equals(name(), other.name()) && Objects.equals(folderTypeAsString(), other.folderTypeAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(sharingModelAsString(), other.sharingModelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FolderSummary").add("Arn", arn()).add("FolderId", folderId()).add("Name", name())
                .add("FolderType", folderTypeAsString()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("SharingModel", sharingModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FolderType":
            return Optional.ofNullable(clazz.cast(folderTypeAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "SharingModel":
            return Optional.ofNullable(clazz.cast(sharingModelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("FolderId", FOLDER_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("FolderType", FOLDER_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("SharingModel", SHARING_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FolderSummary, T> g) {
        return obj -> g.apply((FolderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FolderSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the folder.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The display name of the folder.
         * </p>
         * 
         * @param name
         *        The display name of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of folder.
         * </p>
         * 
         * @param folderType
         *        The type of folder.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(String folderType);

        /**
         * <p>
         * The type of folder.
         * </p>
         * 
         * @param folderType
         *        The type of folder.
         * @see FolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderType
         */
        Builder folderType(FolderType folderType);

        /**
         * <p>
         * The time that the folder was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the folder was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the folder was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the folder was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The sharing scope of the folder.
         * </p>
         * 
         * @param sharingModel
         *        The sharing scope of the folder.
         * @see SharingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharingModel
         */
        Builder sharingModel(String sharingModel);

        /**
         * <p>
         * The sharing scope of the folder.
         * </p>
         * 
         * @param sharingModel
         *        The sharing scope of the folder.
         * @see SharingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharingModel
         */
        Builder sharingModel(SharingModel sharingModel);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String folderId;

        private String name;

        private String folderType;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String sharingModel;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderSummary model) {
            arn(model.arn);
            folderId(model.folderId);
            name(model.name);
            folderType(model.folderType);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            sharingModel(model.sharingModel);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFolderType() {
            return folderType;
        }

        public final void setFolderType(String folderType) {
            this.folderType = folderType;
        }

        @Override
        public final Builder folderType(String folderType) {
            this.folderType = folderType;
            return this;
        }

        @Override
        public final Builder folderType(FolderType folderType) {
            this.folderType(folderType == null ? null : folderType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getSharingModel() {
            return sharingModel;
        }

        public final void setSharingModel(String sharingModel) {
            this.sharingModel = sharingModel;
        }

        @Override
        public final Builder sharingModel(String sharingModel) {
            this.sharingModel = sharingModel;
            return this;
        }

        @Override
        public final Builder sharingModel(SharingModel sharingModel) {
            this.sharingModel(sharingModel == null ? null : sharingModel.toString());
            return this;
        }

        @Override
        public FolderSummary build() {
            return new FolderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
