/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a categorical color.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialCategoricalColor implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialCategoricalColor.Builder, GeospatialCategoricalColor> {
    private static final SdkField<List<GeospatialCategoricalDataColor>> CATEGORY_DATA_COLORS_FIELD = SdkField
            .<List<GeospatialCategoricalDataColor>> builder(MarshallingType.LIST)
            .memberName("CategoryDataColors")
            .getter(getter(GeospatialCategoricalColor::categoryDataColors))
            .setter(setter(Builder::categoryDataColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryDataColors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeospatialCategoricalDataColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeospatialCategoricalDataColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NULL_DATA_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullDataVisibility").getter(getter(GeospatialCategoricalColor::nullDataVisibilityAsString))
            .setter(setter(Builder::nullDataVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataVisibility").build())
            .build();

    private static final SdkField<GeospatialNullDataSettings> NULL_DATA_SETTINGS_FIELD = SdkField
            .<GeospatialNullDataSettings> builder(MarshallingType.SDK_POJO).memberName("NullDataSettings")
            .getter(getter(GeospatialCategoricalColor::nullDataSettings)).setter(setter(Builder::nullDataSettings))
            .constructor(GeospatialNullDataSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullDataSettings").build()).build();

    private static final SdkField<Double> DEFAULT_OPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DefaultOpacity").getter(getter(GeospatialCategoricalColor::defaultOpacity))
            .setter(setter(Builder::defaultOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOpacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_DATA_COLORS_FIELD,
            NULL_DATA_VISIBILITY_FIELD, NULL_DATA_SETTINGS_FIELD, DEFAULT_OPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GeospatialCategoricalDataColor> categoryDataColors;

    private final String nullDataVisibility;

    private final GeospatialNullDataSettings nullDataSettings;

    private final Double defaultOpacity;

    private GeospatialCategoricalColor(BuilderImpl builder) {
        this.categoryDataColors = builder.categoryDataColors;
        this.nullDataVisibility = builder.nullDataVisibility;
        this.nullDataSettings = builder.nullDataSettings;
        this.defaultOpacity = builder.defaultOpacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoryDataColors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCategoryDataColors() {
        return categoryDataColors != null && !(categoryDataColors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of categorical data colors for each category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoryDataColors} method.
     * </p>
     * 
     * @return A list of categorical data colors for each category.
     */
    public final List<GeospatialCategoricalDataColor> categoryDataColors() {
        return categoryDataColors;
    }

    /**
     * <p>
     * The state of visibility for null data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nullDataVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nullDataVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for null data.
     * @see Visibility
     */
    public final Visibility nullDataVisibility() {
        return Visibility.fromValue(nullDataVisibility);
    }

    /**
     * <p>
     * The state of visibility for null data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nullDataVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nullDataVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for null data.
     * @see Visibility
     */
    public final String nullDataVisibilityAsString() {
        return nullDataVisibility;
    }

    /**
     * <p>
     * The null data visualization settings.
     * </p>
     * 
     * @return The null data visualization settings.
     */
    public final GeospatialNullDataSettings nullDataSettings() {
        return nullDataSettings;
    }

    /**
     * <p>
     * The default opacity of a categorical color.
     * </p>
     * 
     * @return The default opacity of a categorical color.
     */
    public final Double defaultOpacity() {
        return defaultOpacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoryDataColors() ? categoryDataColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nullDataVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullDataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOpacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialCategoricalColor)) {
            return false;
        }
        GeospatialCategoricalColor other = (GeospatialCategoricalColor) obj;
        return hasCategoryDataColors() == other.hasCategoryDataColors()
                && Objects.equals(categoryDataColors(), other.categoryDataColors())
                && Objects.equals(nullDataVisibilityAsString(), other.nullDataVisibilityAsString())
                && Objects.equals(nullDataSettings(), other.nullDataSettings())
                && Objects.equals(defaultOpacity(), other.defaultOpacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialCategoricalColor")
                .add("CategoryDataColors", hasCategoryDataColors() ? categoryDataColors() : null)
                .add("NullDataVisibility", nullDataVisibilityAsString()).add("NullDataSettings", nullDataSettings())
                .add("DefaultOpacity", defaultOpacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryDataColors":
            return Optional.ofNullable(clazz.cast(categoryDataColors()));
        case "NullDataVisibility":
            return Optional.ofNullable(clazz.cast(nullDataVisibilityAsString()));
        case "NullDataSettings":
            return Optional.ofNullable(clazz.cast(nullDataSettings()));
        case "DefaultOpacity":
            return Optional.ofNullable(clazz.cast(defaultOpacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategoryDataColors", CATEGORY_DATA_COLORS_FIELD);
        map.put("NullDataVisibility", NULL_DATA_VISIBILITY_FIELD);
        map.put("NullDataSettings", NULL_DATA_SETTINGS_FIELD);
        map.put("DefaultOpacity", DEFAULT_OPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialCategoricalColor, T> g) {
        return obj -> g.apply((GeospatialCategoricalColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialCategoricalColor> {
        /**
         * <p>
         * A list of categorical data colors for each category.
         * </p>
         * 
         * @param categoryDataColors
         *        A list of categorical data colors for each category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryDataColors(Collection<GeospatialCategoricalDataColor> categoryDataColors);

        /**
         * <p>
         * A list of categorical data colors for each category.
         * </p>
         * 
         * @param categoryDataColors
         *        A list of categorical data colors for each category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryDataColors(GeospatialCategoricalDataColor... categoryDataColors);

        /**
         * <p>
         * A list of categorical data colors for each category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColor.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColor.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #categoryDataColors(List<GeospatialCategoricalDataColor>)}.
         * 
         * @param categoryDataColors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.GeospatialCategoricalDataColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryDataColors(java.util.Collection<GeospatialCategoricalDataColor>)
         */
        Builder categoryDataColors(Consumer<GeospatialCategoricalDataColor.Builder>... categoryDataColors);

        /**
         * <p>
         * The state of visibility for null data.
         * </p>
         * 
         * @param nullDataVisibility
         *        The state of visibility for null data.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder nullDataVisibility(String nullDataVisibility);

        /**
         * <p>
         * The state of visibility for null data.
         * </p>
         * 
         * @param nullDataVisibility
         *        The state of visibility for null data.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder nullDataVisibility(Visibility nullDataVisibility);

        /**
         * <p>
         * The null data visualization settings.
         * </p>
         * 
         * @param nullDataSettings
         *        The null data visualization settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings);

        /**
         * <p>
         * The null data visualization settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialNullDataSettings.Builder}
         * avoiding the need to create one manually via {@link GeospatialNullDataSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialNullDataSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #nullDataSettings(GeospatialNullDataSettings)}.
         * 
         * @param nullDataSettings
         *        a consumer that will call methods on {@link GeospatialNullDataSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullDataSettings(GeospatialNullDataSettings)
         */
        default Builder nullDataSettings(Consumer<GeospatialNullDataSettings.Builder> nullDataSettings) {
            return nullDataSettings(GeospatialNullDataSettings.builder().applyMutation(nullDataSettings).build());
        }

        /**
         * <p>
         * The default opacity of a categorical color.
         * </p>
         * 
         * @param defaultOpacity
         *        The default opacity of a categorical color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOpacity(Double defaultOpacity);
    }

    static final class BuilderImpl implements Builder {
        private List<GeospatialCategoricalDataColor> categoryDataColors = DefaultSdkAutoConstructList.getInstance();

        private String nullDataVisibility;

        private GeospatialNullDataSettings nullDataSettings;

        private Double defaultOpacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialCategoricalColor model) {
            categoryDataColors(model.categoryDataColors);
            nullDataVisibility(model.nullDataVisibility);
            nullDataSettings(model.nullDataSettings);
            defaultOpacity(model.defaultOpacity);
        }

        public final List<GeospatialCategoricalDataColor.Builder> getCategoryDataColors() {
            List<GeospatialCategoricalDataColor.Builder> result = GeospatialCategoricalDataColorListCopier
                    .copyToBuilder(this.categoryDataColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoryDataColors(Collection<GeospatialCategoricalDataColor.BuilderImpl> categoryDataColors) {
            this.categoryDataColors = GeospatialCategoricalDataColorListCopier.copyFromBuilder(categoryDataColors);
        }

        @Override
        public final Builder categoryDataColors(Collection<GeospatialCategoricalDataColor> categoryDataColors) {
            this.categoryDataColors = GeospatialCategoricalDataColorListCopier.copy(categoryDataColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryDataColors(GeospatialCategoricalDataColor... categoryDataColors) {
            categoryDataColors(Arrays.asList(categoryDataColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryDataColors(Consumer<GeospatialCategoricalDataColor.Builder>... categoryDataColors) {
            categoryDataColors(Stream.of(categoryDataColors)
                    .map(c -> GeospatialCategoricalDataColor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNullDataVisibility() {
            return nullDataVisibility;
        }

        public final void setNullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
        }

        @Override
        public final Builder nullDataVisibility(String nullDataVisibility) {
            this.nullDataVisibility = nullDataVisibility;
            return this;
        }

        @Override
        public final Builder nullDataVisibility(Visibility nullDataVisibility) {
            this.nullDataVisibility(nullDataVisibility == null ? null : nullDataVisibility.toString());
            return this;
        }

        public final GeospatialNullDataSettings.Builder getNullDataSettings() {
            return nullDataSettings != null ? nullDataSettings.toBuilder() : null;
        }

        public final void setNullDataSettings(GeospatialNullDataSettings.BuilderImpl nullDataSettings) {
            this.nullDataSettings = nullDataSettings != null ? nullDataSettings.build() : null;
        }

        @Override
        public final Builder nullDataSettings(GeospatialNullDataSettings nullDataSettings) {
            this.nullDataSettings = nullDataSettings;
            return this;
        }

        public final Double getDefaultOpacity() {
            return defaultOpacity;
        }

        public final void setDefaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
        }

        @Override
        public final Builder defaultOpacity(Double defaultOpacity) {
            this.defaultOpacity = defaultOpacity;
            return this;
        }

        @Override
        public GeospatialCategoricalColor build() {
            return new GeospatialCategoricalColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
