/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the border options for a table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableBorderOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalTableBorderOptions.Builder, GlobalTableBorderOptions> {
    private static final SdkField<TableBorderOptions> UNIFORM_BORDER_FIELD = SdkField
            .<TableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("UniformBorder")
            .getter(getter(GlobalTableBorderOptions::uniformBorder)).setter(setter(Builder::uniformBorder))
            .constructor(TableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniformBorder").build()).build();

    private static final SdkField<TableSideBorderOptions> SIDE_SPECIFIC_BORDER_FIELD = SdkField
            .<TableSideBorderOptions> builder(MarshallingType.SDK_POJO).memberName("SideSpecificBorder")
            .getter(getter(GlobalTableBorderOptions::sideSpecificBorder)).setter(setter(Builder::sideSpecificBorder))
            .constructor(TableSideBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideSpecificBorder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIFORM_BORDER_FIELD,
            SIDE_SPECIFIC_BORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableBorderOptions uniformBorder;

    private final TableSideBorderOptions sideSpecificBorder;

    private GlobalTableBorderOptions(BuilderImpl builder) {
        this.uniformBorder = builder.uniformBorder;
        this.sideSpecificBorder = builder.sideSpecificBorder;
    }

    /**
     * <p>
     * Determines the options for uniform border.
     * </p>
     * 
     * @return Determines the options for uniform border.
     */
    public final TableBorderOptions uniformBorder() {
        return uniformBorder;
    }

    /**
     * <p>
     * Determines the options for side specific border.
     * </p>
     * 
     * @return Determines the options for side specific border.
     */
    public final TableSideBorderOptions sideSpecificBorder() {
        return sideSpecificBorder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uniformBorder());
        hashCode = 31 * hashCode + Objects.hashCode(sideSpecificBorder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableBorderOptions)) {
            return false;
        }
        GlobalTableBorderOptions other = (GlobalTableBorderOptions) obj;
        return Objects.equals(uniformBorder(), other.uniformBorder())
                && Objects.equals(sideSpecificBorder(), other.sideSpecificBorder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalTableBorderOptions").add("UniformBorder", uniformBorder())
                .add("SideSpecificBorder", sideSpecificBorder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UniformBorder":
            return Optional.ofNullable(clazz.cast(uniformBorder()));
        case "SideSpecificBorder":
            return Optional.ofNullable(clazz.cast(sideSpecificBorder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UniformBorder", UNIFORM_BORDER_FIELD);
        map.put("SideSpecificBorder", SIDE_SPECIFIC_BORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableBorderOptions, T> g) {
        return obj -> g.apply((GlobalTableBorderOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalTableBorderOptions> {
        /**
         * <p>
         * Determines the options for uniform border.
         * </p>
         * 
         * @param uniformBorder
         *        Determines the options for uniform border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniformBorder(TableBorderOptions uniformBorder);

        /**
         * <p>
         * Determines the options for uniform border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableBorderOptions.Builder} avoiding the
         * need to create one manually via {@link TableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBorderOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #uniformBorder(TableBorderOptions)}.
         * 
         * @param uniformBorder
         *        a consumer that will call methods on {@link TableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uniformBorder(TableBorderOptions)
         */
        default Builder uniformBorder(Consumer<TableBorderOptions.Builder> uniformBorder) {
            return uniformBorder(TableBorderOptions.builder().applyMutation(uniformBorder).build());
        }

        /**
         * <p>
         * Determines the options for side specific border.
         * </p>
         * 
         * @param sideSpecificBorder
         *        Determines the options for side specific border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sideSpecificBorder(TableSideBorderOptions sideSpecificBorder);

        /**
         * <p>
         * Determines the options for side specific border.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableSideBorderOptions.Builder} avoiding
         * the need to create one manually via {@link TableSideBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableSideBorderOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #sideSpecificBorder(TableSideBorderOptions)}.
         * 
         * @param sideSpecificBorder
         *        a consumer that will call methods on {@link TableSideBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sideSpecificBorder(TableSideBorderOptions)
         */
        default Builder sideSpecificBorder(Consumer<TableSideBorderOptions.Builder> sideSpecificBorder) {
            return sideSpecificBorder(TableSideBorderOptions.builder().applyMutation(sideSpecificBorder).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableBorderOptions uniformBorder;

        private TableSideBorderOptions sideSpecificBorder;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableBorderOptions model) {
            uniformBorder(model.uniformBorder);
            sideSpecificBorder(model.sideSpecificBorder);
        }

        public final TableBorderOptions.Builder getUniformBorder() {
            return uniformBorder != null ? uniformBorder.toBuilder() : null;
        }

        public final void setUniformBorder(TableBorderOptions.BuilderImpl uniformBorder) {
            this.uniformBorder = uniformBorder != null ? uniformBorder.build() : null;
        }

        @Override
        public final Builder uniformBorder(TableBorderOptions uniformBorder) {
            this.uniformBorder = uniformBorder;
            return this;
        }

        public final TableSideBorderOptions.Builder getSideSpecificBorder() {
            return sideSpecificBorder != null ? sideSpecificBorder.toBuilder() : null;
        }

        public final void setSideSpecificBorder(TableSideBorderOptions.BuilderImpl sideSpecificBorder) {
            this.sideSpecificBorder = sideSpecificBorder != null ? sideSpecificBorder.build() : null;
        }

        @Override
        public final Builder sideSpecificBorder(TableSideBorderOptions sideSpecificBorder) {
            this.sideSpecificBorder = sideSpecificBorder;
            return this;
        }

        @Override
        public GlobalTableBorderOptions build() {
            return new GlobalTableBorderOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
