/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for the canvas of a grid layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridLayoutCanvasSizeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GridLayoutCanvasSizeOptions.Builder, GridLayoutCanvasSizeOptions> {
    private static final SdkField<GridLayoutScreenCanvasSizeOptions> SCREEN_CANVAS_SIZE_OPTIONS_FIELD = SdkField
            .<GridLayoutScreenCanvasSizeOptions> builder(MarshallingType.SDK_POJO).memberName("ScreenCanvasSizeOptions")
            .getter(getter(GridLayoutCanvasSizeOptions::screenCanvasSizeOptions))
            .setter(setter(Builder::screenCanvasSizeOptions)).constructor(GridLayoutScreenCanvasSizeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenCanvasSizeOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCREEN_CANVAS_SIZE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GridLayoutScreenCanvasSizeOptions screenCanvasSizeOptions;

    private GridLayoutCanvasSizeOptions(BuilderImpl builder) {
        this.screenCanvasSizeOptions = builder.screenCanvasSizeOptions;
    }

    /**
     * <p>
     * The options that determine the sizing of the canvas used in a grid layout.
     * </p>
     * 
     * @return The options that determine the sizing of the canvas used in a grid layout.
     */
    public final GridLayoutScreenCanvasSizeOptions screenCanvasSizeOptions() {
        return screenCanvasSizeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(screenCanvasSizeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutCanvasSizeOptions)) {
            return false;
        }
        GridLayoutCanvasSizeOptions other = (GridLayoutCanvasSizeOptions) obj;
        return Objects.equals(screenCanvasSizeOptions(), other.screenCanvasSizeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridLayoutCanvasSizeOptions").add("ScreenCanvasSizeOptions", screenCanvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScreenCanvasSizeOptions":
            return Optional.ofNullable(clazz.cast(screenCanvasSizeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScreenCanvasSizeOptions", SCREEN_CANVAS_SIZE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutCanvasSizeOptions, T> g) {
        return obj -> g.apply((GridLayoutCanvasSizeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridLayoutCanvasSizeOptions> {
        /**
         * <p>
         * The options that determine the sizing of the canvas used in a grid layout.
         * </p>
         * 
         * @param screenCanvasSizeOptions
         *        The options that determine the sizing of the canvas used in a grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions screenCanvasSizeOptions);

        /**
         * <p>
         * The options that determine the sizing of the canvas used in a grid layout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GridLayoutScreenCanvasSizeOptions.Builder} avoiding the need to create one manually via
         * {@link GridLayoutScreenCanvasSizeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GridLayoutScreenCanvasSizeOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions)}.
         * 
         * @param screenCanvasSizeOptions
         *        a consumer that will call methods on {@link GridLayoutScreenCanvasSizeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions)
         */
        default Builder screenCanvasSizeOptions(Consumer<GridLayoutScreenCanvasSizeOptions.Builder> screenCanvasSizeOptions) {
            return screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions.builder().applyMutation(screenCanvasSizeOptions)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GridLayoutScreenCanvasSizeOptions screenCanvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutCanvasSizeOptions model) {
            screenCanvasSizeOptions(model.screenCanvasSizeOptions);
        }

        public final GridLayoutScreenCanvasSizeOptions.Builder getScreenCanvasSizeOptions() {
            return screenCanvasSizeOptions != null ? screenCanvasSizeOptions.toBuilder() : null;
        }

        public final void setScreenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions.BuilderImpl screenCanvasSizeOptions) {
            this.screenCanvasSizeOptions = screenCanvasSizeOptions != null ? screenCanvasSizeOptions.build() : null;
        }

        @Override
        public final Builder screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptions screenCanvasSizeOptions) {
            this.screenCanvasSizeOptions = screenCanvasSizeOptions;
            return this;
        }

        @Override
        public GridLayoutCanvasSizeOptions build() {
            return new GridLayoutCanvasSizeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
