/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting for the progress bar of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIProgressBarConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<KPIProgressBarConditionalFormatting.Builder, KPIProgressBarConditionalFormatting> {
    private static final SdkField<ConditionalFormattingColor> FOREGROUND_COLOR_FIELD = SdkField
            .<ConditionalFormattingColor> builder(MarshallingType.SDK_POJO).memberName("ForegroundColor")
            .getter(getter(KPIProgressBarConditionalFormatting::foregroundColor)).setter(setter(Builder::foregroundColor))
            .constructor(ConditionalFormattingColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForegroundColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOREGROUND_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionalFormattingColor foregroundColor;

    private KPIProgressBarConditionalFormatting(BuilderImpl builder) {
        this.foregroundColor = builder.foregroundColor;
    }

    /**
     * <p>
     * The conditional formatting of the progress bar's foreground color.
     * </p>
     * 
     * @return The conditional formatting of the progress bar's foreground color.
     */
    public final ConditionalFormattingColor foregroundColor() {
        return foregroundColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(foregroundColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIProgressBarConditionalFormatting)) {
            return false;
        }
        KPIProgressBarConditionalFormatting other = (KPIProgressBarConditionalFormatting) obj;
        return Objects.equals(foregroundColor(), other.foregroundColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIProgressBarConditionalFormatting").add("ForegroundColor", foregroundColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForegroundColor":
            return Optional.ofNullable(clazz.cast(foregroundColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ForegroundColor", FOREGROUND_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIProgressBarConditionalFormatting, T> g) {
        return obj -> g.apply((KPIProgressBarConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIProgressBarConditionalFormatting> {
        /**
         * <p>
         * The conditional formatting of the progress bar's foreground color.
         * </p>
         * 
         * @param foregroundColor
         *        The conditional formatting of the progress bar's foreground color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foregroundColor(ConditionalFormattingColor foregroundColor);

        /**
         * <p>
         * The conditional formatting of the progress bar's foreground color.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingColor.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingColor.Builder#build()} is called immediately
         * and its result is passed to {@link #foregroundColor(ConditionalFormattingColor)}.
         * 
         * @param foregroundColor
         *        a consumer that will call methods on {@link ConditionalFormattingColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #foregroundColor(ConditionalFormattingColor)
         */
        default Builder foregroundColor(Consumer<ConditionalFormattingColor.Builder> foregroundColor) {
            return foregroundColor(ConditionalFormattingColor.builder().applyMutation(foregroundColor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionalFormattingColor foregroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIProgressBarConditionalFormatting model) {
            foregroundColor(model.foregroundColor);
        }

        public final ConditionalFormattingColor.Builder getForegroundColor() {
            return foregroundColor != null ? foregroundColor.toBuilder() : null;
        }

        public final void setForegroundColor(ConditionalFormattingColor.BuilderImpl foregroundColor) {
            this.foregroundColor = foregroundColor != null ? foregroundColor.build() : null;
        }

        @Override
        public final Builder foregroundColor(ConditionalFormattingColor foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        @Override
        public KPIProgressBarConditionalFormatting build() {
            return new KPIProgressBarConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
