/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options of a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ListControlDisplayOptions.Builder, ListControlDisplayOptions> {
    private static final SdkField<ListControlSearchOptions> SEARCH_OPTIONS_FIELD = SdkField
            .<ListControlSearchOptions> builder(MarshallingType.SDK_POJO).memberName("SearchOptions")
            .getter(getter(ListControlDisplayOptions::searchOptions)).setter(setter(Builder::searchOptions))
            .constructor(ListControlSearchOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchOptions").build()).build();

    private static final SdkField<ListControlSelectAllOptions> SELECT_ALL_OPTIONS_FIELD = SdkField
            .<ListControlSelectAllOptions> builder(MarshallingType.SDK_POJO).memberName("SelectAllOptions")
            .getter(getter(ListControlDisplayOptions::selectAllOptions)).setter(setter(Builder::selectAllOptions))
            .constructor(ListControlSelectAllOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()).build();

    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TitleOptions").getter(getter(ListControlDisplayOptions::titleOptions))
            .setter(setter(Builder::titleOptions)).constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()).build();

    private static final SdkField<SheetControlInfoIconLabelOptions> INFO_ICON_LABEL_OPTIONS_FIELD = SdkField
            .<SheetControlInfoIconLabelOptions> builder(MarshallingType.SDK_POJO).memberName("InfoIconLabelOptions")
            .getter(getter(ListControlDisplayOptions::infoIconLabelOptions)).setter(setter(Builder::infoIconLabelOptions))
            .constructor(SheetControlInfoIconLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoIconLabelOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_OPTIONS_FIELD,
            SELECT_ALL_OPTIONS_FIELD, TITLE_OPTIONS_FIELD, INFO_ICON_LABEL_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ListControlSearchOptions searchOptions;

    private final ListControlSelectAllOptions selectAllOptions;

    private final LabelOptions titleOptions;

    private final SheetControlInfoIconLabelOptions infoIconLabelOptions;

    private ListControlDisplayOptions(BuilderImpl builder) {
        this.searchOptions = builder.searchOptions;
        this.selectAllOptions = builder.selectAllOptions;
        this.titleOptions = builder.titleOptions;
        this.infoIconLabelOptions = builder.infoIconLabelOptions;
    }

    /**
     * <p>
     * The configuration of the search options in a list control.
     * </p>
     * 
     * @return The configuration of the search options in a list control.
     */
    public final ListControlSearchOptions searchOptions() {
        return searchOptions;
    }

    /**
     * <p>
     * The configuration of the <code>Select all</code> options in a list control.
     * </p>
     * 
     * @return The configuration of the <code>Select all</code> options in a list control.
     */
    public final ListControlSelectAllOptions selectAllOptions() {
        return selectAllOptions;
    }

    /**
     * <p>
     * The options to configure the title visibility, name, and font size.
     * </p>
     * 
     * @return The options to configure the title visibility, name, and font size.
     */
    public final LabelOptions titleOptions() {
        return titleOptions;
    }

    /**
     * <p>
     * The configuration of info icon label options.
     * </p>
     * 
     * @return The configuration of info icon label options.
     */
    public final SheetControlInfoIconLabelOptions infoIconLabelOptions() {
        return infoIconLabelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchOptions());
        hashCode = 31 * hashCode + Objects.hashCode(selectAllOptions());
        hashCode = 31 * hashCode + Objects.hashCode(titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(infoIconLabelOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlDisplayOptions)) {
            return false;
        }
        ListControlDisplayOptions other = (ListControlDisplayOptions) obj;
        return Objects.equals(searchOptions(), other.searchOptions())
                && Objects.equals(selectAllOptions(), other.selectAllOptions())
                && Objects.equals(titleOptions(), other.titleOptions())
                && Objects.equals(infoIconLabelOptions(), other.infoIconLabelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlDisplayOptions").add("SearchOptions", searchOptions())
                .add("SelectAllOptions", selectAllOptions()).add("TitleOptions", titleOptions())
                .add("InfoIconLabelOptions", infoIconLabelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchOptions":
            return Optional.ofNullable(clazz.cast(searchOptions()));
        case "SelectAllOptions":
            return Optional.ofNullable(clazz.cast(selectAllOptions()));
        case "TitleOptions":
            return Optional.ofNullable(clazz.cast(titleOptions()));
        case "InfoIconLabelOptions":
            return Optional.ofNullable(clazz.cast(infoIconLabelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchOptions", SEARCH_OPTIONS_FIELD);
        map.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
        map.put("TitleOptions", TITLE_OPTIONS_FIELD);
        map.put("InfoIconLabelOptions", INFO_ICON_LABEL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlDisplayOptions, T> g) {
        return obj -> g.apply((ListControlDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListControlDisplayOptions> {
        /**
         * <p>
         * The configuration of the search options in a list control.
         * </p>
         * 
         * @param searchOptions
         *        The configuration of the search options in a list control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchOptions(ListControlSearchOptions searchOptions);

        /**
         * <p>
         * The configuration of the search options in a list control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListControlSearchOptions.Builder}
         * avoiding the need to create one manually via {@link ListControlSearchOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListControlSearchOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #searchOptions(ListControlSearchOptions)}.
         * 
         * @param searchOptions
         *        a consumer that will call methods on {@link ListControlSearchOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchOptions(ListControlSearchOptions)
         */
        default Builder searchOptions(Consumer<ListControlSearchOptions.Builder> searchOptions) {
            return searchOptions(ListControlSearchOptions.builder().applyMutation(searchOptions).build());
        }

        /**
         * <p>
         * The configuration of the <code>Select all</code> options in a list control.
         * </p>
         * 
         * @param selectAllOptions
         *        The configuration of the <code>Select all</code> options in a list control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectAllOptions(ListControlSelectAllOptions selectAllOptions);

        /**
         * <p>
         * The configuration of the <code>Select all</code> options in a list control.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListControlSelectAllOptions.Builder}
         * avoiding the need to create one manually via {@link ListControlSelectAllOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListControlSelectAllOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #selectAllOptions(ListControlSelectAllOptions)}.
         * 
         * @param selectAllOptions
         *        a consumer that will call methods on {@link ListControlSelectAllOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectAllOptions(ListControlSelectAllOptions)
         */
        default Builder selectAllOptions(Consumer<ListControlSelectAllOptions.Builder> selectAllOptions) {
            return selectAllOptions(ListControlSelectAllOptions.builder().applyMutation(selectAllOptions).build());
        }

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * 
         * @param titleOptions
         *        The options to configure the title visibility, name, and font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOptions(LabelOptions titleOptions);

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #titleOptions(LabelOptions)}.
         * 
         * @param titleOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleOptions(LabelOptions)
         */
        default Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return titleOptions(LabelOptions.builder().applyMutation(titleOptions).build());
        }

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * 
         * @param infoIconLabelOptions
         *        The configuration of info icon label options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions);

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlInfoIconLabelOptions.Builder}
         * avoiding the need to create one manually via {@link SheetControlInfoIconLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlInfoIconLabelOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #infoIconLabelOptions(SheetControlInfoIconLabelOptions)}.
         * 
         * @param infoIconLabelOptions
         *        a consumer that will call methods on {@link SheetControlInfoIconLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infoIconLabelOptions(SheetControlInfoIconLabelOptions)
         */
        default Builder infoIconLabelOptions(Consumer<SheetControlInfoIconLabelOptions.Builder> infoIconLabelOptions) {
            return infoIconLabelOptions(SheetControlInfoIconLabelOptions.builder().applyMutation(infoIconLabelOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListControlSearchOptions searchOptions;

        private ListControlSelectAllOptions selectAllOptions;

        private LabelOptions titleOptions;

        private SheetControlInfoIconLabelOptions infoIconLabelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlDisplayOptions model) {
            searchOptions(model.searchOptions);
            selectAllOptions(model.selectAllOptions);
            titleOptions(model.titleOptions);
            infoIconLabelOptions(model.infoIconLabelOptions);
        }

        public final ListControlSearchOptions.Builder getSearchOptions() {
            return searchOptions != null ? searchOptions.toBuilder() : null;
        }

        public final void setSearchOptions(ListControlSearchOptions.BuilderImpl searchOptions) {
            this.searchOptions = searchOptions != null ? searchOptions.build() : null;
        }

        @Override
        public final Builder searchOptions(ListControlSearchOptions searchOptions) {
            this.searchOptions = searchOptions;
            return this;
        }

        public final ListControlSelectAllOptions.Builder getSelectAllOptions() {
            return selectAllOptions != null ? selectAllOptions.toBuilder() : null;
        }

        public final void setSelectAllOptions(ListControlSelectAllOptions.BuilderImpl selectAllOptions) {
            this.selectAllOptions = selectAllOptions != null ? selectAllOptions.build() : null;
        }

        @Override
        public final Builder selectAllOptions(ListControlSelectAllOptions selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        public final LabelOptions.Builder getTitleOptions() {
            return titleOptions != null ? titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final SheetControlInfoIconLabelOptions.Builder getInfoIconLabelOptions() {
            return infoIconLabelOptions != null ? infoIconLabelOptions.toBuilder() : null;
        }

        public final void setInfoIconLabelOptions(SheetControlInfoIconLabelOptions.BuilderImpl infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions != null ? infoIconLabelOptions.build() : null;
        }

        @Override
        public final Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions;
            return this;
        }

        @Override
        public ListControlDisplayOptions build() {
            return new ListControlDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
