/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort by field for the field sort options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableSortBy implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableSortBy.Builder, PivotTableSortBy> {
    private static final SdkField<FieldSort> FIELD_FIELD = SdkField.<FieldSort> builder(MarshallingType.SDK_POJO)
            .memberName("Field").getter(getter(PivotTableSortBy::field)).setter(setter(Builder::field))
            .constructor(FieldSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<ColumnSort> COLUMN_FIELD = SdkField.<ColumnSort> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(PivotTableSortBy::column)).setter(setter(Builder::column))
            .constructor(ColumnSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<DataPathSort> DATA_PATH_FIELD = SdkField.<DataPathSort> builder(MarshallingType.SDK_POJO)
            .memberName("DataPath").getter(getter(PivotTableSortBy::dataPath)).setter(setter(Builder::dataPath))
            .constructor(DataPathSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, COLUMN_FIELD,
            DATA_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldSort field;

    private final ColumnSort column;

    private final DataPathSort dataPath;

    private PivotTableSortBy(BuilderImpl builder) {
        this.field = builder.field;
        this.column = builder.column;
        this.dataPath = builder.dataPath;
    }

    /**
     * <p>
     * The field sort (field id, direction) for the pivot table sort by options.
     * </p>
     * 
     * @return The field sort (field id, direction) for the pivot table sort by options.
     */
    public final FieldSort field() {
        return field;
    }

    /**
     * <p>
     * The column sort (field id, direction) for the pivot table sort by options.
     * </p>
     * 
     * @return The column sort (field id, direction) for the pivot table sort by options.
     */
    public final ColumnSort column() {
        return column;
    }

    /**
     * <p>
     * The data path sort (data path value, direction) for the pivot table sort by options.
     * </p>
     * 
     * @return The data path sort (data path value, direction) for the pivot table sort by options.
     */
    public final DataPathSort dataPath() {
        return dataPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(dataPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableSortBy)) {
            return false;
        }
        PivotTableSortBy other = (PivotTableSortBy) obj;
        return Objects.equals(field(), other.field()) && Objects.equals(column(), other.column())
                && Objects.equals(dataPath(), other.dataPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableSortBy").add("Field", field()).add("Column", column()).add("DataPath", dataPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "DataPath":
            return Optional.ofNullable(clazz.cast(dataPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Field", FIELD_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("DataPath", DATA_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableSortBy, T> g) {
        return obj -> g.apply((PivotTableSortBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableSortBy> {
        /**
         * <p>
         * The field sort (field id, direction) for the pivot table sort by options.
         * </p>
         * 
         * @param field
         *        The field sort (field id, direction) for the pivot table sort by options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(FieldSort field);

        /**
         * <p>
         * The field sort (field id, direction) for the pivot table sort by options.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldSort.Builder} avoiding the need to
         * create one manually via {@link FieldSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldSort.Builder#build()} is called immediately and its result
         * is passed to {@link #field(FieldSort)}.
         * 
         * @param field
         *        a consumer that will call methods on {@link FieldSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #field(FieldSort)
         */
        default Builder field(Consumer<FieldSort.Builder> field) {
            return field(FieldSort.builder().applyMutation(field).build());
        }

        /**
         * <p>
         * The column sort (field id, direction) for the pivot table sort by options.
         * </p>
         * 
         * @param column
         *        The column sort (field id, direction) for the pivot table sort by options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnSort column);

        /**
         * <p>
         * The column sort (field id, direction) for the pivot table sort by options.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnSort.Builder} avoiding the need to
         * create one manually via {@link ColumnSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnSort.Builder#build()} is called immediately and its result
         * is passed to {@link #column(ColumnSort)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnSort)
         */
        default Builder column(Consumer<ColumnSort.Builder> column) {
            return column(ColumnSort.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The data path sort (data path value, direction) for the pivot table sort by options.
         * </p>
         * 
         * @param dataPath
         *        The data path sort (data path value, direction) for the pivot table sort by options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPath(DataPathSort dataPath);

        /**
         * <p>
         * The data path sort (data path value, direction) for the pivot table sort by options.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPathSort.Builder} avoiding the need
         * to create one manually via {@link DataPathSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPathSort.Builder#build()} is called immediately and its
         * result is passed to {@link #dataPath(DataPathSort)}.
         * 
         * @param dataPath
         *        a consumer that will call methods on {@link DataPathSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPath(DataPathSort)
         */
        default Builder dataPath(Consumer<DataPathSort.Builder> dataPath) {
            return dataPath(DataPathSort.builder().applyMutation(dataPath).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldSort field;

        private ColumnSort column;

        private DataPathSort dataPath;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableSortBy model) {
            field(model.field);
            column(model.column);
            dataPath(model.dataPath);
        }

        public final FieldSort.Builder getField() {
            return field != null ? field.toBuilder() : null;
        }

        public final void setField(FieldSort.BuilderImpl field) {
            this.field = field != null ? field.build() : null;
        }

        @Override
        public final Builder field(FieldSort field) {
            this.field = field;
            return this;
        }

        public final ColumnSort.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnSort.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnSort column) {
            this.column = column;
            return this;
        }

        public final DataPathSort.Builder getDataPath() {
            return dataPath != null ? dataPath.toBuilder() : null;
        }

        public final void setDataPath(DataPathSort.BuilderImpl dataPath) {
            this.dataPath = dataPath != null ? dataPath.build() : null;
        }

        @Override
        public final Builder dataPath(DataPathSort dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        @Override
        public PivotTableSortBy build() {
            return new PivotTableSortBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
