/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The series settings of a radar chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RadarChartSeriesSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RadarChartSeriesSettings.Builder, RadarChartSeriesSettings> {
    private static final SdkField<RadarChartAreaStyleSettings> AREA_STYLE_SETTINGS_FIELD = SdkField
            .<RadarChartAreaStyleSettings> builder(MarshallingType.SDK_POJO).memberName("AreaStyleSettings")
            .getter(getter(RadarChartSeriesSettings::areaStyleSettings)).setter(setter(Builder::areaStyleSettings))
            .constructor(RadarChartAreaStyleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaStyleSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_STYLE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RadarChartAreaStyleSettings areaStyleSettings;

    private RadarChartSeriesSettings(BuilderImpl builder) {
        this.areaStyleSettings = builder.areaStyleSettings;
    }

    /**
     * <p>
     * The area style settings of a radar chart.
     * </p>
     * 
     * @return The area style settings of a radar chart.
     */
    public final RadarChartAreaStyleSettings areaStyleSettings() {
        return areaStyleSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(areaStyleSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadarChartSeriesSettings)) {
            return false;
        }
        RadarChartSeriesSettings other = (RadarChartSeriesSettings) obj;
        return Objects.equals(areaStyleSettings(), other.areaStyleSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RadarChartSeriesSettings").add("AreaStyleSettings", areaStyleSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AreaStyleSettings":
            return Optional.ofNullable(clazz.cast(areaStyleSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AreaStyleSettings", AREA_STYLE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RadarChartSeriesSettings, T> g) {
        return obj -> g.apply((RadarChartSeriesSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RadarChartSeriesSettings> {
        /**
         * <p>
         * The area style settings of a radar chart.
         * </p>
         * 
         * @param areaStyleSettings
         *        The area style settings of a radar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaStyleSettings(RadarChartAreaStyleSettings areaStyleSettings);

        /**
         * <p>
         * The area style settings of a radar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartAreaStyleSettings.Builder}
         * avoiding the need to create one manually via {@link RadarChartAreaStyleSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartAreaStyleSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #areaStyleSettings(RadarChartAreaStyleSettings)}.
         * 
         * @param areaStyleSettings
         *        a consumer that will call methods on {@link RadarChartAreaStyleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areaStyleSettings(RadarChartAreaStyleSettings)
         */
        default Builder areaStyleSettings(Consumer<RadarChartAreaStyleSettings.Builder> areaStyleSettings) {
            return areaStyleSettings(RadarChartAreaStyleSettings.builder().applyMutation(areaStyleSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RadarChartAreaStyleSettings areaStyleSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(RadarChartSeriesSettings model) {
            areaStyleSettings(model.areaStyleSettings);
        }

        public final RadarChartAreaStyleSettings.Builder getAreaStyleSettings() {
            return areaStyleSettings != null ? areaStyleSettings.toBuilder() : null;
        }

        public final void setAreaStyleSettings(RadarChartAreaStyleSettings.BuilderImpl areaStyleSettings) {
            this.areaStyleSettings = areaStyleSettings != null ? areaStyleSettings.build() : null;
        }

        @Override
        public final Builder areaStyleSettings(RadarChartAreaStyleSettings areaStyleSettings) {
            this.areaStyleSettings = areaStyleSettings;
            return this;
        }

        @Override
        public RadarChartSeriesSettings build() {
            return new RadarChartSeriesSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
