/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The URL content (text, icon) for the table link configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldLinkContentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldLinkContentConfiguration.Builder, TableFieldLinkContentConfiguration> {
    private static final SdkField<TableFieldCustomTextContent> CUSTOM_TEXT_CONTENT_FIELD = SdkField
            .<TableFieldCustomTextContent> builder(MarshallingType.SDK_POJO).memberName("CustomTextContent")
            .getter(getter(TableFieldLinkContentConfiguration::customTextContent)).setter(setter(Builder::customTextContent))
            .constructor(TableFieldCustomTextContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomTextContent").build()).build();

    private static final SdkField<TableFieldCustomIconContent> CUSTOM_ICON_CONTENT_FIELD = SdkField
            .<TableFieldCustomIconContent> builder(MarshallingType.SDK_POJO).memberName("CustomIconContent")
            .getter(getter(TableFieldLinkContentConfiguration::customIconContent)).setter(setter(Builder::customIconContent))
            .constructor(TableFieldCustomIconContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomIconContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_TEXT_CONTENT_FIELD,
            CUSTOM_ICON_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableFieldCustomTextContent customTextContent;

    private final TableFieldCustomIconContent customIconContent;

    private TableFieldLinkContentConfiguration(BuilderImpl builder) {
        this.customTextContent = builder.customTextContent;
        this.customIconContent = builder.customIconContent;
    }

    /**
     * <p>
     * The custom text content (value, font configuration) for the table link content configuration.
     * </p>
     * 
     * @return The custom text content (value, font configuration) for the table link content configuration.
     */
    public final TableFieldCustomTextContent customTextContent() {
        return customTextContent;
    }

    /**
     * <p>
     * The custom icon content for the table link content configuration.
     * </p>
     * 
     * @return The custom icon content for the table link content configuration.
     */
    public final TableFieldCustomIconContent customIconContent() {
        return customIconContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customTextContent());
        hashCode = 31 * hashCode + Objects.hashCode(customIconContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldLinkContentConfiguration)) {
            return false;
        }
        TableFieldLinkContentConfiguration other = (TableFieldLinkContentConfiguration) obj;
        return Objects.equals(customTextContent(), other.customTextContent())
                && Objects.equals(customIconContent(), other.customIconContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldLinkContentConfiguration").add("CustomTextContent", customTextContent())
                .add("CustomIconContent", customIconContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomTextContent":
            return Optional.ofNullable(clazz.cast(customTextContent()));
        case "CustomIconContent":
            return Optional.ofNullable(clazz.cast(customIconContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomTextContent", CUSTOM_TEXT_CONTENT_FIELD);
        map.put("CustomIconContent", CUSTOM_ICON_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldLinkContentConfiguration, T> g) {
        return obj -> g.apply((TableFieldLinkContentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldLinkContentConfiguration> {
        /**
         * <p>
         * The custom text content (value, font configuration) for the table link content configuration.
         * </p>
         * 
         * @param customTextContent
         *        The custom text content (value, font configuration) for the table link content configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customTextContent(TableFieldCustomTextContent customTextContent);

        /**
         * <p>
         * The custom text content (value, font configuration) for the table link content configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableFieldCustomTextContent.Builder}
         * avoiding the need to create one manually via {@link TableFieldCustomTextContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldCustomTextContent.Builder#build()} is called
         * immediately and its result is passed to {@link #customTextContent(TableFieldCustomTextContent)}.
         * 
         * @param customTextContent
         *        a consumer that will call methods on {@link TableFieldCustomTextContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customTextContent(TableFieldCustomTextContent)
         */
        default Builder customTextContent(Consumer<TableFieldCustomTextContent.Builder> customTextContent) {
            return customTextContent(TableFieldCustomTextContent.builder().applyMutation(customTextContent).build());
        }

        /**
         * <p>
         * The custom icon content for the table link content configuration.
         * </p>
         * 
         * @param customIconContent
         *        The custom icon content for the table link content configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customIconContent(TableFieldCustomIconContent customIconContent);

        /**
         * <p>
         * The custom icon content for the table link content configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableFieldCustomIconContent.Builder}
         * avoiding the need to create one manually via {@link TableFieldCustomIconContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldCustomIconContent.Builder#build()} is called
         * immediately and its result is passed to {@link #customIconContent(TableFieldCustomIconContent)}.
         * 
         * @param customIconContent
         *        a consumer that will call methods on {@link TableFieldCustomIconContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customIconContent(TableFieldCustomIconContent)
         */
        default Builder customIconContent(Consumer<TableFieldCustomIconContent.Builder> customIconContent) {
            return customIconContent(TableFieldCustomIconContent.builder().applyMutation(customIconContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableFieldCustomTextContent customTextContent;

        private TableFieldCustomIconContent customIconContent;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldLinkContentConfiguration model) {
            customTextContent(model.customTextContent);
            customIconContent(model.customIconContent);
        }

        public final TableFieldCustomTextContent.Builder getCustomTextContent() {
            return customTextContent != null ? customTextContent.toBuilder() : null;
        }

        public final void setCustomTextContent(TableFieldCustomTextContent.BuilderImpl customTextContent) {
            this.customTextContent = customTextContent != null ? customTextContent.build() : null;
        }

        @Override
        public final Builder customTextContent(TableFieldCustomTextContent customTextContent) {
            this.customTextContent = customTextContent;
            return this;
        }

        public final TableFieldCustomIconContent.Builder getCustomIconContent() {
            return customIconContent != null ? customIconContent.toBuilder() : null;
        }

        public final void setCustomIconContent(TableFieldCustomIconContent.BuilderImpl customIconContent) {
            this.customIconContent = customIconContent != null ? customIconContent.build() : null;
        }

        @Override
        public final Builder customIconContent(TableFieldCustomIconContent customIconContent) {
            this.customIconContent = customIconContent;
            return this;
        }

        @Override
        public TableFieldLinkContentConfiguration build() {
            return new TableFieldLinkContentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
