/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time range drill down filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRangeDrillDownFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeRangeDrillDownFilter.Builder, TimeRangeDrillDownFilter> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(TimeRangeDrillDownFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Instant> RANGE_MINIMUM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RangeMinimum").getter(getter(TimeRangeDrillDownFilter::rangeMinimum))
            .setter(setter(Builder::rangeMinimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimum").build()).build();

    private static final SdkField<Instant> RANGE_MAXIMUM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RangeMaximum").getter(getter(TimeRangeDrillDownFilter::rangeMaximum))
            .setter(setter(Builder::rangeMaximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximum").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TimeRangeDrillDownFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            RANGE_MINIMUM_FIELD, RANGE_MAXIMUM_FIELD, TIME_GRANULARITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final Instant rangeMinimum;

    private final Instant rangeMaximum;

    private final String timeGranularity;

    private TimeRangeDrillDownFilter(BuilderImpl builder) {
        this.column = builder.column;
        this.rangeMinimum = builder.rangeMinimum;
        this.rangeMaximum = builder.rangeMaximum;
        this.timeGranularity = builder.timeGranularity;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The minimum value for the filter value range.
     * </p>
     * 
     * @return The minimum value for the filter value range.
     */
    public final Instant rangeMinimum() {
        return rangeMinimum;
    }

    /**
     * <p>
     * The maximum value for the filter value range.
     * </p>
     * 
     * @return The maximum value for the filter value range.
     */
    public final Instant rangeMaximum() {
        return rangeMaximum;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeDrillDownFilter)) {
            return false;
        }
        TimeRangeDrillDownFilter other = (TimeRangeDrillDownFilter) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(rangeMinimum(), other.rangeMinimum())
                && Objects.equals(rangeMaximum(), other.rangeMaximum())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRangeDrillDownFilter").add("Column", column()).add("RangeMinimum", rangeMinimum())
                .add("RangeMaximum", rangeMaximum()).add("TimeGranularity", timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "RangeMinimum":
            return Optional.ofNullable(clazz.cast(rangeMinimum()));
        case "RangeMaximum":
            return Optional.ofNullable(clazz.cast(rangeMaximum()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("RangeMinimum", RANGE_MINIMUM_FIELD);
        map.put("RangeMaximum", RANGE_MAXIMUM_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeDrillDownFilter, T> g) {
        return obj -> g.apply((TimeRangeDrillDownFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRangeDrillDownFilter> {
        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The minimum value for the filter value range.
         * </p>
         * 
         * @param rangeMinimum
         *        The minimum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMinimum(Instant rangeMinimum);

        /**
         * <p>
         * The maximum value for the filter value range.
         * </p>
         * 
         * @param rangeMaximum
         *        The maximum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMaximum(Instant rangeMaximum);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private Instant rangeMinimum;

        private Instant rangeMaximum;

        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeDrillDownFilter model) {
            column(model.column);
            rangeMinimum(model.rangeMinimum);
            rangeMaximum(model.rangeMaximum);
            timeGranularity(model.timeGranularity);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Instant getRangeMinimum() {
            return rangeMinimum;
        }

        public final void setRangeMinimum(Instant rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
        }

        @Override
        public final Builder rangeMinimum(Instant rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
            return this;
        }

        public final Instant getRangeMaximum() {
            return rangeMaximum;
        }

        public final void setRangeMaximum(Instant rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
        }

        @Override
        public final Builder rangeMaximum(Instant rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        @Override
        public TimeRangeDrillDownFilter build() {
            return new TimeRangeDrillDownFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
