/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A constant value that is used in a range filter to specify the endpoints of the range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRangeFilterConstant implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRangeFilterConstant.Builder, TopicRangeFilterConstant> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstantType").getter(getter(TopicRangeFilterConstant::constantTypeAsString))
            .setter(setter(Builder::constantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()).build();

    private static final SdkField<RangeConstant> RANGE_CONSTANT_FIELD = SdkField
            .<RangeConstant> builder(MarshallingType.SDK_POJO).memberName("RangeConstant")
            .getter(getter(TopicRangeFilterConstant::rangeConstant)).setter(setter(Builder::rangeConstant))
            .constructor(RangeConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeConstant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD,
            RANGE_CONSTANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String constantType;

    private final RangeConstant rangeConstant;

    private TopicRangeFilterConstant(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.rangeConstant = builder.rangeConstant;
    }

    /**
     * <p>
     * The data type of the constant value that is used in a range filter. Valid values for this structure are
     * <code>RANGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The data type of the constant value that is used in a range filter. Valid values for this structure are
     *         <code>RANGE</code>.
     * @see ConstantType
     */
    public final ConstantType constantType() {
        return ConstantType.fromValue(constantType);
    }

    /**
     * <p>
     * The data type of the constant value that is used in a range filter. Valid values for this structure are
     * <code>RANGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The data type of the constant value that is used in a range filter. Valid values for this structure are
     *         <code>RANGE</code>.
     * @see ConstantType
     */
    public final String constantTypeAsString() {
        return constantType;
    }

    /**
     * <p>
     * The value of the constant that is used to specify the endpoints of a range filter.
     * </p>
     * 
     * @return The value of the constant that is used to specify the endpoints of a range filter.
     */
    public final RangeConstant rangeConstant() {
        return rangeConstant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rangeConstant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRangeFilterConstant)) {
            return false;
        }
        TopicRangeFilterConstant other = (TopicRangeFilterConstant) obj;
        return Objects.equals(constantTypeAsString(), other.constantTypeAsString())
                && Objects.equals(rangeConstant(), other.rangeConstant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRangeFilterConstant").add("ConstantType", constantTypeAsString())
                .add("RangeConstant", rangeConstant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantType":
            return Optional.ofNullable(clazz.cast(constantTypeAsString()));
        case "RangeConstant":
            return Optional.ofNullable(clazz.cast(rangeConstant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConstantType", CONSTANT_TYPE_FIELD);
        map.put("RangeConstant", RANGE_CONSTANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRangeFilterConstant, T> g) {
        return obj -> g.apply((TopicRangeFilterConstant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRangeFilterConstant> {
        /**
         * <p>
         * The data type of the constant value that is used in a range filter. Valid values for this structure are
         * <code>RANGE</code>.
         * </p>
         * 
         * @param constantType
         *        The data type of the constant value that is used in a range filter. Valid values for this structure
         *        are <code>RANGE</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(String constantType);

        /**
         * <p>
         * The data type of the constant value that is used in a range filter. Valid values for this structure are
         * <code>RANGE</code>.
         * </p>
         * 
         * @param constantType
         *        The data type of the constant value that is used in a range filter. Valid values for this structure
         *        are <code>RANGE</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(ConstantType constantType);

        /**
         * <p>
         * The value of the constant that is used to specify the endpoints of a range filter.
         * </p>
         * 
         * @param rangeConstant
         *        The value of the constant that is used to specify the endpoints of a range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeConstant(RangeConstant rangeConstant);

        /**
         * <p>
         * The value of the constant that is used to specify the endpoints of a range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link RangeConstant.Builder} avoiding the need
         * to create one manually via {@link RangeConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangeConstant.Builder#build()} is called immediately and its
         * result is passed to {@link #rangeConstant(RangeConstant)}.
         * 
         * @param rangeConstant
         *        a consumer that will call methods on {@link RangeConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeConstant(RangeConstant)
         */
        default Builder rangeConstant(Consumer<RangeConstant.Builder> rangeConstant) {
            return rangeConstant(RangeConstant.builder().applyMutation(rangeConstant).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String constantType;

        private RangeConstant rangeConstant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRangeFilterConstant model) {
            constantType(model.constantType);
            rangeConstant(model.rangeConstant);
        }

        public final String getConstantType() {
            return constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final RangeConstant.Builder getRangeConstant() {
            return rangeConstant != null ? rangeConstant.toBuilder() : null;
        }

        public final void setRangeConstant(RangeConstant.BuilderImpl rangeConstant) {
            this.rangeConstant = rangeConstant != null ? rangeConstant.build() : null;
        }

        @Override
        public final Builder rangeConstant(RangeConstant rangeConstant) {
            this.rangeConstant = rangeConstant;
            return this;
        }

        @Override
        public TopicRangeFilterConstant build() {
            return new TopicRangeFilterConstant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
