/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about the refresh of a topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRefreshDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRefreshDetails.Builder, TopicRefreshDetails> {
    private static final SdkField<String> REFRESH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshArn").getter(getter(TopicRefreshDetails::refreshArn)).setter(setter(Builder::refreshArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshArn").build()).build();

    private static final SdkField<String> REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshId").getter(getter(TopicRefreshDetails::refreshId)).setter(setter(Builder::refreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshId").build()).build();

    private static final SdkField<String> REFRESH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshStatus").getter(getter(TopicRefreshDetails::refreshStatusAsString))
            .setter(setter(Builder::refreshStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_ARN_FIELD,
            REFRESH_ID_FIELD, REFRESH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String refreshArn;

    private final String refreshId;

    private final String refreshStatus;

    private TopicRefreshDetails(BuilderImpl builder) {
        this.refreshArn = builder.refreshArn;
        this.refreshId = builder.refreshId;
        this.refreshStatus = builder.refreshStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic refresh.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic refresh.
     */
    public final String refreshArn() {
        return refreshArn;
    }

    /**
     * <p>
     * The ID of the refresh, which occurs as a result of topic creation or topic update.
     * </p>
     * 
     * @return The ID of the refresh, which occurs as a result of topic creation or topic update.
     */
    public final String refreshId() {
        return refreshId;
    }

    /**
     * <p>
     * The status of the refresh job that indicates whether the job is still running, completed successfully, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #refreshStatus}
     * will return {@link TopicRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #refreshStatusAsString}.
     * </p>
     * 
     * @return The status of the refresh job that indicates whether the job is still running, completed successfully, or
     *         failed.
     * @see TopicRefreshStatus
     */
    public final TopicRefreshStatus refreshStatus() {
        return TopicRefreshStatus.fromValue(refreshStatus);
    }

    /**
     * <p>
     * The status of the refresh job that indicates whether the job is still running, completed successfully, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #refreshStatus}
     * will return {@link TopicRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #refreshStatusAsString}.
     * </p>
     * 
     * @return The status of the refresh job that indicates whether the job is still running, completed successfully, or
     *         failed.
     * @see TopicRefreshStatus
     */
    public final String refreshStatusAsString() {
        return refreshStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refreshArn());
        hashCode = 31 * hashCode + Objects.hashCode(refreshId());
        hashCode = 31 * hashCode + Objects.hashCode(refreshStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRefreshDetails)) {
            return false;
        }
        TopicRefreshDetails other = (TopicRefreshDetails) obj;
        return Objects.equals(refreshArn(), other.refreshArn()) && Objects.equals(refreshId(), other.refreshId())
                && Objects.equals(refreshStatusAsString(), other.refreshStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRefreshDetails").add("RefreshArn", refreshArn()).add("RefreshId", refreshId())
                .add("RefreshStatus", refreshStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshArn":
            return Optional.ofNullable(clazz.cast(refreshArn()));
        case "RefreshId":
            return Optional.ofNullable(clazz.cast(refreshId()));
        case "RefreshStatus":
            return Optional.ofNullable(clazz.cast(refreshStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefreshArn", REFRESH_ARN_FIELD);
        map.put("RefreshId", REFRESH_ID_FIELD);
        map.put("RefreshStatus", REFRESH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRefreshDetails, T> g) {
        return obj -> g.apply((TopicRefreshDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRefreshDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the topic refresh.
         * </p>
         * 
         * @param refreshArn
         *        The Amazon Resource Name (ARN) of the topic refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshArn(String refreshArn);

        /**
         * <p>
         * The ID of the refresh, which occurs as a result of topic creation or topic update.
         * </p>
         * 
         * @param refreshId
         *        The ID of the refresh, which occurs as a result of topic creation or topic update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshId(String refreshId);

        /**
         * <p>
         * The status of the refresh job that indicates whether the job is still running, completed successfully, or
         * failed.
         * </p>
         * 
         * @param refreshStatus
         *        The status of the refresh job that indicates whether the job is still running, completed successfully,
         *        or failed.
         * @see TopicRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRefreshStatus
         */
        Builder refreshStatus(String refreshStatus);

        /**
         * <p>
         * The status of the refresh job that indicates whether the job is still running, completed successfully, or
         * failed.
         * </p>
         * 
         * @param refreshStatus
         *        The status of the refresh job that indicates whether the job is still running, completed successfully,
         *        or failed.
         * @see TopicRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRefreshStatus
         */
        Builder refreshStatus(TopicRefreshStatus refreshStatus);
    }

    static final class BuilderImpl implements Builder {
        private String refreshArn;

        private String refreshId;

        private String refreshStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRefreshDetails model) {
            refreshArn(model.refreshArn);
            refreshId(model.refreshId);
            refreshStatus(model.refreshStatus);
        }

        public final String getRefreshArn() {
            return refreshArn;
        }

        public final void setRefreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
        }

        @Override
        public final Builder refreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
            return this;
        }

        public final String getRefreshId() {
            return refreshId;
        }

        public final void setRefreshId(String refreshId) {
            this.refreshId = refreshId;
        }

        @Override
        public final Builder refreshId(String refreshId) {
            this.refreshId = refreshId;
            return this;
        }

        public final String getRefreshStatus() {
            return refreshStatus;
        }

        public final void setRefreshStatus(String refreshStatus) {
            this.refreshStatus = refreshStatus;
        }

        @Override
        public final Builder refreshStatus(String refreshStatus) {
            this.refreshStatus = refreshStatus;
            return this;
        }

        @Override
        public final Builder refreshStatus(TopicRefreshStatus refreshStatus) {
            this.refreshStatus(refreshStatus == null ? null : refreshStatus.toString());
            return this;
        }

        @Override
        public TopicRefreshDetails build() {
            return new TopicRefreshDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
