/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrandAssignmentResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateBrandAssignmentResponse.Builder, UpdateBrandAssignmentResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateBrandAssignmentResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> BRAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandArn").getter(getter(UpdateBrandAssignmentResponse::brandArn)).setter(setter(Builder::brandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            BRAND_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestId;

    private final String brandArn;

    private UpdateBrandAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.brandArn = builder.brandArn;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the brand.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the brand.
     */
    public final String brandArn() {
        return brandArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(brandArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrandAssignmentResponse)) {
            return false;
        }
        UpdateBrandAssignmentResponse other = (UpdateBrandAssignmentResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(brandArn(), other.brandArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrandAssignmentResponse").add("RequestId", requestId()).add("BrandArn", brandArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "BrandArn":
            return Optional.ofNullable(clazz.cast(brandArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("BrandArn", BRAND_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrandAssignmentResponse, T> g) {
        return obj -> g.apply((UpdateBrandAssignmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrandAssignmentResponse> {
        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the brand.
         * </p>
         * 
         * @param brandArn
         *        The Amazon Resource Name (ARN) of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandArn(String brandArn);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String requestId;

        private String brandArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrandAssignmentResponse model) {
            super(model);
            requestId(model.requestId);
            brandArn(model.brandArn);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getBrandArn() {
            return brandArn;
        }

        public final void setBrandArn(String brandArn) {
            this.brandArn = brandArn;
        }

        @Override
        public final Builder brandArn(String brandArn) {
            this.brandArn = brandArn;
            return this;
        }

        @Override
        public UpdateBrandAssignmentResponse build() {
            return new UpdateBrandAssignmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
