/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.DimensionFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.services.quicksight.model.MeasureFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPIFieldWells
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPIFieldWells> {
    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(KPIFieldWells.getter(KPIFieldWells::values)).setter(KPIFieldWells.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MeasureField>> TARGET_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetValues").getter(KPIFieldWells.getter(KPIFieldWells::targetValues)).setter(KPIFieldWells.setter(Builder::targetValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DimensionField>> TREND_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrendGroups").getter(KPIFieldWells.getter(KPIFieldWells::trendGroups)).setter(KPIFieldWells.setter(Builder::trendGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, TARGET_VALUES_FIELD, TREND_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KPIFieldWells.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MeasureField> values;
    private final List<MeasureField> targetValues;
    private final List<DimensionField> trendGroups;

    private KPIFieldWells(BuilderImpl builder) {
        this.values = builder.values;
        this.targetValues = builder.targetValues;
        this.trendGroups = builder.trendGroups;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<MeasureField> values() {
        return this.values;
    }

    public final boolean hasTargetValues() {
        return this.targetValues != null && !(this.targetValues instanceof SdkAutoConstructList);
    }

    public final List<MeasureField> targetValues() {
        return this.targetValues;
    }

    public final boolean hasTrendGroups() {
        return this.trendGroups != null && !(this.trendGroups instanceof SdkAutoConstructList);
    }

    public final List<DimensionField> trendGroups() {
        return this.trendGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetValues() ? this.targetValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrendGroups() ? this.trendGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIFieldWells)) {
            return false;
        }
        KPIFieldWells other = (KPIFieldWells)obj;
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasTargetValues() == other.hasTargetValues() && Objects.equals(this.targetValues(), other.targetValues()) && this.hasTrendGroups() == other.hasTrendGroups() && Objects.equals(this.trendGroups(), other.trendGroups());
    }

    public final String toString() {
        return ToString.builder((String)"KPIFieldWells").add("Values", this.hasValues() ? this.values() : null).add("TargetValues", this.hasTargetValues() ? this.targetValues() : null).add("TrendGroups", this.hasTrendGroups() ? this.trendGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "TargetValues": {
                return Optional.ofNullable(clazz.cast(this.targetValues()));
            }
            case "TrendGroups": {
                return Optional.ofNullable(clazz.cast(this.trendGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Values", VALUES_FIELD);
        map.put("TargetValues", TARGET_VALUES_FIELD);
        map.put("TrendGroups", TREND_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIFieldWells, T> g) {
        return obj -> g.apply((KPIFieldWells)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();
        private List<MeasureField> targetValues = DefaultSdkAutoConstructList.getInstance();
        private List<DimensionField> trendGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KPIFieldWells model) {
            this.values(model.values);
            this.targetValues(model.targetValues);
            this.trendGroups(model.trendGroups);
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = MeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = MeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getTargetValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.targetValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetValues(Collection<MeasureField.BuilderImpl> targetValues) {
            this.targetValues = MeasureFieldListCopier.copyFromBuilder(targetValues);
        }

        @Override
        public final Builder targetValues(Collection<MeasureField> targetValues) {
            this.targetValues = MeasureFieldListCopier.copy(targetValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetValues(MeasureField ... targetValues) {
            this.targetValues(Arrays.asList(targetValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetValues(Consumer<MeasureField.Builder> ... targetValues) {
            this.targetValues(Stream.of(targetValues).map(c -> (MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getTrendGroups() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.trendGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrendGroups(Collection<DimensionField.BuilderImpl> trendGroups) {
            this.trendGroups = DimensionFieldListCopier.copyFromBuilder(trendGroups);
        }

        @Override
        public final Builder trendGroups(Collection<DimensionField> trendGroups) {
            this.trendGroups = DimensionFieldListCopier.copy(trendGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendGroups(DimensionField ... trendGroups) {
            this.trendGroups(Arrays.asList(trendGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendGroups(Consumer<DimensionField.Builder> ... trendGroups) {
            this.trendGroups(Stream.of(trendGroups).map(c -> (DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public KPIFieldWells build() {
            return new KPIFieldWells(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPIFieldWells> {
        public Builder values(Collection<MeasureField> var1);

        public Builder values(MeasureField ... var1);

        public Builder values(Consumer<MeasureField.Builder> ... var1);

        public Builder targetValues(Collection<MeasureField> var1);

        public Builder targetValues(MeasureField ... var1);

        public Builder targetValues(Consumer<MeasureField.Builder> ... var1);

        public Builder trendGroups(Collection<DimensionField> var1);

        public Builder trendGroups(DimensionField ... var1);

        public Builder trendGroups(Consumer<DimensionField.Builder> ... var1);
    }
}

