/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.TopicSummariesCopier;
import software.amazon.awssdk.services.quicksight.model.TopicSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTopicsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, SearchTopicsResponse> {
    private static final SdkField<List<TopicSummary>> TOPIC_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicSummaryList").getter(SearchTopicsResponse.getter(SearchTopicsResponse::topicSummaryList)).setter(SearchTopicsResponse.setter(Builder::topicSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchTopicsResponse.getter(SearchTopicsResponse::nextToken)).setter(SearchTopicsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(SearchTopicsResponse.getter(SearchTopicsResponse::status)).setter(SearchTopicsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SearchTopicsResponse.getter(SearchTopicsResponse::requestId)).setter(SearchTopicsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchTopicsResponse.memberNameToFieldInitializer();
    private final List<TopicSummary> topicSummaryList;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private SearchTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.topicSummaryList = builder.topicSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final boolean hasTopicSummaryList() {
        return this.topicSummaryList != null && !(this.topicSummaryList instanceof SdkAutoConstructList);
    }

    public final List<TopicSummary> topicSummaryList() {
        return this.topicSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicSummaryList() ? this.topicSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTopicsResponse)) {
            return false;
        }
        SearchTopicsResponse other = (SearchTopicsResponse)((Object)obj);
        return this.hasTopicSummaryList() == other.hasTopicSummaryList() && Objects.equals(this.topicSummaryList(), other.topicSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTopicsResponse").add("TopicSummaryList", this.hasTopicSummaryList() ? this.topicSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicSummaryList": {
                return Optional.ofNullable(clazz.cast(this.topicSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicSummaryList", TOPIC_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTopicsResponse, T> g) {
        return obj -> g.apply((SearchTopicsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<TopicSummary> topicSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTopicsResponse model) {
            super(model);
            this.topicSummaryList(model.topicSummaryList);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final List<TopicSummary.Builder> getTopicSummaryList() {
            List<TopicSummary.Builder> result = TopicSummariesCopier.copyToBuilder(this.topicSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicSummaryList(Collection<TopicSummary.BuilderImpl> topicSummaryList) {
            this.topicSummaryList = TopicSummariesCopier.copyFromBuilder(topicSummaryList);
        }

        @Override
        public final Builder topicSummaryList(Collection<TopicSummary> topicSummaryList) {
            this.topicSummaryList = TopicSummariesCopier.copy(topicSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicSummaryList(TopicSummary ... topicSummaryList) {
            this.topicSummaryList(Arrays.asList(topicSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicSummaryList(Consumer<TopicSummary.Builder> ... topicSummaryList) {
            this.topicSummaryList(Stream.of(topicSummaryList).map(c -> (TopicSummary)((TopicSummary.Builder)TopicSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public SearchTopicsResponse build() {
            return new SearchTopicsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTopicsResponse> {
        public Builder topicSummaryList(Collection<TopicSummary> var1);

        public Builder topicSummaryList(TopicSummary ... var1);

        public Builder topicSummaryList(Consumer<TopicSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

