/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColorsConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.ColumnRole;
import software.amazon.awssdk.services.quicksight.model.FormatConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(ColumnConfiguration.getter(ColumnConfiguration::column)).setter(ColumnConfiguration.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<FormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatConfiguration").getter(ColumnConfiguration.getter(ColumnConfiguration::formatConfiguration)).setter(ColumnConfiguration.setter(Builder::formatConfiguration)).constructor(FormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(ColumnConfiguration.getter(ColumnConfiguration::roleAsString)).setter(ColumnConfiguration.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<ColorsConfiguration> COLORS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorsConfiguration").getter(ColumnConfiguration.getter(ColumnConfiguration::colorsConfiguration)).setter(ColumnConfiguration.setter(Builder::colorsConfiguration)).constructor(ColorsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, FORMAT_CONFIGURATION_FIELD, ROLE_FIELD, COLORS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final FormatConfiguration formatConfiguration;
    private final String role;
    private final ColorsConfiguration colorsConfiguration;

    private ColumnConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.formatConfiguration = builder.formatConfiguration;
        this.role = builder.role;
        this.colorsConfiguration = builder.colorsConfiguration;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final FormatConfiguration formatConfiguration() {
        return this.formatConfiguration;
    }

    public final ColumnRole role() {
        return ColumnRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final ColorsConfiguration colorsConfiguration() {
        return this.colorsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration other = (ColumnConfiguration)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.formatConfiguration(), other.formatConfiguration()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.colorsConfiguration(), other.colorsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnConfiguration").add("Column", (Object)this.column()).add("FormatConfiguration", (Object)this.formatConfiguration()).add("Role", (Object)this.roleAsString()).add("ColorsConfiguration", (Object)this.colorsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "FormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.formatConfiguration()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "ColorsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.colorsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Column", COLUMN_FIELD);
        map.put("FormatConfiguration", FORMAT_CONFIGURATION_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("ColorsConfiguration", COLORS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnConfiguration, T> g) {
        return obj -> g.apply((ColumnConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private FormatConfiguration formatConfiguration;
        private String role;
        private ColorsConfiguration colorsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnConfiguration model) {
            this.column(model.column);
            this.formatConfiguration(model.formatConfiguration);
            this.role(model.role);
            this.colorsConfiguration(model.colorsConfiguration);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final FormatConfiguration.Builder getFormatConfiguration() {
            return this.formatConfiguration != null ? this.formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(FormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(FormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(ColumnRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final ColorsConfiguration.Builder getColorsConfiguration() {
            return this.colorsConfiguration != null ? this.colorsConfiguration.toBuilder() : null;
        }

        public final void setColorsConfiguration(ColorsConfiguration.BuilderImpl colorsConfiguration) {
            this.colorsConfiguration = colorsConfiguration != null ? colorsConfiguration.build() : null;
        }

        @Override
        public final Builder colorsConfiguration(ColorsConfiguration colorsConfiguration) {
            this.colorsConfiguration = colorsConfiguration;
            return this;
        }

        public ColumnConfiguration build() {
            return new ColumnConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnConfiguration> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder formatConfiguration(FormatConfiguration var1);

        default public Builder formatConfiguration(Consumer<FormatConfiguration.Builder> formatConfiguration) {
            return this.formatConfiguration((FormatConfiguration)((FormatConfiguration.Builder)FormatConfiguration.builder().applyMutation(formatConfiguration)).build());
        }

        public Builder role(String var1);

        public Builder role(ColumnRole var1);

        public Builder colorsConfiguration(ColorsConfiguration var1);

        default public Builder colorsConfiguration(Consumer<ColorsConfiguration.Builder> colorsConfiguration) {
            return this.colorsConfiguration((ColorsConfiguration)((ColorsConfiguration.Builder)ColorsConfiguration.builder().applyMutation(colorsConfiguration)).build());
        }
    }
}

