/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.TopicSummary;

public class SearchTopicsPublisher
implements SdkPublisher<SearchTopicsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchTopicsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchTopicsPublisher(QuickSightAsyncClient client, SearchTopicsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchTopicsPublisher(QuickSightAsyncClient client, SearchTopicsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchTopicsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchTopicsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicSummary> topicSummaryList() {
        Function<SearchTopicsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topicSummaryList() != null) {
                return response.topicSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchTopicsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchTopicsResponseFetcher
    implements AsyncPageFetcher<SearchTopicsResponse> {
        private SearchTopicsResponseFetcher() {
        }

        public boolean hasNextPage(SearchTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchTopicsResponse> nextPage(SearchTopicsResponse previousPage) {
            if (previousPage == null) {
                return SearchTopicsPublisher.this.client.searchTopics(SearchTopicsPublisher.this.firstRequest);
            }
            return SearchTopicsPublisher.this.client.searchTopics((SearchTopicsRequest)((Object)SearchTopicsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

