/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.StaticFileSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageStaticFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageStaticFile> {
    private static final SdkField<String> STATIC_FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticFileId").getter(ImageStaticFile.getter(ImageStaticFile::staticFileId)).setter(ImageStaticFile.setter(Builder::staticFileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticFileId").build()}).build();
    private static final SdkField<StaticFileSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ImageStaticFile.getter(ImageStaticFile::source)).setter(ImageStaticFile.setter(Builder::source)).constructor(StaticFileSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FILE_ID_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageStaticFile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String staticFileId;
    private final StaticFileSource source;

    private ImageStaticFile(BuilderImpl builder) {
        this.staticFileId = builder.staticFileId;
        this.source = builder.source;
    }

    public final String staticFileId() {
        return this.staticFileId;
    }

    public final StaticFileSource source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticFileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageStaticFile)) {
            return false;
        }
        ImageStaticFile other = (ImageStaticFile)obj;
        return Objects.equals(this.staticFileId(), other.staticFileId()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"ImageStaticFile").add("StaticFileId", (Object)this.staticFileId()).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticFileId": {
                return Optional.ofNullable(clazz.cast(this.staticFileId()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StaticFileId", STATIC_FILE_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageStaticFile, T> g) {
        return obj -> g.apply((ImageStaticFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String staticFileId;
        private StaticFileSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageStaticFile model) {
            this.staticFileId(model.staticFileId);
            this.source(model.source);
        }

        public final String getStaticFileId() {
            return this.staticFileId;
        }

        public final void setStaticFileId(String staticFileId) {
            this.staticFileId = staticFileId;
        }

        @Override
        public final Builder staticFileId(String staticFileId) {
            this.staticFileId = staticFileId;
            return this;
        }

        public final StaticFileSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(StaticFileSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(StaticFileSource source) {
            this.source = source;
            return this;
        }

        public ImageStaticFile build() {
            return new ImageStaticFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageStaticFile> {
        public Builder staticFileId(String var1);

        public Builder source(StaticFileSource var1);

        default public Builder source(Consumer<StaticFileSource.Builder> source) {
            return this.source((StaticFileSource)((StaticFileSource.Builder)StaticFileSource.builder().applyMutation(source)).build());
        }
    }
}

