/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableFieldLinkContentConfiguration;
import software.amazon.awssdk.services.quicksight.model.URLTargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableFieldLinkConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableFieldLinkConfiguration> {
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(TableFieldLinkConfiguration.getter(TableFieldLinkConfiguration::targetAsString)).setter(TableFieldLinkConfiguration.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<TableFieldLinkContentConfiguration> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Content").getter(TableFieldLinkConfiguration.getter(TableFieldLinkConfiguration::content)).setter(TableFieldLinkConfiguration.setter(Builder::content)).constructor(TableFieldLinkContentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableFieldLinkConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String target;
    private final TableFieldLinkContentConfiguration content;

    private TableFieldLinkConfiguration(BuilderImpl builder) {
        this.target = builder.target;
        this.content = builder.content;
    }

    public final URLTargetConfiguration target() {
        return URLTargetConfiguration.fromValue(this.target);
    }

    public final String targetAsString() {
        return this.target;
    }

    public final TableFieldLinkContentConfiguration content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldLinkConfiguration)) {
            return false;
        }
        TableFieldLinkConfiguration other = (TableFieldLinkConfiguration)obj;
        return Objects.equals(this.targetAsString(), other.targetAsString()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"TableFieldLinkConfiguration").add("Target", (Object)this.targetAsString()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Target", TARGET_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldLinkConfiguration, T> g) {
        return obj -> g.apply((TableFieldLinkConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String target;
        private TableFieldLinkContentConfiguration content;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldLinkConfiguration model) {
            this.target(model.target);
            this.content(model.content);
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(URLTargetConfiguration target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final TableFieldLinkContentConfiguration.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(TableFieldLinkContentConfiguration.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(TableFieldLinkContentConfiguration content) {
            this.content = content;
            return this;
        }

        public TableFieldLinkConfiguration build() {
            return new TableFieldLinkConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableFieldLinkConfiguration> {
        public Builder target(String var1);

        public Builder target(URLTargetConfiguration var1);

        public Builder content(TableFieldLinkContentConfiguration var1);

        default public Builder content(Consumer<TableFieldLinkContentConfiguration.Builder> content) {
            return this.content((TableFieldLinkContentConfiguration)((TableFieldLinkContentConfiguration.Builder)TableFieldLinkContentConfiguration.builder().applyMutation(content)).build());
        }
    }
}

