/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.quicksight.internal.QuickSightServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.BatchCreateTopicReviewedAnswerRequest;
import software.amazon.awssdk.services.quicksight.model.BatchCreateTopicReviewedAnswerResponse;
import software.amazon.awssdk.services.quicksight.model.BatchDeleteTopicReviewedAnswerRequest;
import software.amazon.awssdk.services.quicksight.model.BatchDeleteTopicReviewedAnswerResponse;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.ConcurrentUpdatingException;
import software.amazon.awssdk.services.quicksight.model.ConflictException;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.CreateBrandRequest;
import software.amazon.awssdk.services.quicksight.model.CreateBrandResponse;
import software.amazon.awssdk.services.quicksight.model.CreateCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.CreateCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.CreateRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.CreateRoleMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateRoleMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTopicResponse;
import software.amazon.awssdk.services.quicksight.model.CreateVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.CustomerManagedKeyUnavailableException;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIdentityPropagationConfigRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIdentityPropagationConfigResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleExportJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleExportJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleImportJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleImportJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResultRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResultResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardsQaConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardsQaConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeKeyRegistrationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeKeyRegistrationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeQPersonalizationConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeQPersonalizationConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeQuickSightQSearchConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeQuickSightQSearchConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InternalServerException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.InvalidRequestException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsResponse;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsResponse;
import software.amazon.awssdk.services.quicksight.model.ListBrandsRequest;
import software.amazon.awssdk.services.quicksight.model.ListBrandsResponse;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIdentityPropagationConfigsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIdentityPropagationConfigsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse;
import software.amazon.awssdk.services.quicksight.model.ListRefreshSchedulesRequest;
import software.amazon.awssdk.services.quicksight.model.ListRefreshSchedulesResponse;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicRefreshSchedulesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicRefreshSchedulesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicReviewedAnswersRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicReviewedAnswersResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.PredictQaResultsRequest;
import software.amazon.awssdk.services.quicksight.model.PredictQaResultsResponse;
import software.amazon.awssdk.services.quicksight.model.PutDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.PutDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleExportJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleExportJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleImportJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleImportJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedPricingPlanException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardLinksRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardLinksResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardsQaConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardsQaConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIdentityPropagationConfigRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIdentityPropagationConfigResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateKeyRegistrationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateKeyRegistrationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateQPersonalizationConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateQPersonalizationConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateQuickSightQSearchConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateQuickSightQSearchConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateSpiceCapacityConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateSpiceCapacityConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.transform.BatchCreateTopicReviewedAnswerRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.BatchDeleteTopicReviewedAnswerRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CancelIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateRoleMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIdentityPropagationConfigRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRoleMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserByPrincipalIdRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAssetBundleExportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAssetBundleImportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardSnapshotJobResultRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardsQaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderResolvedPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeKeyRegistrationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeQPersonalizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeQuickSightQSearchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRefreshRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForAnonymousUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserWithIdentityRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetDashboardEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetSessionEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAssetBundleExportJobsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAssetBundleImportJobsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListBrandsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFolderMembersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsForUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIdentityPropagationConfigsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIngestionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListRefreshSchedulesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListRoleMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicRefreshSchedulesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicReviewedAnswersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListVpcConnectionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.PredictQaResultsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.PutDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RegisterUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RestoreAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchTopicsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartAssetBundleExportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartAssetBundleImportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartDashboardSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartDashboardSnapshotJobScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateApplicationWithTokenExchangeGrantRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardLinksRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardsQaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIdentityPropagationConfigRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateKeyRegistrationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdatePublicSharingSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateQPersonalizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateQuickSightQSearchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateSpiceCapacityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateVpcConnectionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link QuickSightAsyncClient}.
 *
 * @see QuickSightAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQuickSightAsyncClient implements QuickSightAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultQuickSightAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQuickSightAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates new reviewed answers for a Q Topic.
     * </p>
     *
     * @param batchCreateTopicReviewedAnswerRequest
     * @return A Java Future containing the result of the BatchCreateTopicReviewedAnswer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.BatchCreateTopicReviewedAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/BatchCreateTopicReviewedAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateTopicReviewedAnswerResponse> batchCreateTopicReviewedAnswer(
            BatchCreateTopicReviewedAnswerRequest batchCreateTopicReviewedAnswerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateTopicReviewedAnswerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateTopicReviewedAnswerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateTopicReviewedAnswer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateTopicReviewedAnswerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchCreateTopicReviewedAnswerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchCreateTopicReviewedAnswerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateTopicReviewedAnswerRequest, BatchCreateTopicReviewedAnswerResponse>()
                            .withOperationName("BatchCreateTopicReviewedAnswer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchCreateTopicReviewedAnswerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchCreateTopicReviewedAnswerRequest));
            CompletableFuture<BatchCreateTopicReviewedAnswerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes reviewed answers for Q Topic.
     * </p>
     *
     * @param batchDeleteTopicReviewedAnswerRequest
     * @return A Java Future containing the result of the BatchDeleteTopicReviewedAnswer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.BatchDeleteTopicReviewedAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/BatchDeleteTopicReviewedAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteTopicReviewedAnswerResponse> batchDeleteTopicReviewedAnswer(
            BatchDeleteTopicReviewedAnswerRequest batchDeleteTopicReviewedAnswerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteTopicReviewedAnswerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteTopicReviewedAnswerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteTopicReviewedAnswer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteTopicReviewedAnswerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteTopicReviewedAnswerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDeleteTopicReviewedAnswerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteTopicReviewedAnswerRequest, BatchDeleteTopicReviewedAnswerResponse>()
                            .withOperationName("BatchDeleteTopicReviewedAnswer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteTopicReviewedAnswerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteTopicReviewedAnswerRequest));
            CompletableFuture<BatchDeleteTopicReviewedAnswerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return A Java Future containing the result of the CancelIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CancelIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelIngestionResponse> cancelIngestion(CancelIngestionRequest cancelIngestionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelIngestionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelIngestionRequest, CancelIngestionResponse>()
                            .withOperationName("CancelIngestion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelIngestionRequest));
            CompletableFuture<CancelIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a
     * custom default theme by using the <code>CreateAccountCustomization</code> or
     * <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon
     * QuickSight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a
     * QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply
     * to an Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code>
     * API operation. To share the theme, grant permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code>
     * API operation.
     * </p>
     *
     * @param createAccountCustomizationRequest
     * @return A Java Future containing the result of the CreateAccountCustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountCustomizationResponse> createAccountCustomization(
            CreateAccountCustomizationRequest createAccountCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccountCustomizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountCustomizationRequest, CreateAccountCustomizationResponse>()
                            .withOperationName("CreateAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccountCustomizationRequest));
            CompletableFuture<CreateAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     * </p>
     * <p>
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK.
     * </p>
     * <p>
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you
     * don't have an Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html">Sign up for Amazon Web
     * Services</a> in the <i>Amazon QuickSight User Guide</i>. The person who signs up for Amazon QuickSight needs to
     * have the correct Identity and Access Management (IAM) permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html">IAM Policy Examples for Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * If your IAM policy includes both the <code>Subscribe</code> and <code>CreateAccountSubscription</code> actions,
     * make sure that both actions are set to <code>Allow</code>. If either action is set to <code>Deny</code>, the
     * <code>Deny</code> action prevails and your API call fails.
     * </p>
     * <p>
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To
     * pass your existing IAM role to Amazon QuickSight, see <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role"
     * >Passing IAM roles to Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default
     * resource access from the Amazon QuickSight console. For more information about setting default resource access to
     * Amazon Web Services services, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html">Setting default resource
     * access to Amazon Web Services services</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createAccountSubscriptionRequest
     * @return A Java Future containing the result of the CreateAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountSubscriptionResponse> createAccountSubscription(
            CreateAccountSubscriptionRequest createAccountSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccountSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountSubscriptionRequest, CreateAccountSubscriptionResponse>()
                            .withOperationName("CreateAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccountSubscriptionRequest));
            CompletableFuture<CreateAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an
     * <code>AnalysisDefinition</code>.
     * </p>
     *
     * @param createAnalysisRequest
     * @return A Java Future containing the result of the CreateAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAnalysisResponse> createAnalysis(CreateAnalysisRequest createAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAnalysisRequest, CreateAnalysisResponse>()
                            .withOperationName("CreateAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAnalysisRequest));
            CompletableFuture<CreateAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight brand.
     * </p>
     *
     * @param createBrandRequest
     * @return A Java Future containing the result of the CreateBrand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBrandResponse> createBrand(CreateBrandRequest createBrandRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBrandResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateBrandResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBrandRequest, CreateBrandResponse>()
                            .withOperationName("CreateBrand").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBrandRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBrandRequest));
            CompletableFuture<CreateBrandResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom permissions profile.
     * </p>
     *
     * @param createCustomPermissionsRequest
     * @return A Java Future containing the result of the CreateCustomPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomPermissionsResponse> createCustomPermissions(
            CreateCustomPermissionsRequest createCustomPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCustomPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomPermissionsRequest, CreateCustomPermissionsResponse>()
                            .withOperationName("CreateCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomPermissionsRequest));
            CompletableFuture<CreateCustomPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dashboard from either a template or directly with a <code>DashboardDefinition</code>. To first create a
     * template, see the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code>
     * API operation.
     * </p>
     * <p>
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses.
     * You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports
     * from them. If you have the correct permissions, you can create a dashboard from a template that exists in a
     * different Amazon Web Services account.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                            .withOperationName("CreateDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDashboardRequest));
            CompletableFuture<CreateDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param createDataSetRequest
     * @return A Java Future containing the result of the CreateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSetResponse> createDataSet(CreateDataSetRequest createDataSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDataSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSetRequest, CreateDataSetResponse>()
                            .withOperationName("CreateDataSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataSetRequest));
            CompletableFuture<CreateDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>CustomerManagedKeyUnavailableException The customer managed key that is registered to your Amazon
     *         QuickSight account is unavailable.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                            .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataSourceRequest));
            CompletableFuture<CreateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty shared folder.
     * </p>
     *
     * @param createFolderRequest
     * @return A Java Future containing the result of the CreateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFolderResponse> createFolder(CreateFolderRequest createFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFolderRequest, CreateFolderResponse>()
                            .withOperationName("CreateFolder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFolderRequest));
            CompletableFuture<CreateFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     * </p>
     *
     * @param createFolderMembershipRequest
     * @return A Java Future containing the result of the CreateFolderMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFolderMembershipResponse> createFolderMembership(
            CreateFolderMembershipRequest createFolderMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFolderMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolderMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFolderMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFolderMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFolderMembershipRequest, CreateFolderMembershipResponse>()
                            .withOperationName("CreateFolderMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFolderMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFolderMembershipRequest));
            CompletableFuture<CreateFolderMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>CreateGroup</code> operation to create a group in Amazon QuickSight. You can create up to 10,000
     * groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact Amazon Web Services
     * Support.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:&lt;your-region&gt;:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            CreateGroupMembershipRequest createGroupMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGroupMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupMembershipRequest, CreateGroupMembershipResponse>()
                            .withOperationName("CreateGroupMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupMembershipRequest));
            CompletableFuture<CreateGroupMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per
     * Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are
     * unique.
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the CreateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIamPolicyAssignmentResponse> createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIamPolicyAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIamPolicyAssignmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIamPolicyAssignmentRequest, CreateIamPolicyAssignmentResponse>()
                            .withOperationName("CreateIAMPolicyAssignment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIamPolicyAssignmentRequest));
            CompletableFuture<CreateIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise
     * edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8
     * times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services
     * Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIngestionResponse> createIngestion(CreateIngestionRequest createIngestionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIngestionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIngestionRequest, CreateIngestionResponse>()
                            .withOperationName("CreateIngestion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIngestionRequest));
            CompletableFuture<CreateIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     * </p>
     * <p>
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace.
     * Users that access the namespace can share assets only with other users or groups in the same namespace. They
     * can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account
     * is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By
     * default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a
     * ticket with Amazon Web ServicesSupport.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                            .withOperationName("CreateNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNamespaceRequest));
            CompletableFuture<CreateNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a refresh schedule for a dataset. You can create up to 5 different schedules for a single dataset.
     * </p>
     *
     * @param createRefreshScheduleRequest
     * @return A Java Future containing the result of the CreateRefreshSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRefreshScheduleResponse> createRefreshSchedule(
            CreateRefreshScheduleRequest createRefreshScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRefreshSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRefreshScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRefreshScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRefreshScheduleRequest, CreateRefreshScheduleResponse>()
                            .withOperationName("CreateRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRefreshScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRefreshScheduleRequest));
            CompletableFuture<CreateRefreshScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use <code>CreateRoleMembership</code> to add an existing Amazon QuickSight group to an existing role.
     * </p>
     *
     * @param createRoleMembershipRequest
     * @return A Java Future containing the result of the CreateRoleMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateRoleMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRoleMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRoleMembershipResponse> createRoleMembership(
            CreateRoleMembershipRequest createRoleMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoleMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoleMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRoleMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRoleMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateRoleMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRoleMembershipRequest, CreateRoleMembershipResponse>()
                            .withOperationName("CreateRoleMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRoleMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRoleMembershipRequest));
            CompletableFuture<CreateRoleMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a template either from a <code>TemplateDefinition</code> or from an existing Amazon QuickSight analysis
     * or template. You can use the resulting template to create additional dashboards, templates, or analyses.
     * </p>
     * <p>
     * A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis
     * and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to
     * replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     *
     * @param createTemplateRequest
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTemplateResponse> createTemplate(CreateTemplateRequest createTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTemplateRequest, CreateTemplateResponse>()
                            .withOperationName("CreateTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTemplateRequest));
            CompletableFuture<CreateTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return A Java Future containing the result of the CreateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTemplateAliasResponse> createTemplateAlias(
            CreateTemplateAliasRequest createTemplateAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTemplateAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTemplateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTemplateAliasRequest, CreateTemplateAliasResponse>()
                            .withOperationName("CreateTemplateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTemplateAliasRequest));
            CompletableFuture<CreateTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createThemeRequest
     * @return A Java Future containing the result of the CreateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThemeResponse> createTheme(CreateThemeRequest createThemeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThemeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateThemeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThemeRequest, CreateThemeResponse>()
                            .withOperationName("CreateTheme").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createThemeRequest));
            CompletableFuture<CreateThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     *
     * @param createThemeAliasRequest
     * @return A Java Future containing the result of the CreateThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThemeAliasResponse> createThemeAlias(CreateThemeAliasRequest createThemeAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThemeAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThemeAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThemeAliasRequest, CreateThemeAliasResponse>()
                            .withOperationName("CreateThemeAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createThemeAliasRequest));
            CompletableFuture<CreateThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Q topic.
     * </p>
     *
     * @param createTopicRequest
     * @return A Java Future containing the result of the CreateTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTopicResponse> createTopic(CreateTopicRequest createTopicRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTopicResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTopicResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTopicResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRequest, CreateTopicResponse>()
                            .withOperationName("CreateTopic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTopicRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTopicRequest));
            CompletableFuture<CreateTopicResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a topic refresh schedule.
     * </p>
     *
     * @param createTopicRefreshScheduleRequest
     * @return A Java Future containing the result of the CreateTopicRefreshSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTopicRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopicRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTopicRefreshScheduleResponse> createTopicRefreshSchedule(
            CreateTopicRefreshScheduleRequest createTopicRefreshScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRefreshSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTopicRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTopicRefreshScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTopicRefreshScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRefreshScheduleRequest, CreateTopicRefreshScheduleResponse>()
                            .withOperationName("CreateTopicRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTopicRefreshScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTopicRefreshScheduleRequest));
            CompletableFuture<CreateTopicRefreshScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new VPC connection.
     * </p>
     *
     * @param createVpcConnectionRequest
     * @return A Java Future containing the result of the CreateVPCConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateVPCConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateVPCConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcConnectionResponse> createVPCConnection(
            CreateVpcConnectionRequest createVpcConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVPCConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVpcConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateVpcConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcConnectionRequest, CreateVpcConnectionResponse>()
                            .withOperationName("CreateVPCConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcConnectionRequest));
            CompletableFuture<CreateVpcConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web
     * Services account and Amazon QuickSight namespace.
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     * @return A Java Future containing the result of the DeleteAccountCustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountCustomizationResponse> deleteAccountCustomization(
            DeleteAccountCustomizationRequest deleteAccountCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountCustomizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountCustomizationRequest, DeleteAccountCustomizationResponse>()
                            .withOperationName("DeleteAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccountCustomizationRequest));
            CompletableFuture<DeleteAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>DeleteAccountSubscription</code> operation to delete an Amazon QuickSight account. This operation
     * will result in an error message if you have configured your account termination protection settings to
     * <code>True</code>. To change this setting and delete your account, call the <code>UpdateAccountSettings</code>
     * API and set the value of the <code>TerminationProtectionEnabled</code> parameter to <code>False</code>, then make
     * another call to the <code>DeleteAccountSubscription</code> API.
     * </p>
     *
     * @param deleteAccountSubscriptionRequest
     * @return A Java Future containing the result of the DeleteAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountSubscriptionResponse> deleteAccountSubscription(
            DeleteAccountSubscriptionRequest deleteAccountSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountSubscriptionRequest, DeleteAccountSubscriptionResponse>()
                            .withOperationName("DeleteAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccountSubscriptionRequest));
            CompletableFuture<DeleteAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon
     * QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery
     * window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     *
     * @param deleteAnalysisRequest
     * @return A Java Future containing the result of the DeleteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAnalysisResponse> deleteAnalysis(DeleteAnalysisRequest deleteAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAnalysisRequest, DeleteAnalysisResponse>()
                            .withOperationName("DeleteAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAnalysisRequest));
            CompletableFuture<DeleteAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon QuickSight brand.
     * </p>
     *
     * @param deleteBrandRequest
     * @return A Java Future containing the result of the DeleteBrand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBrandResponse> deleteBrand(DeleteBrandRequest deleteBrandRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBrandResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBrandResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBrandRequest, DeleteBrandResponse>()
                            .withOperationName("DeleteBrand").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBrandRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBrandRequest));
            CompletableFuture<DeleteBrandResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a brand assignment.
     * </p>
     *
     * @param deleteBrandAssignmentRequest
     * @return A Java Future containing the result of the DeleteBrandAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteBrandAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteBrandAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBrandAssignmentResponse> deleteBrandAssignment(
            DeleteBrandAssignmentRequest deleteBrandAssignmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrandAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrandAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrandAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBrandAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBrandAssignmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBrandAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBrandAssignmentRequest, DeleteBrandAssignmentResponse>()
                            .withOperationName("DeleteBrandAssignment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBrandAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBrandAssignmentRequest));
            CompletableFuture<DeleteBrandAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom permissions profile.
     * </p>
     *
     * @param deleteCustomPermissionsRequest
     * @return A Java Future containing the result of the DeleteCustomPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomPermissionsResponse> deleteCustomPermissions(
            DeleteCustomPermissionsRequest deleteCustomPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCustomPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomPermissionsRequest, DeleteCustomPermissionsResponse>()
                            .withOperationName("DeleteCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomPermissionsRequest));
            CompletableFuture<DeleteCustomPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                            .withOperationName("DeleteDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDashboardRequest));
            CompletableFuture<DeleteDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return A Java Future containing the result of the DeleteDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSetResponse> deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDataSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSetRequest, DeleteDataSetResponse>()
                            .withOperationName("DeleteDataSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataSetRequest));
            CompletableFuture<DeleteDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the dataset refresh properties of the dataset.
     * </p>
     *
     * @param deleteDataSetRefreshPropertiesRequest
     * @return A Java Future containing the result of the DeleteDataSetRefreshProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSetRefreshProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSetRefreshPropertiesResponse> deleteDataSetRefreshProperties(
            DeleteDataSetRefreshPropertiesRequest deleteDataSetRefreshPropertiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSetRefreshPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDataSetRefreshPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSetRefreshProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSetRefreshPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataSetRefreshPropertiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDataSetRefreshPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSetRefreshPropertiesRequest, DeleteDataSetRefreshPropertiesResponse>()
                            .withOperationName("DeleteDataSetRefreshProperties").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataSetRefreshPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataSetRefreshPropertiesRequest));
            CompletableFuture<DeleteDataSetRefreshPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                            .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataSourceRequest));
            CompletableFuture<DeleteDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a linked Amazon Q Business application from an Amazon QuickSight account
     * </p>
     *
     * @param deleteDefaultQBusinessApplicationRequest
     * @return A Java Future containing the result of the DeleteDefaultQBusinessApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDefaultQBusinessApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDefaultQBusinessApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDefaultQBusinessApplicationResponse> deleteDefaultQBusinessApplication(
            DeleteDefaultQBusinessApplicationRequest deleteDefaultQBusinessApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDefaultQBusinessApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDefaultQBusinessApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultQBusinessApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDefaultQBusinessApplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteDefaultQBusinessApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDefaultQBusinessApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDefaultQBusinessApplicationRequest, DeleteDefaultQBusinessApplicationResponse>()
                            .withOperationName("DeleteDefaultQBusinessApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDefaultQBusinessApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDefaultQBusinessApplicationRequest));
            CompletableFuture<DeleteDefaultQBusinessApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an empty folder.
     * </p>
     *
     * @param deleteFolderRequest
     * @return A Java Future containing the result of the DeleteFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFolderResponse> deleteFolder(DeleteFolderRequest deleteFolderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderRequest, DeleteFolderResponse>()
                            .withOperationName("DeleteFolder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFolderRequest));
            CompletableFuture<DeleteFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     * </p>
     *
     * @param deleteFolderMembershipRequest
     * @return A Java Future containing the result of the DeleteFolderMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFolderMembershipResponse> deleteFolderMembership(
            DeleteFolderMembershipRequest deleteFolderMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFolderMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolderMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFolderMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFolderMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderMembershipRequest, DeleteFolderMembershipResponse>()
                            .withOperationName("DeleteFolderMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFolderMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFolderMembershipRequest));
            CompletableFuture<DeleteFolderMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGroupMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGroupMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupMembershipRequest, DeleteGroupMembershipResponse>()
                            .withOperationName("DeleteGroupMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupMembershipRequest));
            CompletableFuture<DeleteGroupMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the DeleteIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIamPolicyAssignmentResponse> deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIamPolicyAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIamPolicyAssignmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIamPolicyAssignmentRequest, DeleteIamPolicyAssignmentResponse>()
                            .withOperationName("DeleteIAMPolicyAssignment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIamPolicyAssignmentRequest));
            CompletableFuture<DeleteIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all access scopes and authorized targets that are associated with a service from the Amazon QuickSight
     * IAM Identity Center application.
     * </p>
     * <p>
     * This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.
     * </p>
     *
     * @param deleteIdentityPropagationConfigRequest
     * @return A Java Future containing the result of the DeleteIdentityPropagationConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteIdentityPropagationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIdentityPropagationConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityPropagationConfigResponse> deleteIdentityPropagationConfig(
            DeleteIdentityPropagationConfigRequest deleteIdentityPropagationConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityPropagationConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteIdentityPropagationConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityPropagationConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityPropagationConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdentityPropagationConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteIdentityPropagationConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityPropagationConfigRequest, DeleteIdentityPropagationConfigResponse>()
                            .withOperationName("DeleteIdentityPropagationConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdentityPropagationConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdentityPropagationConfigRequest));
            CompletableFuture<DeleteIdentityPropagationConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                            .withOperationName("DeleteNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNamespaceRequest));
            CompletableFuture<DeleteNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a refresh schedule from a dataset.
     * </p>
     *
     * @param deleteRefreshScheduleRequest
     * @return A Java Future containing the result of the DeleteRefreshSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRefreshScheduleResponse> deleteRefreshSchedule(
            DeleteRefreshScheduleRequest deleteRefreshScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRefreshSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRefreshScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRefreshScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRefreshScheduleRequest, DeleteRefreshScheduleResponse>()
                            .withOperationName("DeleteRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRefreshScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRefreshScheduleRequest));
            CompletableFuture<DeleteRefreshScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes custom permissions from the role.
     * </p>
     *
     * @param deleteRoleCustomPermissionRequest
     * @return A Java Future containing the result of the DeleteRoleCustomPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteRoleCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRoleCustomPermissionResponse> deleteRoleCustomPermission(
            DeleteRoleCustomPermissionRequest deleteRoleCustomPermissionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleCustomPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoleCustomPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRoleCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRoleCustomPermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRoleCustomPermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleCustomPermissionRequest, DeleteRoleCustomPermissionResponse>()
                            .withOperationName("DeleteRoleCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRoleCustomPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRoleCustomPermissionRequest));
            CompletableFuture<DeleteRoleCustomPermissionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a group from a role.
     * </p>
     *
     * @param deleteRoleMembershipRequest
     * @return A Java Future containing the result of the DeleteRoleMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteRoleMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRoleMembershipResponse> deleteRoleMembership(
            DeleteRoleMembershipRequest deleteRoleMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoleMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRoleMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRoleMembershipResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRoleMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleMembershipRequest, DeleteRoleMembershipResponse>()
                            .withOperationName("DeleteRoleMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRoleMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRoleMembershipRequest));
            CompletableFuture<DeleteRoleMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTemplateResponse> deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTemplateRequest, DeleteTemplateResponse>()
                            .withOperationName("DeleteTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTemplateRequest));
            CompletableFuture<DeleteTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return A Java Future containing the result of the DeleteTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTemplateAliasResponse> deleteTemplateAlias(
            DeleteTemplateAliasRequest deleteTemplateAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTemplateAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTemplateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTemplateAliasRequest, DeleteTemplateAliasResponse>()
                            .withOperationName("DeleteTemplateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTemplateAliasRequest));
            CompletableFuture<DeleteTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     *
     * @param deleteThemeRequest
     * @return A Java Future containing the result of the DeleteTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThemeResponse> deleteTheme(DeleteThemeRequest deleteThemeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThemeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteThemeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThemeRequest, DeleteThemeResponse>()
                            .withOperationName("DeleteTheme").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteThemeRequest));
            CompletableFuture<DeleteThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     *
     * @param deleteThemeAliasRequest
     * @return A Java Future containing the result of the DeleteThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThemeAliasResponse> deleteThemeAlias(DeleteThemeAliasRequest deleteThemeAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThemeAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThemeAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThemeAliasRequest, DeleteThemeAliasResponse>()
                            .withOperationName("DeleteThemeAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteThemeAliasRequest));
            CompletableFuture<DeleteThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a topic.
     * </p>
     *
     * @param deleteTopicRequest
     * @return A Java Future containing the result of the DeleteTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTopicResponse> deleteTopic(DeleteTopicRequest deleteTopicRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTopicResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTopicResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTopicResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRequest, DeleteTopicResponse>()
                            .withOperationName("DeleteTopic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTopicRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTopicRequest));
            CompletableFuture<DeleteTopicResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a topic refresh schedule.
     * </p>
     *
     * @param deleteTopicRefreshScheduleRequest
     * @return A Java Future containing the result of the DeleteTopicRefreshSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTopicRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopicRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTopicRefreshScheduleResponse> deleteTopicRefreshSchedule(
            DeleteTopicRefreshScheduleRequest deleteTopicRefreshScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopicRefreshSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTopicRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTopicRefreshScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTopicRefreshScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRefreshScheduleRequest, DeleteTopicRefreshScheduleResponse>()
                            .withOperationName("DeleteTopicRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTopicRefreshScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTopicRefreshScheduleRequest));
            CompletableFuture<DeleteTopicRefreshScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the IAM user or role that's making the
     * call. The IAM user isn't deleted as a result of this call.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return A Java Future containing the result of the DeleteUserByPrincipalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUserByPrincipalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserByPrincipalIdResponse> deleteUserByPrincipalId(
            DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserByPrincipalIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserByPrincipalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserByPrincipalId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserByPrincipalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserByPrincipalIdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteUserByPrincipalIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserByPrincipalIdRequest, DeleteUserByPrincipalIdResponse>()
                            .withOperationName("DeleteUserByPrincipalId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserByPrincipalIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserByPrincipalIdRequest));
            CompletableFuture<DeleteUserByPrincipalIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom permissions profile from a user.
     * </p>
     *
     * @param deleteUserCustomPermissionRequest
     * @return A Java Future containing the result of the DeleteUserCustomPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUserCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserCustomPermissionResponse> deleteUserCustomPermission(
            DeleteUserCustomPermissionRequest deleteUserCustomPermissionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserCustomPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserCustomPermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserCustomPermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteUserCustomPermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserCustomPermissionRequest, DeleteUserCustomPermissionResponse>()
                            .withOperationName("DeleteUserCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserCustomPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserCustomPermissionRequest));
            CompletableFuture<DeleteUserCustomPermissionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a VPC connection.
     * </p>
     *
     * @param deleteVpcConnectionRequest
     * @return A Java Future containing the result of the DeleteVPCConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteVPCConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteVPCConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcConnectionResponse> deleteVPCConnection(
            DeleteVpcConnectionRequest deleteVpcConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVPCConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVpcConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteVpcConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcConnectionRequest, DeleteVpcConnectionResponse>()
                            .withOperationName("DeleteVPCConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVpcConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcConnectionRequest));
            CompletableFuture<DeleteVpcConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon
     * QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which
     * customizations to apply by running this API operation with the <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It
     * has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you
     * subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's
     * where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon
     * QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user
     * directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have
     * access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using
     * the CLI, you can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same
     * settings for your keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Within an Amazon Web Services Region, a set of Amazon QuickSight
     * customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a
     * namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a
     * single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the
     * <code>CreateAccountCustomization</code> command in each Amazon Web Services Region where you want to apply the
     * same customizations.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountCustomizationRequest
     * @return A Java Future containing the result of the DescribeAccountCustomization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountCustomizationResponse> describeAccountCustomization(
            DescribeAccountCustomizationRequest describeAccountCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountCustomizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountCustomizationRequest, DescribeAccountCustomizationResponse>()
                            .withOperationName("DescribeAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountCustomizationRequest));
            CompletableFuture<DescribeAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon
     * Web Services account.
     * </p>
     *
     * @param describeAccountSettingsRequest
     * @return A Java Future containing the result of the DescribeAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountSettingsResponse> describeAccountSettings(
            DescribeAccountSettingsRequest describeAccountSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAccountSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSettingsRequest, DescribeAccountSettingsResponse>()
                            .withOperationName("DescribeAccountSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountSettingsRequest));
            CompletableFuture<DescribeAccountSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account's
     * subscription. A successful API call returns an <code>AccountInfo</code> object that includes an account's name,
     * subscription status, authentication type, edition, and notification email address.
     * </p>
     *
     * @param describeAccountSubscriptionRequest
     * @return A Java Future containing the result of the DescribeAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountSubscriptionResponse> describeAccountSubscription(
            DescribeAccountSubscriptionRequest describeAccountSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSubscriptionRequest, DescribeAccountSubscriptionResponse>()
                            .withOperationName("DescribeAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountSubscriptionRequest));
            CompletableFuture<DescribeAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     *
     * @param describeAnalysisRequest
     * @return A Java Future containing the result of the DescribeAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAnalysisResponse> describeAnalysis(DescribeAnalysisRequest describeAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisRequest, DescribeAnalysisResponse>()
                            .withOperationName("DescribeAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAnalysisRequest));
            CompletableFuture<DescribeAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of an analysis.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of an Analysis, for instance if you are trying to check the
     * status of a recently created or updated Analysis, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html">
     * <code>DescribeAnalysis</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeAnalysisDefinitionRequest
     * @return A Java Future containing the result of the DescribeAnalysisDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAnalysisDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAnalysisDefinitionResponse> describeAnalysisDefinition(
            DescribeAnalysisDefinitionRequest describeAnalysisDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAnalysisDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAnalysisDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAnalysisDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisDefinitionRequest, DescribeAnalysisDefinitionResponse>()
                            .withOperationName("DescribeAnalysisDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAnalysisDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAnalysisDefinitionRequest));
            CompletableFuture<DescribeAnalysisDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     * @return A Java Future containing the result of the DescribeAnalysisPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAnalysisPermissionsResponse> describeAnalysisPermissions(
            DescribeAnalysisPermissionsRequest describeAnalysisPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAnalysisPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAnalysisPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisPermissionsRequest, DescribeAnalysisPermissionsResponse>()
                            .withOperationName("DescribeAnalysisPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAnalysisPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAnalysisPermissionsRequest));
            CompletableFuture<DescribeAnalysisPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing export job.
     * </p>
     * <p>
     * Poll job descriptions after a job starts to know the status of the job. When a job succeeds, a URL is provided to
     * download the exported assets' data from. Download URLs are valid for five minutes after they are generated. You
     * can call the <code>DescribeAssetBundleExportJob</code> API for a new download URL as needed.
     * </p>
     * <p>
     * Job descriptions are available for 14 days after the job starts.
     * </p>
     *
     * @param describeAssetBundleExportJobRequest
     * @return A Java Future containing the result of the DescribeAssetBundleExportJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAssetBundleExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssetBundleExportJobResponse> describeAssetBundleExportJob(
            DescribeAssetBundleExportJobRequest describeAssetBundleExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetBundleExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetBundleExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetBundleExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssetBundleExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssetBundleExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAssetBundleExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetBundleExportJobRequest, DescribeAssetBundleExportJobResponse>()
                            .withOperationName("DescribeAssetBundleExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAssetBundleExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAssetBundleExportJobRequest));
            CompletableFuture<DescribeAssetBundleExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing import job.
     * </p>
     * <p>
     * Poll job descriptions after starting a job to know when it has succeeded or failed. Job descriptions are
     * available for 14 days after job starts.
     * </p>
     *
     * @param describeAssetBundleImportJobRequest
     * @return A Java Future containing the result of the DescribeAssetBundleImportJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAssetBundleImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAssetBundleImportJobResponse> describeAssetBundleImportJob(
            DescribeAssetBundleImportJobRequest describeAssetBundleImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetBundleImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetBundleImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetBundleImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAssetBundleImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAssetBundleImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAssetBundleImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetBundleImportJobRequest, DescribeAssetBundleImportJobResponse>()
                            .withOperationName("DescribeAssetBundleImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAssetBundleImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAssetBundleImportJobRequest));
            CompletableFuture<DescribeAssetBundleImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a brand.
     * </p>
     *
     * @param describeBrandRequest
     * @return A Java Future containing the result of the DescribeBrand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBrandResponse> describeBrand(DescribeBrandRequest describeBrandRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeBrandResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeBrandResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBrandRequest, DescribeBrandResponse>()
                            .withOperationName("DescribeBrand").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBrandRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBrandRequest));
            CompletableFuture<DescribeBrandResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a brand assignment.
     * </p>
     *
     * @param describeBrandAssignmentRequest
     * @return A Java Future containing the result of the DescribeBrandAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeBrandAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrandAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBrandAssignmentResponse> describeBrandAssignment(
            DescribeBrandAssignmentRequest describeBrandAssignmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBrandAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrandAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBrandAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBrandAssignmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeBrandAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBrandAssignmentRequest, DescribeBrandAssignmentResponse>()
                            .withOperationName("DescribeBrandAssignment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBrandAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBrandAssignmentRequest));
            CompletableFuture<DescribeBrandAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the published version of the brand.
     * </p>
     *
     * @param describeBrandPublishedVersionRequest
     * @return A Java Future containing the result of the DescribeBrandPublishedVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InternalServerException An internal service exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeBrandPublishedVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrandPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBrandPublishedVersionResponse> describeBrandPublishedVersion(
            DescribeBrandPublishedVersionRequest describeBrandPublishedVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandPublishedVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeBrandPublishedVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrandPublishedVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBrandPublishedVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBrandPublishedVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeBrandPublishedVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBrandPublishedVersionRequest, DescribeBrandPublishedVersionResponse>()
                            .withOperationName("DescribeBrandPublishedVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBrandPublishedVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBrandPublishedVersionRequest));
            CompletableFuture<DescribeBrandPublishedVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a custom permissions profile.
     * </p>
     *
     * @param describeCustomPermissionsRequest
     * @return A Java Future containing the result of the DescribeCustomPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomPermissionsResponse> describeCustomPermissions(
            DescribeCustomPermissionsRequest describeCustomPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCustomPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCustomPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomPermissionsRequest, DescribeCustomPermissionsResponse>()
                            .withOperationName("DescribeCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomPermissionsRequest));
            CompletableFuture<DescribeCustomPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardResponse> describeDashboard(DescribeDashboardRequest describeDashboardRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                            .withOperationName("DescribeDashboard").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardRequest));
            CompletableFuture<DescribeDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of a dashboard.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of a dashboard, for instance if you are trying to check the
     * status of a recently created or updated dashboard, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html">
     * <code>DescribeDashboard</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeDashboardDefinitionRequest
     * @return A Java Future containing the result of the DescribeDashboardDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardDefinitionResponse> describeDashboardDefinition(
            DescribeDashboardDefinitionRequest describeDashboardDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardDefinitionRequest, DescribeDashboardDefinitionResponse>()
                            .withOperationName("DescribeDashboardDefinition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardDefinitionRequest));
            CompletableFuture<DescribeDashboardDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return A Java Future containing the result of the DescribeDashboardPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardPermissionsResponse> describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardPermissionsRequest, DescribeDashboardPermissionsResponse>()
                            .withOperationName("DescribeDashboardPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardPermissionsRequest));
            CompletableFuture<DescribeDashboardPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing snapshot job.
     * </p>
     * <p>
     * Poll job descriptions after a job starts to know the status of the job. For information on available status
     * codes, see <code>JobStatus</code>.
     * </p>
     *
     * @param describeDashboardSnapshotJobRequest
     * @return A Java Future containing the result of the DescribeDashboardSnapshotJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardSnapshotJobResponse> describeDashboardSnapshotJob(
            DescribeDashboardSnapshotJobRequest describeDashboardSnapshotJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardSnapshotJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardSnapshotJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardSnapshotJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardSnapshotJobRequest, DescribeDashboardSnapshotJobResponse>()
                            .withOperationName("DescribeDashboardSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardSnapshotJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardSnapshotJobRequest));
            CompletableFuture<DescribeDashboardSnapshotJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the result of an existing snapshot job that has finished running.
     * </p>
     * <p>
     * A finished snapshot job will return a <code>COMPLETED</code> or <code>FAILED</code> status when you poll the job
     * with a <code>DescribeDashboardSnapshotJob</code> API call.
     * </p>
     * <p>
     * If the job has not finished running, this operation returns a message that says
     * <code>Dashboard Snapshot Job with id &lt;SnapshotjobId&gt; has not reached a terminal state.</code>.
     * </p>
     *
     * @param describeDashboardSnapshotJobResultRequest
     * @return A Java Future containing the result of the DescribeDashboardSnapshotJobResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardSnapshotJobResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJobResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardSnapshotJobResultResponse> describeDashboardSnapshotJobResult(
            DescribeDashboardSnapshotJobResultRequest describeDashboardSnapshotJobResultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardSnapshotJobResultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDashboardSnapshotJobResultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardSnapshotJobResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardSnapshotJobResultResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDashboardSnapshotJobResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardSnapshotJobResultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardSnapshotJobResultRequest, DescribeDashboardSnapshotJobResultResponse>()
                            .withOperationName("DescribeDashboardSnapshotJobResult").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardSnapshotJobResultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardSnapshotJobResultRequest));
            CompletableFuture<DescribeDashboardSnapshotJobResultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing dashboard QA configuration.
     * </p>
     *
     * @param describeDashboardsQaConfigurationRequest
     * @return A Java Future containing the result of the DescribeDashboardsQAConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardsQAConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardsQAConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardsQaConfigurationResponse> describeDashboardsQAConfiguration(
            DescribeDashboardsQaConfigurationRequest describeDashboardsQaConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardsQaConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDashboardsQaConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardsQAConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardsQaConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDashboardsQaConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDashboardsQaConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardsQaConfigurationRequest, DescribeDashboardsQaConfigurationResponse>()
                            .withOperationName("DescribeDashboardsQAConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDashboardsQaConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDashboardsQaConfigurationRequest));
            CompletableFuture<DescribeDashboardsQaConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param describeDataSetRequest
     * @return A Java Future containing the result of the DescribeDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSetResponse> describeDataSet(DescribeDataSetRequest describeDataSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetRequest, DescribeDataSetResponse>()
                            .withOperationName("DescribeDataSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSetRequest));
            CompletableFuture<DescribeDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSetPermissionsResponse> describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSetPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataSetPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetPermissionsRequest, DescribeDataSetPermissionsResponse>()
                            .withOperationName("DescribeDataSetPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSetPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSetPermissionsRequest));
            CompletableFuture<DescribeDataSetPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the refresh properties of a dataset.
     * </p>
     *
     * @param describeDataSetRefreshPropertiesRequest
     * @return A Java Future containing the result of the DescribeDataSetRefreshProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSetRefreshProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSetRefreshPropertiesResponse> describeDataSetRefreshProperties(
            DescribeDataSetRefreshPropertiesRequest describeDataSetRefreshPropertiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetRefreshPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSetRefreshPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetRefreshProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSetRefreshPropertiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDataSetRefreshPropertiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataSetRefreshPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetRefreshPropertiesRequest, DescribeDataSetRefreshPropertiesResponse>()
                            .withOperationName("DescribeDataSetRefreshProperties").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSetRefreshPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSetRefreshPropertiesRequest));
            CompletableFuture<DescribeDataSetRefreshPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSourceResponse> describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourceRequest, DescribeDataSourceResponse>()
                            .withOperationName("DescribeDataSource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSourceRequest));
            CompletableFuture<DescribeDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSourcePermissionsResponse> describeDataSourcePermissions(
            DescribeDataSourcePermissionsRequest describeDataSourcePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSourcePermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSourcePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSourcePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSourcePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "IdentityTypeNotSupportedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                            .httpStatusCode(403).exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
                case "PreconditionNotMetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "ResourceExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ResourceExistsException::builder).build());
                case "ConcurrentUpdatingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
                case "InternalFailureException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalFailureException::builder).build());
                case "DomainNotWhitelistedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
                case "CustomerManagedKeyUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder)
                            .build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnsupportedPricingPlanException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
                case "UnsupportedUserEditionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                            .httpStatusCode(403).exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataSourcePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourcePermissionsRequest, DescribeDataSourcePermissionsResponse>()
                            .withOperationName("DescribeDataSourcePermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSourcePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSourcePermissionsRequest));
            CompletableFuture<DescribeDataSourcePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a Amazon Q Business application that is linked to an Amazon QuickSight account.
     * </p>
     *
     * @param describeDefaultQBusinessApplicationRequest
     * @return A Java Future containing the result of the DescribeDefaultQBusinessApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct credentials.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDefaultQBusinessApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDefaultQBusinessApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDefaultQBusinessApplicationResponse> describeDefaultQBusinessApplication(
            DescribeDefaultQBusinessApplicationRequest describeDefaultQBusinessApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDefaultQBusinessApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDefaultQBusinessApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDefaultQBusinessApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDefaultQBusinessApplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDefaultQBusinessApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "QuickSightUserNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                            .httpStatusCode(404).exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
                case "SessionLifetimeInMinutesInvalidException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUna