/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of Amazon Q feature configurations in an embedded Amazon QuickSight console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonQInQuickSightConsoleConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonQInQuickSightConsoleConfigurations.Builder, AmazonQInQuickSightConsoleConfigurations> {
    private static final SdkField<DataQnAConfigurations> DATA_QNA_FIELD = SdkField
            .<DataQnAConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataQnA")
            .getter(getter(AmazonQInQuickSightConsoleConfigurations::dataQnA)).setter(setter(Builder::dataQnA))
            .constructor(DataQnAConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQnA").build()).build();

    private static final SdkField<GenerativeAuthoringConfigurations> GENERATIVE_AUTHORING_FIELD = SdkField
            .<GenerativeAuthoringConfigurations> builder(MarshallingType.SDK_POJO).memberName("GenerativeAuthoring")
            .getter(getter(AmazonQInQuickSightConsoleConfigurations::generativeAuthoring))
            .setter(setter(Builder::generativeAuthoring)).constructor(GenerativeAuthoringConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerativeAuthoring").build())
            .build();

    private static final SdkField<ExecutiveSummaryConfigurations> EXECUTIVE_SUMMARY_FIELD = SdkField
            .<ExecutiveSummaryConfigurations> builder(MarshallingType.SDK_POJO).memberName("ExecutiveSummary")
            .getter(getter(AmazonQInQuickSightConsoleConfigurations::executiveSummary)).setter(setter(Builder::executiveSummary))
            .constructor(ExecutiveSummaryConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutiveSummary").build()).build();

    private static final SdkField<DataStoriesConfigurations> DATA_STORIES_FIELD = SdkField
            .<DataStoriesConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataStories")
            .getter(getter(AmazonQInQuickSightConsoleConfigurations::dataStories)).setter(setter(Builder::dataStories))
            .constructor(DataStoriesConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStories").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QNA_FIELD,
            GENERATIVE_AUTHORING_FIELD, EXECUTIVE_SUMMARY_FIELD, DATA_STORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataQnAConfigurations dataQnA;

    private final GenerativeAuthoringConfigurations generativeAuthoring;

    private final ExecutiveSummaryConfigurations executiveSummary;

    private final DataStoriesConfigurations dataStories;

    private AmazonQInQuickSightConsoleConfigurations(BuilderImpl builder) {
        this.dataQnA = builder.dataQnA;
        this.generativeAuthoring = builder.generativeAuthoring;
        this.executiveSummary = builder.executiveSummary;
        this.dataStories = builder.dataStories;
    }

    /**
     * <p>
     * Adds generative Q&amp;A capabilitiees to an embedded Amazon QuickSight console.
     * </p>
     * 
     * @return Adds generative Q&amp;A capabilitiees to an embedded Amazon QuickSight console.
     */
    public final DataQnAConfigurations dataQnA() {
        return dataQnA;
    }

    /**
     * <p>
     * Adds the generative BI authoring experience to an embedded Amazon QuickSight console.
     * </p>
     * 
     * @return Adds the generative BI authoring experience to an embedded Amazon QuickSight console.
     */
    public final GenerativeAuthoringConfigurations generativeAuthoring() {
        return generativeAuthoring;
    }

    /**
     * <p>
     * Adds the executive summaries feature to an embedded Amazon QuickSight console.
     * </p>
     * 
     * @return Adds the executive summaries feature to an embedded Amazon QuickSight console.
     */
    public final ExecutiveSummaryConfigurations executiveSummary() {
        return executiveSummary;
    }

    /**
     * <p>
     * Adds the data stories feature to an embedded Amazon QuickSight console.
     * </p>
     * 
     * @return Adds the data stories feature to an embedded Amazon QuickSight console.
     */
    public final DataStoriesConfigurations dataStories() {
        return dataStories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataQnA());
        hashCode = 31 * hashCode + Objects.hashCode(generativeAuthoring());
        hashCode = 31 * hashCode + Objects.hashCode(executiveSummary());
        hashCode = 31 * hashCode + Objects.hashCode(dataStories());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonQInQuickSightConsoleConfigurations)) {
            return false;
        }
        AmazonQInQuickSightConsoleConfigurations other = (AmazonQInQuickSightConsoleConfigurations) obj;
        return Objects.equals(dataQnA(), other.dataQnA()) && Objects.equals(generativeAuthoring(), other.generativeAuthoring())
                && Objects.equals(executiveSummary(), other.executiveSummary())
                && Objects.equals(dataStories(), other.dataStories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonQInQuickSightConsoleConfigurations").add("DataQnA", dataQnA())
                .add("GenerativeAuthoring", generativeAuthoring()).add("ExecutiveSummary", executiveSummary())
                .add("DataStories", dataStories()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataQnA":
            return Optional.ofNullable(clazz.cast(dataQnA()));
        case "GenerativeAuthoring":
            return Optional.ofNullable(clazz.cast(generativeAuthoring()));
        case "ExecutiveSummary":
            return Optional.ofNullable(clazz.cast(executiveSummary()));
        case "DataStories":
            return Optional.ofNullable(clazz.cast(dataStories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataQnA", DATA_QNA_FIELD);
        map.put("GenerativeAuthoring", GENERATIVE_AUTHORING_FIELD);
        map.put("ExecutiveSummary", EXECUTIVE_SUMMARY_FIELD);
        map.put("DataStories", DATA_STORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonQInQuickSightConsoleConfigurations, T> g) {
        return obj -> g.apply((AmazonQInQuickSightConsoleConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonQInQuickSightConsoleConfigurations> {
        /**
         * <p>
         * Adds generative Q&amp;A capabilitiees to an embedded Amazon QuickSight console.
         * </p>
         * 
         * @param dataQnA
         *        Adds generative Q&amp;A capabilitiees to an embedded Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQnA(DataQnAConfigurations dataQnA);

        /**
         * <p>
         * Adds generative Q&amp;A capabilitiees to an embedded Amazon QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQnAConfigurations.Builder} avoiding
         * the need to create one manually via {@link DataQnAConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQnAConfigurations.Builder#build()} is called immediately and
         * its result is passed to {@link #dataQnA(DataQnAConfigurations)}.
         * 
         * @param dataQnA
         *        a consumer that will call methods on {@link DataQnAConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQnA(DataQnAConfigurations)
         */
        default Builder dataQnA(Consumer<DataQnAConfigurations.Builder> dataQnA) {
            return dataQnA(DataQnAConfigurations.builder().applyMutation(dataQnA).build());
        }

        /**
         * <p>
         * Adds the generative BI authoring experience to an embedded Amazon QuickSight console.
         * </p>
         * 
         * @param generativeAuthoring
         *        Adds the generative BI authoring experience to an embedded Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeAuthoring(GenerativeAuthoringConfigurations generativeAuthoring);

        /**
         * <p>
         * Adds the generative BI authoring experience to an embedded Amazon QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GenerativeAuthoringConfigurations.Builder} avoiding the need to create one manually via
         * {@link GenerativeAuthoringConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeAuthoringConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #generativeAuthoring(GenerativeAuthoringConfigurations)}.
         * 
         * @param generativeAuthoring
         *        a consumer that will call methods on {@link GenerativeAuthoringConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeAuthoring(GenerativeAuthoringConfigurations)
         */
        default Builder generativeAuthoring(Consumer<GenerativeAuthoringConfigurations.Builder> generativeAuthoring) {
            return generativeAuthoring(GenerativeAuthoringConfigurations.builder().applyMutation(generativeAuthoring).build());
        }

        /**
         * <p>
         * Adds the executive summaries feature to an embedded Amazon QuickSight console.
         * </p>
         * 
         * @param executiveSummary
         *        Adds the executive summaries feature to an embedded Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executiveSummary(ExecutiveSummaryConfigurations executiveSummary);

        /**
         * <p>
         * Adds the executive summaries feature to an embedded Amazon QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutiveSummaryConfigurations.Builder}
         * avoiding the need to create one manually via {@link ExecutiveSummaryConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutiveSummaryConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #executiveSummary(ExecutiveSummaryConfigurations)}.
         * 
         * @param executiveSummary
         *        a consumer that will call methods on {@link ExecutiveSummaryConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executiveSummary(ExecutiveSummaryConfigurations)
         */
        default Builder executiveSummary(Consumer<ExecutiveSummaryConfigurations.Builder> executiveSummary) {
            return executiveSummary(ExecutiveSummaryConfigurations.builder().applyMutation(executiveSummary).build());
        }

        /**
         * <p>
         * Adds the data stories feature to an embedded Amazon QuickSight console.
         * </p>
         * 
         * @param dataStories
         *        Adds the data stories feature to an embedded Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStories(DataStoriesConfigurations dataStories);

        /**
         * <p>
         * Adds the data stories feature to an embedded Amazon QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataStoriesConfigurations.Builder}
         * avoiding the need to create one manually via {@link DataStoriesConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataStoriesConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #dataStories(DataStoriesConfigurations)}.
         * 
         * @param dataStories
         *        a consumer that will call methods on {@link DataStoriesConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStories(DataStoriesConfigurations)
         */
        default Builder dataStories(Consumer<DataStoriesConfigurations.Builder> dataStories) {
            return dataStories(DataStoriesConfigurations.builder().applyMutation(dataStories).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataQnAConfigurations dataQnA;

        private GenerativeAuthoringConfigurations generativeAuthoring;

        private ExecutiveSummaryConfigurations executiveSummary;

        private DataStoriesConfigurations dataStories;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonQInQuickSightConsoleConfigurations model) {
            dataQnA(model.dataQnA);
            generativeAuthoring(model.generativeAuthoring);
            executiveSummary(model.executiveSummary);
            dataStories(model.dataStories);
        }

        public final DataQnAConfigurations.Builder getDataQnA() {
            return dataQnA != null ? dataQnA.toBuilder() : null;
        }

        public final void setDataQnA(DataQnAConfigurations.BuilderImpl dataQnA) {
            this.dataQnA = dataQnA != null ? dataQnA.build() : null;
        }

        @Override
        public final Builder dataQnA(DataQnAConfigurations dataQnA) {
            this.dataQnA = dataQnA;
            return this;
        }

        public final GenerativeAuthoringConfigurations.Builder getGenerativeAuthoring() {
            return generativeAuthoring != null ? generativeAuthoring.toBuilder() : null;
        }

        public final void setGenerativeAuthoring(GenerativeAuthoringConfigurations.BuilderImpl generativeAuthoring) {
            this.generativeAuthoring = generativeAuthoring != null ? generativeAuthoring.build() : null;
        }

        @Override
        public final Builder generativeAuthoring(GenerativeAuthoringConfigurations generativeAuthoring) {
            this.generativeAuthoring = generativeAuthoring;
            return this;
        }

        public final ExecutiveSummaryConfigurations.Builder getExecutiveSummary() {
            return executiveSummary != null ? executiveSummary.toBuilder() : null;
        }

        public final void setExecutiveSummary(ExecutiveSummaryConfigurations.BuilderImpl executiveSummary) {
            this.executiveSummary = executiveSummary != null ? executiveSummary.build() : null;
        }

        @Override
        public final Builder executiveSummary(ExecutiveSummaryConfigurations executiveSummary) {
            this.executiveSummary = executiveSummary;
            return this;
        }

        public final DataStoriesConfigurations.Builder getDataStories() {
            return dataStories != null ? dataStories.toBuilder() : null;
        }

        public final void setDataStories(DataStoriesConfigurations.BuilderImpl dataStories) {
            this.dataStories = dataStories != null ? dataStories.build() : null;
        }

        @Override
        public final Builder dataStories(DataStoriesConfigurations dataStories) {
            this.dataStories = dataStories;
            return this;
        }

        @Override
        public AmazonQInQuickSightConsoleConfigurations build() {
            return new AmazonQInQuickSightConsoleConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
