/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a list of permissions to be applied to a list of dashboard IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobDashboardOverridePermissions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleImportJobDashboardOverridePermissions.Builder, AssetBundleImportJobDashboardOverridePermissions> {
    private static final SdkField<List<String>> DASHBOARD_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DashboardIds")
            .getter(getter(AssetBundleImportJobDashboardOverridePermissions::dashboardIds))
            .setter(setter(Builder::dashboardIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField
            .<AssetBundleResourcePermissions> builder(MarshallingType.SDK_POJO).memberName("Permissions")
            .getter(getter(AssetBundleImportJobDashboardOverridePermissions::permissions)).setter(setter(Builder::permissions))
            .constructor(AssetBundleResourcePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()).build();

    private static final SdkField<AssetBundleResourceLinkSharingConfiguration> LINK_SHARING_CONFIGURATION_FIELD = SdkField
            .<AssetBundleResourceLinkSharingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LinkSharingConfiguration")
            .getter(getter(AssetBundleImportJobDashboardOverridePermissions::linkSharingConfiguration))
            .setter(setter(Builder::linkSharingConfiguration)).constructor(AssetBundleResourceLinkSharingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSharingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_IDS_FIELD,
            PERMISSIONS_FIELD, LINK_SHARING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> dashboardIds;

    private final AssetBundleResourcePermissions permissions;

    private final AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration;

    private AssetBundleImportJobDashboardOverridePermissions(BuilderImpl builder) {
        this.dashboardIds = builder.dashboardIds;
        this.permissions = builder.permissions;
        this.linkSharingConfiguration = builder.linkSharingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DashboardIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDashboardIds() {
        return dashboardIds != null && !(dashboardIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all
     * dashboards in this asset bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboardIds} method.
     * </p>
     * 
     * @return A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all
     *         dashboards in this asset bundle.
     */
    public final List<String> dashboardIds() {
        return dashboardIds;
    }

    /**
     * <p>
     * A list of permissions for the dashboards that you want to apply overrides to.
     * </p>
     * 
     * @return A list of permissions for the dashboards that you want to apply overrides to.
     */
    public final AssetBundleResourcePermissions permissions() {
        return permissions;
    }

    /**
     * <p>
     * A structure that contains the link sharing configurations that you want to apply overrides to.
     * </p>
     * 
     * @return A structure that contains the link sharing configurations that you want to apply overrides to.
     */
    public final AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration() {
        return linkSharingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboardIds() ? dashboardIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(linkSharingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDashboardOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobDashboardOverridePermissions other = (AssetBundleImportJobDashboardOverridePermissions) obj;
        return hasDashboardIds() == other.hasDashboardIds() && Objects.equals(dashboardIds(), other.dashboardIds())
                && Objects.equals(permissions(), other.permissions())
                && Objects.equals(linkSharingConfiguration(), other.linkSharingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobDashboardOverridePermissions")
                .add("DashboardIds", hasDashboardIds() ? dashboardIds() : null).add("Permissions", permissions())
                .add("LinkSharingConfiguration", linkSharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardIds":
            return Optional.ofNullable(clazz.cast(dashboardIds()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "LinkSharingConfiguration":
            return Optional.ofNullable(clazz.cast(linkSharingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardIds", DASHBOARD_IDS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("LinkSharingConfiguration", LINK_SHARING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDashboardOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobDashboardOverridePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobDashboardOverridePermissions> {
        /**
         * <p>
         * A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all
         * dashboards in this asset bundle.
         * </p>
         * 
         * @param dashboardIds
         *        A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override
         *        all dashboards in this asset bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardIds(Collection<String> dashboardIds);

        /**
         * <p>
         * A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override all
         * dashboards in this asset bundle.
         * </p>
         * 
         * @param dashboardIds
         *        A list of dashboard IDs that you want to apply overrides to. You can use <code>*</code> to override
         *        all dashboards in this asset bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardIds(String... dashboardIds);

        /**
         * <p>
         * A list of permissions for the dashboards that you want to apply overrides to.
         * </p>
         * 
         * @param permissions
         *        A list of permissions for the dashboards that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(AssetBundleResourcePermissions permissions);

        /**
         * <p>
         * A list of permissions for the dashboards that you want to apply overrides to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetBundleResourcePermissions.Builder}
         * avoiding the need to create one manually via {@link AssetBundleResourcePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleResourcePermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(AssetBundleResourcePermissions)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link AssetBundleResourcePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(AssetBundleResourcePermissions)
         */
        default Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return permissions(AssetBundleResourcePermissions.builder().applyMutation(permissions).build());
        }

        /**
         * <p>
         * A structure that contains the link sharing configurations that you want to apply overrides to.
         * </p>
         * 
         * @param linkSharingConfiguration
         *        A structure that contains the link sharing configurations that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration);

        /**
         * <p>
         * A structure that contains the link sharing configurations that you want to apply overrides to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleResourceLinkSharingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AssetBundleResourceLinkSharingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleResourceLinkSharingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration)}.
         * 
         * @param linkSharingConfiguration
         *        a consumer that will call methods on {@link AssetBundleResourceLinkSharingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration)
         */
        default Builder linkSharingConfiguration(
                Consumer<AssetBundleResourceLinkSharingConfiguration.Builder> linkSharingConfiguration) {
            return linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration.builder()
                    .applyMutation(linkSharingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> dashboardIds = DefaultSdkAutoConstructList.getInstance();

        private AssetBundleResourcePermissions permissions;

        private AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDashboardOverridePermissions model) {
            dashboardIds(model.dashboardIds);
            permissions(model.permissions);
            linkSharingConfiguration(model.linkSharingConfiguration);
        }

        public final Collection<String> getDashboardIds() {
            if (dashboardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return dashboardIds;
        }

        public final void setDashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
        }

        @Override
        public final Builder dashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardIds(String... dashboardIds) {
            dashboardIds(Arrays.asList(dashboardIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final AssetBundleResourceLinkSharingConfiguration.Builder getLinkSharingConfiguration() {
            return linkSharingConfiguration != null ? linkSharingConfiguration.toBuilder() : null;
        }

        public final void setLinkSharingConfiguration(
                AssetBundleResourceLinkSharingConfiguration.BuilderImpl linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration != null ? linkSharingConfiguration.build() : null;
        }

        @Override
        public final Builder linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        @Override
        public AssetBundleImportJobDashboardOverridePermissions build() {
            return new AssetBundleImportJobDashboardOverridePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
