/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of content in a body section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BodySectionContent implements SdkPojo, Serializable,
        ToCopyableBuilder<BodySectionContent.Builder, BodySectionContent> {
    private static final SdkField<SectionLayoutConfiguration> LAYOUT_FIELD = SdkField
            .<SectionLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("Layout")
            .getter(getter(BodySectionContent::layout)).setter(setter(Builder::layout))
            .constructor(SectionLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SectionLayoutConfiguration layout;

    private BodySectionContent(BuilderImpl builder) {
        this.layout = builder.layout;
    }

    /**
     * <p>
     * The layout configuration of a body section.
     * </p>
     * 
     * @return The layout configuration of a body section.
     */
    public final SectionLayoutConfiguration layout() {
        return layout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionContent)) {
            return false;
        }
        BodySectionContent other = (BodySectionContent) obj;
        return Objects.equals(layout(), other.layout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BodySectionContent").add("Layout", layout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Layout":
            return Optional.ofNullable(clazz.cast(layout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Layout", LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BodySectionContent, T> g) {
        return obj -> g.apply((BodySectionContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BodySectionContent> {
        /**
         * <p>
         * The layout configuration of a body section.
         * </p>
         * 
         * @param layout
         *        The layout configuration of a body section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layout(SectionLayoutConfiguration layout);

        /**
         * <p>
         * The layout configuration of a body section.
         * </p>
         * This is a convenience method that creates an instance of the {@link SectionLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link SectionLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionLayoutConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #layout(SectionLayoutConfiguration)}.
         * 
         * @param layout
         *        a consumer that will call methods on {@link SectionLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layout(SectionLayoutConfiguration)
         */
        default Builder layout(Consumer<SectionLayoutConfiguration.Builder> layout) {
            return layout(SectionLayoutConfiguration.builder().applyMutation(layout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SectionLayoutConfiguration layout;

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionContent model) {
            layout(model.layout);
        }

        public final SectionLayoutConfiguration.Builder getLayout() {
            return layout != null ? layout.toBuilder() : null;
        }

        public final void setLayout(SectionLayoutConfiguration.BuilderImpl layout) {
            this.layout = layout != null ? layout.build() : null;
        }

        @Override
        public final Builder layout(SectionLayoutConfiguration layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public BodySectionContent build() {
            return new BodySectionContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
