/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the brand.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrandSummary implements SdkPojo, Serializable, ToCopyableBuilder<BrandSummary.Builder, BrandSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(BrandSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> BRAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandId").getter(getter(BrandSummary::brandId)).setter(setter(Builder::brandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandId").build()).build();

    private static final SdkField<String> BRAND_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandName").getter(getter(BrandSummary::brandName)).setter(setter(Builder::brandName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(BrandSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BRAND_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandStatus").getter(getter(BrandSummary::brandStatusAsString)).setter(setter(Builder::brandStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(BrandSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(BrandSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BRAND_ID_FIELD,
            BRAND_NAME_FIELD, DESCRIPTION_FIELD, BRAND_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String brandId;

    private final String brandName;

    private final String description;

    private final String brandStatus;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private BrandSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.brandId = builder.brandId;
        this.brandName = builder.brandName;
        this.description = builder.description;
        this.brandStatus = builder.brandStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the brand.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the brand.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the Amazon QuickSight brand.
     * </p>
     * 
     * @return The ID of the Amazon QuickSight brand.
     */
    public final String brandId() {
        return brandId;
    }

    /**
     * <p>
     * The name of the brand.
     * </p>
     * 
     * @return The name of the brand.
     */
    public final String brandName() {
        return brandName;
    }

    /**
     * <p>
     * The description of the brand.
     * </p>
     * 
     * @return The description of the brand.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the brand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brandStatus} will
     * return {@link BrandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandStatusAsString}.
     * </p>
     * 
     * @return The status of the brand.
     * @see BrandStatus
     */
    public final BrandStatus brandStatus() {
        return BrandStatus.fromValue(brandStatus);
    }

    /**
     * <p>
     * The status of the brand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brandStatus} will
     * return {@link BrandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandStatusAsString}.
     * </p>
     * 
     * @return The status of the brand.
     * @see BrandStatus
     */
    public final String brandStatusAsString() {
        return brandStatus;
    }

    /**
     * <p>
     * The time that the brand was created.
     * </p>
     * 
     * @return The time that the brand was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time when the brand was last updated.
     * </p>
     * 
     * @return The time when the brand was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(brandId());
        hashCode = 31 * hashCode + Objects.hashCode(brandName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(brandStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandSummary)) {
            return false;
        }
        BrandSummary other = (BrandSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(brandId(), other.brandId())
                && Objects.equals(brandName(), other.brandName()) && Objects.equals(description(), other.description())
                && Objects.equals(brandStatusAsString(), other.brandStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrandSummary").add("Arn", arn()).add("BrandId", brandId()).add("BrandName", brandName())
                .add("Description", description()).add("BrandStatus", brandStatusAsString()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "BrandId":
            return Optional.ofNullable(clazz.cast(brandId()));
        case "BrandName":
            return Optional.ofNullable(clazz.cast(brandName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BrandStatus":
            return Optional.ofNullable(clazz.cast(brandStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("BrandName", BRAND_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BrandStatus", BRAND_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandSummary, T> g) {
        return obj -> g.apply((BrandSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrandSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the brand.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the Amazon QuickSight brand.
         * </p>
         * 
         * @param brandId
         *        The ID of the Amazon QuickSight brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandId(String brandId);

        /**
         * <p>
         * The name of the brand.
         * </p>
         * 
         * @param brandName
         *        The name of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandName(String brandName);

        /**
         * <p>
         * The description of the brand.
         * </p>
         * 
         * @param description
         *        The description of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the brand.
         * </p>
         * 
         * @param brandStatus
         *        The status of the brand.
         * @see BrandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandStatus
         */
        Builder brandStatus(String brandStatus);

        /**
         * <p>
         * The status of the brand.
         * </p>
         * 
         * @param brandStatus
         *        The status of the brand.
         * @see BrandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandStatus
         */
        Builder brandStatus(BrandStatus brandStatus);

        /**
         * <p>
         * The time that the brand was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the brand was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time when the brand was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the brand was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String brandId;

        private String brandName;

        private String description;

        private String brandStatus;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandSummary model) {
            arn(model.arn);
            brandId(model.brandId);
            brandName(model.brandName);
            description(model.description);
            brandStatus(model.brandStatus);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrandId() {
            return brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final String getBrandName() {
            return brandName;
        }

        public final void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        @Override
        public final Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBrandStatus() {
            return brandStatus;
        }

        public final void setBrandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
        }

        @Override
        public final Builder brandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
            return this;
        }

        @Override
        public final Builder brandStatus(BrandStatus brandStatus) {
            this.brandStatus(brandStatus == null ? null : brandStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public BrandSummary build() {
            return new BrandSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
