/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIamPolicyAssignmentResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateIamPolicyAssignmentResponse.Builder, CreateIamPolicyAssignmentResponse> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentName").getter(getter(CreateIamPolicyAssignmentResponse::assignmentName))
            .setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()).build();

    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentId").getter(getter(CreateIamPolicyAssignmentResponse::assignmentId))
            .setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(CreateIamPolicyAssignmentResponse::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(CreateIamPolicyAssignmentResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Identities")
            .getter(getter(CreateIamPolicyAssignmentResponse::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateIamPolicyAssignmentResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateIamPolicyAssignmentResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD,
            ASSIGNMENT_ID_FIELD, ASSIGNMENT_STATUS_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assignmentName;

    private final String assignmentId;

    private final String assignmentStatus;

    private final String policyArn;

    private final Map<String, List<String>> identities;

    private final String requestId;

    private final Integer status;

    private CreateIamPolicyAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.assignmentName = builder.assignmentName;
        this.assignmentId = builder.assignmentId;
        this.assignmentStatus = builder.assignmentStatus;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the assignment. The name must be unique within the Amazon Web Services account.
     * </p>
     * 
     * @return The name of the assignment. The name must be unique within the Amazon Web Services account.
     */
    public final String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * The ID for the assignment.
     * </p>
     * 
     * @return The ID for the assignment.
     */
    public final String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public final String assignmentStatusAsString() {
        return assignmentStatus;
    }

    /**
     * <p>
     * The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this
     * assignment.
     * </p>
     * 
     * @return The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this
     *         assignment.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentities() {
        return identities != null && !(identities instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentities} method.
     * </p>
     * 
     * @return The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
     */
    public final Map<String, List<String>> identities() {
        return identities;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentities() ? identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIamPolicyAssignmentResponse)) {
            return false;
        }
        CreateIamPolicyAssignmentResponse other = (CreateIamPolicyAssignmentResponse) obj;
        return Objects.equals(assignmentName(), other.assignmentName()) && Objects.equals(assignmentId(), other.assignmentId())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString())
                && Objects.equals(policyArn(), other.policyArn()) && hasIdentities() == other.hasIdentities()
                && Objects.equals(identities(), other.identities()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIamPolicyAssignmentResponse").add("AssignmentName", assignmentName())
                .add("AssignmentId", assignmentId()).add("AssignmentStatus", assignmentStatusAsString())
                .add("PolicyArn", policyArn()).add("Identities", hasIdentities() ? identities() : null)
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssignmentName", ASSIGNMENT_NAME_FIELD);
        map.put("AssignmentId", ASSIGNMENT_ID_FIELD);
        map.put("AssignmentStatus", ASSIGNMENT_STATUS_FIELD);
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("Identities", IDENTITIES_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIamPolicyAssignmentResponse, T> g) {
        return obj -> g.apply((CreateIamPolicyAssignmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIamPolicyAssignmentResponse> {
        /**
         * <p>
         * The name of the assignment. The name must be unique within the Amazon Web Services account.
         * </p>
         * 
         * @param assignmentName
         *        The name of the assignment. The name must be unique within the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * The ID for the assignment.
         * </p>
         * 
         * @param assignmentId
         *        The ID for the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);

        /**
         * <p>
         * The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this
         * assignment.
         * </p>
         * 
         * @param policyArn
         *        The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this
         *        assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
         * </p>
         * 
         * @param identities
         *        The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Map<String, ? extends Collection<String>> identities);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String assignmentName;

        private String assignmentId;

        private String assignmentStatus;

        private String policyArn;

        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIamPolicyAssignmentResponse model) {
            super(model);
            assignmentName(model.assignmentName);
            assignmentId(model.assignmentId);
            assignmentStatus(model.assignmentStatus);
            policyArn(model.policyArn);
            identities(model.identities);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateIamPolicyAssignmentResponse build() {
            return new CreateIamPolicyAssignmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
