/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the following elements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The <code>DashboardId</code> of the dashboard that has the visual that you want to embed.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <code>SheetId</code> of the sheet that has the visual that you want to embed.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <code>VisualId</code> of the visual that you want to embed.
 * </p>
 * </li>
 * </ul>
 * <p>
 * The <code>DashboardId</code>, <code>SheetId</code>, and <code>VisualId</code> can be found in the
 * <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu of the
 * Amazon QuickSight console. You can also get the <code>DashboardId</code> with a <code>ListDashboards</code> API
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVisualId implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVisualId.Builder, DashboardVisualId> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DashboardVisualId::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(DashboardVisualId::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(DashboardVisualId::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            SHEET_ID_FIELD, VISUAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dashboardId;

    private final String sheetId;

    private final String visualId;

    private DashboardVisualId(BuilderImpl builder) {
        this.dashboardId = builder.dashboardId;
        this.sheetId = builder.sheetId;
        this.visualId = builder.visualId;
    }

    /**
     * <p>
     * The ID of the dashboard that has the visual that you want to embed. The <code>DashboardId</code> can be found in
     * the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu
     * of the Amazon QuickSight console. You can also get the <code>DashboardId</code> with a
     * <code>ListDashboards</code> API operation.
     * </p>
     * 
     * @return The ID of the dashboard that has the visual that you want to embed. The <code>DashboardId</code> can be
     *         found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the
     *         visual's on-visual menu of the Amazon QuickSight console. You can also get the <code>DashboardId</code>
     *         with a <code>ListDashboards</code> API operation.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The ID of the sheet that the has visual that you want to embed. The <code>SheetId</code> can be found in the
     * <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu of
     * the Amazon QuickSight console.
     * </p>
     * 
     * @return The ID of the sheet that the has visual that you want to embed. The <code>SheetId</code> can be found in
     *         the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's
     *         on-visual menu of the Amazon QuickSight console.
     */
    public final String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The ID of the visual that you want to embed. The <code>VisualID</code> can be found in the
     * <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu of
     * the Amazon QuickSight console.
     * </p>
     * 
     * @return The ID of the visual that you want to embed. The <code>VisualID</code> can be found in the
     *         <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual
     *         menu of the Amazon QuickSight console.
     */
    public final String visualId() {
        return visualId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVisualId)) {
            return false;
        }
        DashboardVisualId other = (DashboardVisualId) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(sheetId(), other.sheetId())
                && Objects.equals(visualId(), other.visualId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardVisualId").add("DashboardId", dashboardId()).add("SheetId", sheetId())
                .add("VisualId", visualId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("SheetId", SHEET_ID_FIELD);
        map.put("VisualId", VISUAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardVisualId, T> g) {
        return obj -> g.apply((DashboardVisualId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVisualId> {
        /**
         * <p>
         * The ID of the dashboard that has the visual that you want to embed. The <code>DashboardId</code> can be found
         * in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's
         * on-visual menu of the Amazon QuickSight console. You can also get the <code>DashboardId</code> with a
         * <code>ListDashboards</code> API operation.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard that has the visual that you want to embed. The <code>DashboardId</code> can
         *        be found in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the
         *        visual's on-visual menu of the Amazon QuickSight console. You can also get the
         *        <code>DashboardId</code> with a <code>ListDashboards</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The ID of the sheet that the has visual that you want to embed. The <code>SheetId</code> can be found in the
         * <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu
         * of the Amazon QuickSight console.
         * </p>
         * 
         * @param sheetId
         *        The ID of the sheet that the has visual that you want to embed. The <code>SheetId</code> can be found
         *        in the <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's
         *        on-visual menu of the Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The ID of the visual that you want to embed. The <code>VisualID</code> can be found in the
         * <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's on-visual menu
         * of the Amazon QuickSight console.
         * </p>
         * 
         * @param visualId
         *        The ID of the visual that you want to embed. The <code>VisualID</code> can be found in the
         *        <code>IDs for developers</code> section of the <code>Embed visual</code> pane of the visual's
         *        on-visual menu of the Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);
    }

    static final class BuilderImpl implements Builder {
        private String dashboardId;

        private String sheetId;

        private String visualId;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVisualId model) {
            dashboardId(model.dashboardId);
            sheetId(model.sheetId);
            visualId(model.visualId);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSheetId() {
            return sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        @Override
        public DashboardVisualId build() {
            return new DashboardVisualId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
