/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for default new sheet settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultNewSheetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultNewSheetConfiguration.Builder, DefaultNewSheetConfiguration> {
    private static final SdkField<DefaultInteractiveLayoutConfiguration> INTERACTIVE_LAYOUT_CONFIGURATION_FIELD = SdkField
            .<DefaultInteractiveLayoutConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InteractiveLayoutConfiguration")
            .getter(getter(DefaultNewSheetConfiguration::interactiveLayoutConfiguration))
            .setter(setter(Builder::interactiveLayoutConfiguration))
            .constructor(DefaultInteractiveLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InteractiveLayoutConfiguration")
                    .build()).build();

    private static final SdkField<DefaultPaginatedLayoutConfiguration> PAGINATED_LAYOUT_CONFIGURATION_FIELD = SdkField
            .<DefaultPaginatedLayoutConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PaginatedLayoutConfiguration")
            .getter(getter(DefaultNewSheetConfiguration::paginatedLayoutConfiguration))
            .setter(setter(Builder::paginatedLayoutConfiguration))
            .constructor(DefaultPaginatedLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginatedLayoutConfiguration")
                    .build()).build();

    private static final SdkField<String> SHEET_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetContentType").getter(getter(DefaultNewSheetConfiguration::sheetContentTypeAsString))
            .setter(setter(Builder::sheetContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTERACTIVE_LAYOUT_CONFIGURATION_FIELD, PAGINATED_LAYOUT_CONFIGURATION_FIELD, SHEET_CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration;

    private final DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration;

    private final String sheetContentType;

    private DefaultNewSheetConfiguration(BuilderImpl builder) {
        this.interactiveLayoutConfiguration = builder.interactiveLayoutConfiguration;
        this.paginatedLayoutConfiguration = builder.paginatedLayoutConfiguration;
        this.sheetContentType = builder.sheetContentType;
    }

    /**
     * <p>
     * The options that determine the default settings for interactive layout configuration.
     * </p>
     * 
     * @return The options that determine the default settings for interactive layout configuration.
     */
    public final DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration() {
        return interactiveLayoutConfiguration;
    }

    /**
     * <p>
     * The options that determine the default settings for a paginated layout configuration.
     * </p>
     * 
     * @return The options that determine the default settings for a paginated layout configuration.
     */
    public final DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration() {
        return paginatedLayoutConfiguration;
    }

    /**
     * <p>
     * The option that determines the sheet content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sheetContentType}
     * will return {@link SheetContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sheetContentTypeAsString}.
     * </p>
     * 
     * @return The option that determines the sheet content type.
     * @see SheetContentType
     */
    public final SheetContentType sheetContentType() {
        return SheetContentType.fromValue(sheetContentType);
    }

    /**
     * <p>
     * The option that determines the sheet content type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sheetContentType}
     * will return {@link SheetContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sheetContentTypeAsString}.
     * </p>
     * 
     * @return The option that determines the sheet content type.
     * @see SheetContentType
     */
    public final String sheetContentTypeAsString() {
        return sheetContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interactiveLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(paginatedLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sheetContentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultNewSheetConfiguration)) {
            return false;
        }
        DefaultNewSheetConfiguration other = (DefaultNewSheetConfiguration) obj;
        return Objects.equals(interactiveLayoutConfiguration(), other.interactiveLayoutConfiguration())
                && Objects.equals(paginatedLayoutConfiguration(), other.paginatedLayoutConfiguration())
                && Objects.equals(sheetContentTypeAsString(), other.sheetContentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultNewSheetConfiguration")
                .add("InteractiveLayoutConfiguration", interactiveLayoutConfiguration())
                .add("PaginatedLayoutConfiguration", paginatedLayoutConfiguration())
                .add("SheetContentType", sheetContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InteractiveLayoutConfiguration":
            return Optional.ofNullable(clazz.cast(interactiveLayoutConfiguration()));
        case "PaginatedLayoutConfiguration":
            return Optional.ofNullable(clazz.cast(paginatedLayoutConfiguration()));
        case "SheetContentType":
            return Optional.ofNullable(clazz.cast(sheetContentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InteractiveLayoutConfiguration", INTERACTIVE_LAYOUT_CONFIGURATION_FIELD);
        map.put("PaginatedLayoutConfiguration", PAGINATED_LAYOUT_CONFIGURATION_FIELD);
        map.put("SheetContentType", SHEET_CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultNewSheetConfiguration, T> g) {
        return obj -> g.apply((DefaultNewSheetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultNewSheetConfiguration> {
        /**
         * <p>
         * The options that determine the default settings for interactive layout configuration.
         * </p>
         * 
         * @param interactiveLayoutConfiguration
         *        The options that determine the default settings for interactive layout configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration);

        /**
         * <p>
         * The options that determine the default settings for interactive layout configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultInteractiveLayoutConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultInteractiveLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultInteractiveLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration)}.
         * 
         * @param interactiveLayoutConfiguration
         *        a consumer that will call methods on {@link DefaultInteractiveLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration)
         */
        default Builder interactiveLayoutConfiguration(
                Consumer<DefaultInteractiveLayoutConfiguration.Builder> interactiveLayoutConfiguration) {
            return interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration.builder()
                    .applyMutation(interactiveLayoutConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the default settings for a paginated layout configuration.
         * </p>
         * 
         * @param paginatedLayoutConfiguration
         *        The options that determine the default settings for a paginated layout configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration);

        /**
         * <p>
         * The options that determine the default settings for a paginated layout configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultPaginatedLayoutConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultPaginatedLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultPaginatedLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration)}.
         * 
         * @param paginatedLayoutConfiguration
         *        a consumer that will call methods on {@link DefaultPaginatedLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration)
         */
        default Builder paginatedLayoutConfiguration(
                Consumer<DefaultPaginatedLayoutConfiguration.Builder> paginatedLayoutConfiguration) {
            return paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration.builder()
                    .applyMutation(paginatedLayoutConfiguration).build());
        }

        /**
         * <p>
         * The option that determines the sheet content type.
         * </p>
         * 
         * @param sheetContentType
         *        The option that determines the sheet content type.
         * @see SheetContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetContentType
         */
        Builder sheetContentType(String sheetContentType);

        /**
         * <p>
         * The option that determines the sheet content type.
         * </p>
         * 
         * @param sheetContentType
         *        The option that determines the sheet content type.
         * @see SheetContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetContentType
         */
        Builder sheetContentType(SheetContentType sheetContentType);
    }

    static final class BuilderImpl implements Builder {
        private DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration;

        private DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration;

        private String sheetContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultNewSheetConfiguration model) {
            interactiveLayoutConfiguration(model.interactiveLayoutConfiguration);
            paginatedLayoutConfiguration(model.paginatedLayoutConfiguration);
            sheetContentType(model.sheetContentType);
        }

        public final DefaultInteractiveLayoutConfiguration.Builder getInteractiveLayoutConfiguration() {
            return interactiveLayoutConfiguration != null ? interactiveLayoutConfiguration.toBuilder() : null;
        }

        public final void setInteractiveLayoutConfiguration(
                DefaultInteractiveLayoutConfiguration.BuilderImpl interactiveLayoutConfiguration) {
            this.interactiveLayoutConfiguration = interactiveLayoutConfiguration != null ? interactiveLayoutConfiguration.build()
                    : null;
        }

        @Override
        public final Builder interactiveLayoutConfiguration(DefaultInteractiveLayoutConfiguration interactiveLayoutConfiguration) {
            this.interactiveLayoutConfiguration = interactiveLayoutConfiguration;
            return this;
        }

        public final DefaultPaginatedLayoutConfiguration.Builder getPaginatedLayoutConfiguration() {
            return paginatedLayoutConfiguration != null ? paginatedLayoutConfiguration.toBuilder() : null;
        }

        public final void setPaginatedLayoutConfiguration(
                DefaultPaginatedLayoutConfiguration.BuilderImpl paginatedLayoutConfiguration) {
            this.paginatedLayoutConfiguration = paginatedLayoutConfiguration != null ? paginatedLayoutConfiguration.build()
                    : null;
        }

        @Override
        public final Builder paginatedLayoutConfiguration(DefaultPaginatedLayoutConfiguration paginatedLayoutConfiguration) {
            this.paginatedLayoutConfiguration = paginatedLayoutConfiguration;
            return this;
        }

        public final String getSheetContentType() {
            return sheetContentType;
        }

        public final void setSheetContentType(String sheetContentType) {
            this.sheetContentType = sheetContentType;
        }

        @Override
        public final Builder sheetContentType(String sheetContentType) {
            this.sheetContentType = sheetContentType;
            return this;
        }

        @Override
        public final Builder sheetContentType(SheetContentType sheetContentType) {
            this.sheetContentType(sheetContentType == null ? null : sheetContentType.toString());
            return this;
        }

        @Override
        public DefaultNewSheetConfiguration build() {
            return new DefaultNewSheetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
