/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Conditional formatting options of a <code>FilledMapVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilledMapConditionalFormattingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<FilledMapConditionalFormattingOption.Builder, FilledMapConditionalFormattingOption> {
    private static final SdkField<FilledMapShapeConditionalFormatting> SHAPE_FIELD = SdkField
            .<FilledMapShapeConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("Shape")
            .getter(getter(FilledMapConditionalFormattingOption::shape)).setter(setter(Builder::shape))
            .constructor(FilledMapShapeConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shape").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilledMapShapeConditionalFormatting shape;

    private FilledMapConditionalFormattingOption(BuilderImpl builder) {
        this.shape = builder.shape;
    }

    /**
     * <p>
     * The conditional formatting that determines the shape of the filled map.
     * </p>
     * 
     * @return The conditional formatting that determines the shape of the filled map.
     */
    public final FilledMapShapeConditionalFormatting shape() {
        return shape;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilledMapConditionalFormattingOption)) {
            return false;
        }
        FilledMapConditionalFormattingOption other = (FilledMapConditionalFormattingOption) obj;
        return Objects.equals(shape(), other.shape());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilledMapConditionalFormattingOption").add("Shape", shape()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Shape":
            return Optional.ofNullable(clazz.cast(shape()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Shape", SHAPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilledMapConditionalFormattingOption, T> g) {
        return obj -> g.apply((FilledMapConditionalFormattingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilledMapConditionalFormattingOption> {
        /**
         * <p>
         * The conditional formatting that determines the shape of the filled map.
         * </p>
         * 
         * @param shape
         *        The conditional formatting that determines the shape of the filled map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(FilledMapShapeConditionalFormatting shape);

        /**
         * <p>
         * The conditional formatting that determines the shape of the filled map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FilledMapShapeConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link FilledMapShapeConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilledMapShapeConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #shape(FilledMapShapeConditionalFormatting)}.
         * 
         * @param shape
         *        a consumer that will call methods on {@link FilledMapShapeConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shape(FilledMapShapeConditionalFormatting)
         */
        default Builder shape(Consumer<FilledMapShapeConditionalFormatting.Builder> shape) {
            return shape(FilledMapShapeConditionalFormatting.builder().applyMutation(shape).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilledMapShapeConditionalFormatting shape;

        private BuilderImpl() {
        }

        private BuilderImpl(FilledMapConditionalFormattingOption model) {
            shape(model.shape);
        }

        public final FilledMapShapeConditionalFormatting.Builder getShape() {
            return shape != null ? shape.toBuilder() : null;
        }

        public final void setShape(FilledMapShapeConditionalFormatting.BuilderImpl shape) {
            this.shape = shape != null ? shape.build() : null;
        }

        @Override
        public final Builder shape(FilledMapShapeConditionalFormatting shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public FilledMapConditionalFormattingOption build() {
            return new FilledMapConditionalFormattingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
