/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a <code>FilledMapVisual</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilledMapFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<FilledMapFieldWells.Builder, FilledMapFieldWells> {
    private static final SdkField<FilledMapAggregatedFieldWells> FILLED_MAP_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<FilledMapAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("FilledMapAggregatedFieldWells")
            .getter(getter(FilledMapFieldWells::filledMapAggregatedFieldWells))
            .setter(setter(Builder::filledMapAggregatedFieldWells))
            .constructor(FilledMapAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilledMapAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FILLED_MAP_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilledMapAggregatedFieldWells filledMapAggregatedFieldWells;

    private FilledMapFieldWells(BuilderImpl builder) {
        this.filledMapAggregatedFieldWells = builder.filledMapAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field well of the filled map.
     * </p>
     * 
     * @return The aggregated field well of the filled map.
     */
    public final FilledMapAggregatedFieldWells filledMapAggregatedFieldWells() {
        return filledMapAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filledMapAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilledMapFieldWells)) {
            return false;
        }
        FilledMapFieldWells other = (FilledMapFieldWells) obj;
        return Objects.equals(filledMapAggregatedFieldWells(), other.filledMapAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilledMapFieldWells").add("FilledMapAggregatedFieldWells", filledMapAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilledMapAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(filledMapAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilledMapAggregatedFieldWells", FILLED_MAP_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilledMapFieldWells, T> g) {
        return obj -> g.apply((FilledMapFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilledMapFieldWells> {
        /**
         * <p>
         * The aggregated field well of the filled map.
         * </p>
         * 
         * @param filledMapAggregatedFieldWells
         *        The aggregated field well of the filled map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filledMapAggregatedFieldWells(FilledMapAggregatedFieldWells filledMapAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field well of the filled map.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilledMapAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link FilledMapAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilledMapAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #filledMapAggregatedFieldWells(FilledMapAggregatedFieldWells)}.
         * 
         * @param filledMapAggregatedFieldWells
         *        a consumer that will call methods on {@link FilledMapAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filledMapAggregatedFieldWells(FilledMapAggregatedFieldWells)
         */
        default Builder filledMapAggregatedFieldWells(
                Consumer<FilledMapAggregatedFieldWells.Builder> filledMapAggregatedFieldWells) {
            return filledMapAggregatedFieldWells(FilledMapAggregatedFieldWells.builder()
                    .applyMutation(filledMapAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilledMapAggregatedFieldWells filledMapAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(FilledMapFieldWells model) {
            filledMapAggregatedFieldWells(model.filledMapAggregatedFieldWells);
        }

        public final FilledMapAggregatedFieldWells.Builder getFilledMapAggregatedFieldWells() {
            return filledMapAggregatedFieldWells != null ? filledMapAggregatedFieldWells.toBuilder() : null;
        }

        public final void setFilledMapAggregatedFieldWells(FilledMapAggregatedFieldWells.BuilderImpl filledMapAggregatedFieldWells) {
            this.filledMapAggregatedFieldWells = filledMapAggregatedFieldWells != null ? filledMapAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder filledMapAggregatedFieldWells(FilledMapAggregatedFieldWells filledMapAggregatedFieldWells) {
            this.filledMapAggregatedFieldWells = filledMapAggregatedFieldWells;
            return this;
        }

        @Override
        public FilledMapFieldWells build() {
            return new FilledMapFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
