/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting that determines the shape of the filled map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilledMapShapeConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<FilledMapShapeConditionalFormatting.Builder, FilledMapShapeConditionalFormatting> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(FilledMapShapeConditionalFormatting::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<ShapeConditionalFormat> FORMAT_FIELD = SdkField
            .<ShapeConditionalFormat> builder(MarshallingType.SDK_POJO).memberName("Format")
            .getter(getter(FilledMapShapeConditionalFormatting::format)).setter(setter(Builder::format))
            .constructor(ShapeConditionalFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final ShapeConditionalFormat format;

    private FilledMapShapeConditionalFormatting(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.format = builder.format;
    }

    /**
     * <p>
     * The field ID of the filled map shape.
     * </p>
     * 
     * @return The field ID of the filled map shape.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The conditional formatting that determines the background color of a filled map's shape.
     * </p>
     * 
     * @return The conditional formatting that determines the background color of a filled map's shape.
     */
    public final ShapeConditionalFormat format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilledMapShapeConditionalFormatting)) {
            return false;
        }
        FilledMapShapeConditionalFormatting other = (FilledMapShapeConditionalFormatting) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilledMapShapeConditionalFormatting").add("FieldId", fieldId()).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilledMapShapeConditionalFormatting, T> g) {
        return obj -> g.apply((FilledMapShapeConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilledMapShapeConditionalFormatting> {
        /**
         * <p>
         * The field ID of the filled map shape.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the filled map shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The conditional formatting that determines the background color of a filled map's shape.
         * </p>
         * 
         * @param format
         *        The conditional formatting that determines the background color of a filled map's shape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(ShapeConditionalFormat format);

        /**
         * <p>
         * The conditional formatting that determines the background color of a filled map's shape.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShapeConditionalFormat.Builder} avoiding
         * the need to create one manually via {@link ShapeConditionalFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShapeConditionalFormat.Builder#build()} is called immediately and
         * its result is passed to {@link #format(ShapeConditionalFormat)}.
         * 
         * @param format
         *        a consumer that will call methods on {@link ShapeConditionalFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #format(ShapeConditionalFormat)
         */
        default Builder format(Consumer<ShapeConditionalFormat.Builder> format) {
            return format(ShapeConditionalFormat.builder().applyMutation(format).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private ShapeConditionalFormat format;

        private BuilderImpl() {
        }

        private BuilderImpl(FilledMapShapeConditionalFormatting model) {
            fieldId(model.fieldId);
            format(model.format);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final ShapeConditionalFormat.Builder getFormat() {
            return format != null ? format.toBuilder() : null;
        }

        public final void setFormat(ShapeConditionalFormat.BuilderImpl format) {
            this.format = format != null ? format.build() : null;
        }

        @Override
        public final Builder format(ShapeConditionalFormat format) {
            this.format = format;
            return this;
        }

        @Override
        public FilledMapShapeConditionalFormatting build() {
            return new FilledMapShapeConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
