/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the text display size.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FontSize implements SdkPojo, Serializable, ToCopyableBuilder<FontSize.Builder, FontSize> {
    private static final SdkField<String> RELATIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Relative").getter(getter(FontSize::relativeAsString)).setter(setter(Builder::relative))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relative").build()).build();

    private static final SdkField<String> ABSOLUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Absolute").getter(getter(FontSize::absolute)).setter(setter(Builder::absolute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Absolute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RELATIVE_FIELD, ABSOLUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relative;

    private final String absolute;

    private FontSize(BuilderImpl builder) {
        this.relative = builder.relative;
        this.absolute = builder.absolute;
    }

    /**
     * <p>
     * The lexical name for the text size, proportional to its surrounding context.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relative} will
     * return {@link RelativeFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relativeAsString}.
     * </p>
     * 
     * @return The lexical name for the text size, proportional to its surrounding context.
     * @see RelativeFontSize
     */
    public final RelativeFontSize relative() {
        return RelativeFontSize.fromValue(relative);
    }

    /**
     * <p>
     * The lexical name for the text size, proportional to its surrounding context.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relative} will
     * return {@link RelativeFontSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relativeAsString}.
     * </p>
     * 
     * @return The lexical name for the text size, proportional to its surrounding context.
     * @see RelativeFontSize
     */
    public final String relativeAsString() {
        return relative;
    }

    /**
     * <p>
     * The font size that you want to use in px.
     * </p>
     * 
     * @return The font size that you want to use in px.
     */
    public final String absolute() {
        return absolute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relativeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(absolute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontSize)) {
            return false;
        }
        FontSize other = (FontSize) obj;
        return Objects.equals(relativeAsString(), other.relativeAsString()) && Objects.equals(absolute(), other.absolute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FontSize").add("Relative", relativeAsString()).add("Absolute", absolute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Relative":
            return Optional.ofNullable(clazz.cast(relativeAsString()));
        case "Absolute":
            return Optional.ofNullable(clazz.cast(absolute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Relative", RELATIVE_FIELD);
        map.put("Absolute", ABSOLUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FontSize, T> g) {
        return obj -> g.apply((FontSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FontSize> {
        /**
         * <p>
         * The lexical name for the text size, proportional to its surrounding context.
         * </p>
         * 
         * @param relative
         *        The lexical name for the text size, proportional to its surrounding context.
         * @see RelativeFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeFontSize
         */
        Builder relative(String relative);

        /**
         * <p>
         * The lexical name for the text size, proportional to its surrounding context.
         * </p>
         * 
         * @param relative
         *        The lexical name for the text size, proportional to its surrounding context.
         * @see RelativeFontSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativeFontSize
         */
        Builder relative(RelativeFontSize relative);

        /**
         * <p>
         * The font size that you want to use in px.
         * </p>
         * 
         * @param absolute
         *        The font size that you want to use in px.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absolute(String absolute);
    }

    static final class BuilderImpl implements Builder {
        private String relative;

        private String absolute;

        private BuilderImpl() {
        }

        private BuilderImpl(FontSize model) {
            relative(model.relative);
            absolute(model.absolute);
        }

        public final String getRelative() {
            return relative;
        }

        public final void setRelative(String relative) {
            this.relative = relative;
        }

        @Override
        public final Builder relative(String relative) {
            this.relative = relative;
            return this;
        }

        @Override
        public final Builder relative(RelativeFontSize relative) {
            this.relative(relative == null ? null : relative.toString());
            return this;
        }

        public final String getAbsolute() {
            return absolute;
        }

        public final void setAbsolute(String absolute) {
            this.absolute = absolute;
        }

        @Override
        public final Builder absolute(String absolute) {
            this.absolute = absolute;
            return this;
        }

        @Override
        public FontSize build() {
            return new FontSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
